-----------------------------------------------------------------------------------------------------------------------
--- TABLE CONSENTS table
-----------------------------------------------------------------------------------------------------------------------

DELIMITER $$
CREATE TABLE IF NOT EXISTS DIF.DATA_CONSENT
(
  ID                     INT NOT NULL AUTO_INCREMENT COMMENT 'ID', 
  CONFIG_ID              VARCHAR(255) NOT NULL  COMMENT 'Configuration ID (each application can have a diferent set of consents)',
  BUSINESS_ID            VARCHAR(255) NOT NULL  COMMENT 'Business UID that identifies this consent within the configuration',
  TITLE                  VARCHAR(1000) NOT NULL COMMENT 'The title',
  DESCRIPTION            LONGTEXT NOT NULL      COMMENT 'A full description',
  TEMPLATE_DOCUMENT_ID   MEDIUMINT(9) 			COMMENT 'The proof template for the user to download and sign',
  PROFILE_ID             VARCHAR(255) NOT NULL  COMMENT 'The destination profile for the consent',
  IS_MUST_UPLOAD_PROOF   TINYINT(1) NOT NULL    COMMENT 'Must confirm acceptance by signed document',
  IS_MUST_CONFIRM_BYMAIL TINYINT(1) NOT NULL    COMMENT 'Must confirm acceptance by email',
  IS_MANDATORY           TINYINT(1) NOT NULL    COMMENT 'Is mandatory',
  IS_PROTECTED           TINYINT(1) NOT NULL    COMMENT 'Is protected',
  IS_ENABLED             TINYINT(1) NOT NULL    COMMENT 'Is enabled',
  PRIMARY KEY (`ID`), 
  INDEX `DATA_CONSENT_BUSINESS_ID_IDX` (`BUSINESS_ID`),
  INDEX `DATA_CONSENT_CONFIG_ID_IDX` (`CONFIG_ID`,`BUSINESS_ID`)
)ENGINE=INNODB DEFAULT CHARSET=UTF8 COLLATE=UTF8_BIN$$

-----------------------------------------------------------------------------------------------------------------------
--- DATA CONSENT TRANSLATION table
-----------------------------------------------------------------------------------------------------------------------

DELIMITER $$
CREATE TABLE IF NOT EXISTS DIF.DATA_CONSENT_TRANS
(
  ID                     INT NOT NULL AUTO_INCREMENT COMMENT 'ID', 
  CONSENT_ID             INT NOT NULL           COMMENT 'The consent',
  LANGUAGE_ID            VARCHAR(10) NOT NULL   COMMENT 'The language ID',
  TITLE                  VARCHAR(1000) NOT NULL COMMENT 'The title translation',
  DESCRIPTION            LONGTEXT               COMMENT 'The description translation',
  PRIMARY KEY (`ID`), 
  KEY `FK_DATA_CONSENT_TRANS_CONSENT` (`CONSENT_ID`),
  CONSTRAINT `FK_DATA_CONSENT_TRANS_CONSENT` FOREIGN KEY (`CONSENT_ID`) REFERENCES `DATA_CONSENT` (`ID`) ON DELETE CASCADE ON UPDATE NO ACTION
)ENGINE=INNODB DEFAULT CHARSET=UTF8 COLLATE=UTF8_BIN$$

-----------------------------------------------------------------------------------------------------------------------
--- DATA CONSENT REVIEW table
-----------------------------------------------------------------------------------------------------------------------

DELIMITER $$
CREATE TABLE IF NOT EXISTS DIF.DATA_CONSENT_REVIEW
(
  ID                     INT NOT NULL AUTO_INCREMENT COMMENT 'ID', 
  CONSENT_ID             INT NOT NULL           COMMENT 'The consent ID',
  USER_ID                VARCHAR(255) NOT NULL  COMMENT 'The user ID',
  LAST_REVIEW_DATE       DATETIME NOT NULL COMMENT 'The last review date',
  PRIMARY KEY (`ID`), 
  INDEX `DATA_CONSENT_REVIEW_USER_ID_IDX` (`USER_ID`),
  KEY `FK_DATA_CONSENT_REVIEW_CONSENT` (`CONSENT_ID`),
  CONSTRAINT `FK_DATA_CONSENT_REVIEW_CONSENT` FOREIGN KEY (`CONSENT_ID`) REFERENCES `DATA_CONSENT` (`ID`) ON DELETE CASCADE ON UPDATE NO ACTION
)ENGINE=INNODB DEFAULT CHARSET=UTF8 COLLATE=UTF8_BIN$$

-----------------------------------------------------------------------------------------------------------------------
--- USER DATA CONSENT table
-----------------------------------------------------------------------------------------------------------------------

DELIMITER $$
CREATE TABLE IF NOT EXISTS DIF.USER_DATA_CONSENT
(
  ID                     INT NOT NULL AUTO_INCREMENT COMMENT 'ID', 
  CONSENT_ID             INT NOT NULL           COMMENT 'The consent ID',
  USER_ID                VARCHAR(255) NOT NULL  COMMENT 'The user ID',
  DATE_GIVEN             DATETIME NOT NULL      COMMENT 'The date the user gave consent',
  DATE_CONFIRMED         DATETIME               COMMENT 'The date the user confirmed his consent',
  DATE_REVOKED           DATETIME               COMMENT 'The date the user revoked the given consent',
  PROOF_DOCUMENT_ID      MEDIUMINT(9)           COMMENT 'The document the user upload as proof of his consent',
  STATE                  VARCHAR(1) NOT NULL    COMMENT 'The consent state',
  PRIMARY KEY (`ID`), 
  INDEX `DATA_CONSENT_REVIEW_USER_ID_IDX` (`USER_ID`),
  INDEX `USER_DATA_CONSENT_CONSENT_ID_IDX` (`CONSENT_ID`),
  KEY `FK_USER_DATA_CONSENT_CONSENT` (`CONSENT_ID`),
  CONSTRAINT `FK_USER_DATA_CONSENT_CONSENT` FOREIGN KEY (`CONSENT_ID`) REFERENCES `DATA_CONSENT` (`ID`) ON DELETE CASCADE ON UPDATE NO ACTION
)ENGINE=INNODB DEFAULT CHARSET=UTF8 COLLATE=UTF8_BIN$$

-----------------------------------------------------------------------------------------------------------------------
--- USER DATA REQUEST table
-----------------------------------------------------------------------------------------------------------------------

DELIMITER $$
CREATE TABLE IF NOT EXISTS DIF.USER_DATA_REQUEST
(
  ID                     INT NOT NULL AUTO_INCREMENT COMMENT 'ID', 
  BUSINESSUID            VARCHAR(255) NOT NULL  COMMENT 'Business UID that identifies this consent within the configuration',
  REQUEST_TYPE           VARCHAR(10) NOT NULL   COMMENT 'The request type',
  USER_ID                VARCHAR(255) NOT NULL  COMMENT 'The user ID',
  TITLE                  VARCHAR(500) NOT NULL  COMMENT 'The request title',
  REQUEST_DATE           DATETIME NOT NULL      COMMENT 'The request date',
  BODY                   VARCHAR(4000) NOT NULL COMMENT 'The user request explanation',
  HANDLER_USER_ID        VARCHAR(255)           COMMENT 'The user that is handling the request',
  CLOSE_DATE             DATETIME               COMMENT 'When the request was closed',
  RESPONSE_DOCUMENT_ID   MEDIUMINT(9)           COMMENT 'The response document if any',
  STATE                  VARCHAR(1) NOT NULL    COMMENT 'The request state',
  PRIMARY KEY (`ID`), 
  INDEX `USER_DATA_REQUEST_USER_ID_IDX` (`USER_ID`,`REQUEST_DATE`),
  INDEX `USER_DATA_REQUEST_HANDLER_ID_IDX` (`HANDLER_USER_ID`,`REQUEST_DATE`)
)ENGINE=INNODB DEFAULT CHARSET=UTF8 COLLATE=UTF8_BIN$$

-----------------------------------------------------------------------------------------------------------------------
--- USER DATA REQUEST COMMENT table
-----------------------------------------------------------------------------------------------------------------------

DELIMITER $$
CREATE TABLE IF NOT EXISTS DIF.USER_DATA_REQUEST_COMMENT
(
  ID                     INT NOT NULL AUTO_INCREMENT COMMENT 'ID', 
  REQUEST_ID             INT NOT NULL           COMMENT 'The request id',
  USER_ID                VARCHAR(255) NOT NULL  COMMENT 'The user ID',
  COMMENT                VARCHAR(4000) NOT NULL COMMENT 'The comment',
  DATE                   DATETIME NOT NULL      COMMENT 'The comment date',
  PRIMARY KEY (`ID`), 
  INDEX `USER_DATA_REQ_CMT_REQ_ID_IDX` (`REQUEST_ID`,`DATE`),
  KEY `FK_USER_DATA_REQ_CMT_REQ` (`REQUEST_ID`),
  CONSTRAINT `FK_USER_DATA_REQ_CMT_REQ` FOREIGN KEY (`REQUEST_ID`) REFERENCES `USER_DATA_REQUEST` (`ID`) ON DELETE CASCADE ON UPDATE NO ACTION
)ENGINE=INNODB DEFAULT CHARSET=UTF8 COLLATE=UTF8_BIN$$
