DELIMITER $$

DROP PROCEDURE IF EXISTS createColumn;
$$

CREATE PROCEDURE createColumn()
BEGIN
	DECLARE TOTAL INT;

	SELECT COUNT(*)
	INTO TOTAL
	FROM information_schema.COLUMNS c
	WHERE TABLE_SCHEMA = 'DIF' 
	AND TABLE_NAME = 'REPORT_INSTANCE_AREA' 
	AND COLUMN_NAME = 'LANGUAGE'
    AND CHARACTER_MAXIMUM_LENGTH = 2;

	IF TOTAL = 0 THEN
		ALTER TABLE `DIF`.`REPORT_INSTANCE_AREA` MODIFY COLUMN `LANGUAGE` VARCHAR(5);
    END IF;
END
$$

CALL createColumn();
$$

DROP PROCEDURE IF EXISTS createColumn;
$$

