DELIMITER $$

DROP PROCEDURE IF EXISTS updateColumn;
$$

CREATE PROCEDURE updateColumn()
BEGIN
	DECLARE TOTAL INT;

    SELECT CHARACTER_MAXIMUM_LENGTH
    INTO TOTAL
	FROM information_schema.COLUMNS 
	WHERE TABLE_SCHEMA = 'DIF' 
	AND TABLE_NAME = 'ACCESS_LOG' 
	AND COLUMN_NAME = 'CLIENT_IP';
	
	IF TOTAL < 60 THEN
		ALTER TABLE `DIF`.`ACCESS_LOG` CHANGE COLUMN `CLIENT_IP` `EMAIL` VARCHAR(60) NULL DEFAULT NULL;
    END IF;
END
$$

CALL updateColumn();
$$

DROP PROCEDURE IF EXISTS updateColumn;
$$
