DELIMITER $$

DROP PROCEDURE IF EXISTS createColumn;
$$

CREATE PROCEDURE createColumn()
BEGIN
	DECLARE TOTAL INT;

	SELECT COUNT(*)
	INTO TOTAL
	FROM information_schema.COLUMNS 
	WHERE TABLE_SCHEMA = 'DIF' 
	AND TABLE_NAME = 'T_ECOMMERCE_PAYMENTS' 
	AND COLUMN_NAME = 'ERROR_FRIENDLY_USER_MESSAGE';

	IF TOTAL = 0 THEN
		ALTER TABLE `DIF`.`T_ECOMMERCE_PAYMENTS` ADD COLUMN `ERROR_FRIENDLY_USER_MESSAGE` VARCHAR(500);
    END IF;
END
$$

CALL createColumn();
$$

DROP PROCEDURE IF EXISTS createColumn;
$$
