DELIMITER $$

DROP PROCEDURE IF EXISTS RETIFYCONFIGURATIONS;
$$

CREATE PROCEDURE RETIFYCONFIGURATIONS()
BEGIN
	DECLARE NTOTAL_VALORES_DIFERENTES INT;
	DECLARE NCONFIG_NODE_ID INT;
	DECLARE NCONFIG_SET_ID INT;
	DECLARE SNODE_PATH VARCHAR(4000);
	DECLARE NMIN_CONF_ID INT;
	DECLARE SKEY VARCHAR(500);
	DECLARE SAVISOS VARCHAR(4000);

	DECLARE EXIT_LOOP BOOLEAN DEFAULT FALSE;

	DECLARE CURSOR_T CURSOR FOR   SELECT P.CONFIG_SET_ID, P.NODE_PATH, MIN(P.ID) MIN_CONF_ID
	    			              FROM DIF.CONFIG_NODE P
					              GROUP BY P.CONFIG_SET_ID, P.NODE_PATH
					              HAVING COUNT(*) > 1;
					              
	DECLARE CURSOR_I CURSOR FOR SELECT  P.CONFIG_NODE_ID, 
					                    P.`KEY` , 
					                    COUNT(DISTINCT COALESCE(VALUE,'-1111111111111111')) TOTAL_VALORES_DIFERENTES,
                   						MIN(P.ID) MIN_CONF_ID
					             FROM DIF.CONFIGURATION P
					             GROUP BY P.CONFIG_NODE_ID, `KEY` 
					             HAVING COUNT(*) > 1;
					             
	DECLARE CONTINUE HANDLER FOR NOT FOUND SET EXIT_LOOP = TRUE;
					              

	OPEN CURSOR_T;
	
	READ_LOOP: LOOP
	  FETCH CURSOR_T INTO NCONFIG_SET_ID, SNODE_PATH, NMIN_CONF_ID;
	  
	  IF EXIT_LOOP THEN
		LEAVE READ_LOOP;
	  END IF;
	  
	  SELECT COUNT(*), MAX(`KEY`)
	  INTO NTOTAL_VALORES_DIFERENTES, SKEY
	  FROM (
		  SELECT COUNT(DISTINCT COALESCE(VALUE,-1111111111111111)) TOTAL_VALORES_DIFERENTES, C.KEY
	      FROM DIF.CONFIG_NODE CN
	      INNER JOIN DIF.CONFIGURATION C ON C.CONFIG_NODE_ID = CN.ID
	      WHERE CN.CONFIG_SET_ID = NCONFIG_SET_ID
	      AND   CN.NODE_PATH = SNODE_PATH
	      GROUP BY CN.CONFIG_SET_ID, CN.NODE_PATH,C.KEY
	      HAVING COUNT(DISTINCT COALESCE(VALUE,-1111111111111111)) > 1) A;

	     
      IF NTOTAL_VALORES_DIFERENTES > 1 THEN
      
        SET SAVISOS = CONCAT(COALESCE(SAVISOS,''), 
                    ' - KEY = ''' , SKEY , '''' ,
                    ' CONFIG_SET_ID = ', NCONFIG_SET_ID , 
                    ' NODE_PATH = ''', SNODE_PATH , '''');
 
                    /* SELECT * FROM DIF.CONFIGURATION C
                     WHERE C.KEY = 
                       AND (C.CONFIG_NODE_ID) IN
                           (SELECT ID
                              FROM DIF.CONFIG_NODE CN
                             WHERE CONFIG_SET_ID =  
                               AND NODE_PATH = ) */                    
                    
      ELSE

        DELETE FROM DIF.CONFIG_NODE
        WHERE CONFIG_SET_ID = NCONFIG_SET_ID
        AND   NODE_PATH     = SNODE_PATH
        AND   ID            != NMIN_CONF_ID;
      END IF;      
      
	   
	      
	END LOOP;
	
	CLOSE CURSOR_T;
	
	
	
  
	OPEN CURSOR_I;
	
	READ_LOOP: LOOP
	  FETCH CURSOR_I INTO NCONFIG_NODE_ID, SKEY, NTOTAL_VALORES_DIFERENTES, NMIN_CONF_ID;
	  
	  IF EXIT_LOOP THEN
		LEAVE READ_LOOP;
	  END IF;

	  IF NTOTAL_VALORES_DIFERENTES > 1 THEN
        SET SAVISOS = CONCAT(SAVISOS, 
                   '- SELECT *' ,
                   ' FROM DIF.CONFIGURATION C ' ,
                   ' WHERE C.CONFIG_NODE_ID = ' , NCONFIG_NODE_ID , 
                   ' AND KEY = ''', SKEY , '''');
      ELSE
          DELETE FROM DIF.CONFIGURATION
	      WHERE CONFIG_NODE_ID = NCONFIG_NODE_ID
	      AND   `KEY`          = SKEY
	      AND   ID             != NMIN_CONF_ID;
      END IF;

      COMMIT;
	END LOOP;
	
	CLOSE CURSOR_I;
	
	IF SAVISOS IS NOT NULL THEN
	  	SET SAVISOS = SUBSTR(SAVISOS,1,128);

	     SIGNAL SQLSTATE '23000' SET 
	       MYSQL_ERRNO = 1452,
	       MESSAGE_TEXT = SAVISOS;        
    END IF;
END
$$

CALL RETIFYCONFIGURATIONS();
$$

DROP PROCEDURE IF EXISTS RETIFYCONFIGURATIONS;
$$

-- -----------------------------------------------------
-- Create Constraint 'CONFIGURATION_UK' 
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS createConstraint;
$$
CREATE PROCEDURE createConstraint()
BEGIN
	DECLARE TOTAL INT;

	SELECT COUNT(*)
	INTO TOTAL
	FROM   INFORMATION_SCHEMA.TABLE_CONSTRAINTS
	where table_schema = 'DIF'
	and table_name = 'CONFIGURATION'
	and constraint_name = 'CONFIGURATION_UK';

	IF TOTAL = 0 THEN
		ALTER TABLE `DIF`.`CONFIGURATION`
			ADD CONSTRAINT `CONFIGURATION_UK`
			  UNIQUE KEY (CONFIG_NODE_ID,`KEY`(250));
    END IF;
END
$$
CALL createConstraint();
$$
DROP PROCEDURE IF EXISTS createConstraint;
$$


-- -----------------------------------------------------
-- Create Constraint 'CONFIG_NODE_UK' 
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS createConstraint;
$$
CREATE PROCEDURE createConstraint()
BEGIN
	DECLARE TOTAL INT;

	SELECT COUNT(*)
	INTO TOTAL
	FROM   INFORMATION_SCHEMA.TABLE_CONSTRAINTS
	where table_schema = 'DIF'
	and table_name = 'CONFIG_NODE'
	and constraint_name = 'CONFIG_NODE_UK';

	IF TOTAL = 0 THEN
		ALTER TABLE `DIF`.`CONFIG_NODE`
			ADD CONSTRAINT `CONFIG_NODE_UK`
			  UNIQUE KEY (CONFIG_SET_ID, NODE_PATH(250));
    END IF;
END
$$
CALL createConstraint();
$$
DROP PROCEDURE IF EXISTS createConstraint;
$$