DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'ERROR_LOG';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE
      'CREATE TABLE DIF.ERROR_LOG( '||
      '  ID            			NUMBER(9) NOT NULL, '||
      '  PROCESS_NAME  			VARCHAR2(70), '||
      '  ERROR_DESCRIPTION    	CLOB, '||
      '  ERRO_DATE   			DATE DEFAULT SYSDATE NOT NULL '||
      ') ';
      EXECUTE IMMEDIATE 'comment on column DIF.ERROR_LOG.ID is ''Unique identifier for PK''';
      EXECUTE IMMEDIATE 'comment on column DIF.ERROR_LOG.PROCESS_NAME is ''THE PROCESS NAME''';
      EXECUTE IMMEDIATE 'comment on column DIF.ERROR_LOG.ERROR_DESCRIPTION is ''THE ERROR DESCRIPTION''';
      EXECUTE IMMEDIATE 'comment on column DIF.ERROR_LOG.ERRO_DATE is ''THE DATE WHEN THE ERROR WAS LOGGED''';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'ERROR_LOG'
  AND    CONSTRAINT_NAME = 'ERROR_LOG_PK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.ERROR_LOG ADD CONSTRAINT ERROR_LOG_PK PRIMARY KEY (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_SEQUENCES
  WHERE  SEQUENCE_OWNER  = 'DIF'
  AND    SEQUENCE_NAME   = 'SEQ_ID_ERROR_LOG';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_ERROR_LOG MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
  END IF;
END;
/