DECLARE
  TOTAL NUMBER;
BEGIN
	SELECT COUNT(*)
  	INTO   TOTAL
  	FROM   ALL_TAB_COLUMNS
  	WHERE  OWNER      = 'DIF'
  	AND    TABLE_NAME = 'AUDIT_LOG'
  	AND    COLUMN_NAME = 'PROCESS';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 	'alter table DIF.AUDIT_LOG modify app null';
    EXECUTE IMMEDIATE 	'alter table DIF.AUDIT_LOG add process VARCHAR2(300) null';
    EXECUTE IMMEDIATE 	'update DIF.audit_log set process = app, app = null';
    EXECUTE IMMEDIATE 	'alter table DIF.AUDIT_LOG modify process not null';
  END IF;
END;
/

comment on column DIF.AUDIT_LOG.process is 'The process name';

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_INDEXES
  WHERE  OWNER           = 'DIF'
  AND    INDEX_NAME      = 'AUDIT_LOG_PROC';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'create index DIF.AUDIT_LOG_PROC on DIF.AUDIT_LOG (process, entity_name, operation_date)';
  END IF;
END;
/

alter table DIF.AUDIT_LOG modify app VARCHAR2(300);

alter table DIF.AUDIT_LOG modify process VARCHAR2(300);