DECLARE
  TOTAL NUMBER;
BEGIN
	SELECT COUNT(*)
  	INTO   TOTAL
  	FROM   ALL_TAB_COLUMNS 
  	WHERE  OWNER      = 'DIF'
  	AND    TABLE_NAME = 'DATA_CONSENT'
  	AND    COLUMN_NAME = 'STAGE_ID';
	
  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 	'ALTER TABLE DIF.DATA_CONSENT ADD STAGE_ID VARCHAR2(500)';
  END IF;
END;
/

COMMENT ON COLUMN dif.DATA_CONSENT.STAGE_ID IS 'Stage ID for complex consent details';

DECLARE
  TOTAL NUMBER;
BEGIN
	SELECT COUNT(*)
  	INTO   TOTAL
  	FROM   ALL_TAB_COLUMNS 
  	WHERE  OWNER      = 'DIF'
  	AND    TABLE_NAME = 'DATA_CONSENT'
  	AND    COLUMN_NAME = 'IS_GLOBAL';
	
  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 	'ALTER TABLE DIF.DATA_CONSENT ADD IS_GLOBAL NUMBER(1)';
  END IF;
END;
/

COMMENT ON COLUMN dif.DATA_CONSENT.IS_GLOBAL IS 'Is global consent. Managed globally. If false will not be requested centrally.';

UPDATE DIF.DATA_CONSENT SET IS_GLOBAL = 1 WHERE IS_GLOBAL IS NULL;

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TAB_COLUMNS 
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'DATA_CONSENT'
  AND    COLUMN_NAME = 'IS_GLOBAL'
  AND    NULLABLE    = 'N';
      
  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.DATA_CONSENT MODIFY IS_GLOBAL NOT NULL';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
	SELECT COUNT(*)
  	INTO   TOTAL
  	FROM   ALL_TAB_COLUMNS 
  	WHERE  OWNER      = 'DIF'
  	AND    TABLE_NAME = 'DATA_CONSENT'
  	AND    COLUMN_NAME = 'IS_ANSWERED_WHEN_DISABLED';
	
  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 	'ALTER TABLE DIF.DATA_CONSENT ADD IS_ANSWERED_WHEN_DISABLED NUMBER(1)';
  END IF;
END;
/

COMMENT ON COLUMN dif.DATA_CONSENT.IS_ANSWERED_WHEN_DISABLED IS 'Is considered anwsered when the consent is disabled.';

UPDATE DIF.DATA_CONSENT SET IS_ANSWERED_WHEN_DISABLED = 0 WHERE IS_ANSWERED_WHEN_DISABLED IS NULL;

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TAB_COLUMNS 
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'DATA_CONSENT'
  AND    COLUMN_NAME = 'IS_ANSWERED_WHEN_DISABLED'
  AND    NULLABLE    = 'N';
      
  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.DATA_CONSENT MODIFY IS_ANSWERED_WHEN_DISABLED NOT NULL';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
	SELECT COUNT(*)
  	INTO   TOTAL
  	FROM   ALL_TAB_COLUMNS 
  	WHERE  OWNER      = 'DIF'
  	AND    TABLE_NAME = 'USER_DATA_CONSENT'
  	AND    COLUMN_NAME = 'DETAILS';
	
  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 	'ALTER TABLE DIF.USER_DATA_CONSENT ADD DETAILS CLOB';
  END IF;
END;
/

COMMENT ON COLUMN dif.USER_DATA_CONSENT.DETAILS IS 'Details in JSON format of the consent given (when there is more than a simples yes or no)';

DECLARE
  TOTAL NUMBER;
BEGIN
  /*O VALOR 200 FOI DETERMINADO PORQUE NO MYSQL A TABELA FOI CRIADA COM ESSE VALOR*/
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TAB_COLUMNS 
  WHERE  OWNER       = 'DIF'
  AND    TABLE_NAME  = 'ACCESS_LOG'
  AND    COLUMN_NAME = 'USER_ID'
  AND    DATA_LENGTH < 200;
      
  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.ACCESS_LOG MODIFY USER_ID VARCHAR2(200)';
  END IF;
END;
/
