-----------------------------------------------------------------------------------------------------------------------
--- TABLE JASPER_REPORT_TEMPLATE table
-----------------------------------------------------------------------------------------------------------------------

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'JASPER_REPORT_TEMPLATE';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE
      'CREATE TABLE DIF.JASPER_REPORT_TEMPLATE( '||
      '  ID                     NUMBER(10) NOT NULL, '||
      '  CONFIG_ID              VARCHAR2(255) NOT NULL, '||
      '  BUSINESS_ID            VARCHAR2(255), '||
      '  TITLE                  VARCHAR2(500) NOT NULL, '||
      '  DESCRIPTION            CLOB, '||
      '  TYPE                   NUMBER(2) NOT NULL, '||
      '  TEMPLATE_PATH          VARCHAR2(1000), '||
      '  IS_ENABLED             NUMBER(1) NOT NULL,'||
      '  TEMPLATE_FILE_ID       NUMBER(10)'||
      ') ';
  END IF;
END;
/

COMMENT ON COLUMN dif.JASPER_REPORT_TEMPLATE.ID IS 'ID';
COMMENT ON COLUMN dif.JASPER_REPORT_TEMPLATE.CONFIG_ID IS 'Configuration ID (each application can have a diferent set of templates)';
COMMENT ON COLUMN dif.JASPER_REPORT_TEMPLATE.TITLE IS 'The title';
COMMENT ON COLUMN dif.JASPER_REPORT_TEMPLATE.DESCRIPTION IS 'A full description';
COMMENT ON COLUMN dif.JASPER_REPORT_TEMPLATE.TYPE IS 'The template type 1=TemplatePathOnServer,2=TemplateUploadedFiles';
COMMENT ON COLUMN dif.JASPER_REPORT_TEMPLATE.TEMPLATE_PATH IS 'The jasper report template path';
COMMENT ON COLUMN dif.JASPER_REPORT_TEMPLATE.IS_ENABLED IS 'Is enabled';
COMMENT ON COLUMN dif.JASPER_REPORT_TEMPLATE.TEMPLATE_FILE_ID IS 'The jasper report template file';

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'JASPER_REPORT_TEMPLATE'
  AND    CONSTRAINT_NAME = 'JASPER_REPORT_TEMPLATE_PK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.JASPER_REPORT_TEMPLATE ADD CONSTRAINT JASPER_REPORT_TEMPLATE_PK PRIMARY KEY (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_SEQUENCES
  WHERE  SEQUENCE_OWNER  = 'DIF'
  AND    SEQUENCE_NAME   = 'SEQ_ID_JASPER_REPORT_TEMPLATE';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_JASPER_REPORT_TEMPLATE MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_INDEXES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'JASPER_REPORT_TEMPLATE'
  AND    INDEX_NAME = 'JASPER_REPT_TEMP_CONF_ID_IDX';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE INDEX DIF.JASPER_REPT_TEMP_CONF_ID_IDX '||
                      'ON DIF.JASPER_REPORT_TEMPLATE (CONFIG_ID,TITLE) '||
                      'TABLESPACE INDX PCTFREE 10 INITRANS 2 MAXTRANS 255 '||
                      'STORAGE (INITIAL 64K MINEXTENTS 1 MAXEXTENTS UNLIMITED)';
  END IF;
END;
/

-----------------------------------------------------------------------------------------------------------------------
--- JASPER_REPORT_TEMPLATE_FILE table
-----------------------------------------------------------------------------------------------------------------------

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'JASPER_REPORT_TEMPLATE_FILE';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE
      'CREATE TABLE DIF.JASPER_REPORT_TEMPLATE_FILE( '||
      '  ID                     NUMBER(10) NOT NULL, '||
      '  TEMPLATE_ID            NUMBER(10) NOT NULL, '||
      '  FILE_NAME              VARCHAR2(1500) NOT NULL, '||
      '  FILE_TYPE              VARCHAR2(50) NOT NULL, '||
      '  FILE_SIZE              NUMBER NOT NULL, '||
      '  DOCUMENT_ID            NUMBER(10) NOT NULL '||
      ') ';
  END IF;
END;
/

COMMENT ON COLUMN dif.JASPER_REPORT_TEMPLATE_FILE.ID IS 'ID';
COMMENT ON COLUMN dif.JASPER_REPORT_TEMPLATE_FILE.TEMPLATE_ID IS 'The template the file belongs to';
COMMENT ON COLUMN dif.JASPER_REPORT_TEMPLATE_FILE.FILE_NAME IS 'The file name';
COMMENT ON COLUMN dif.JASPER_REPORT_TEMPLATE_FILE.FILE_TYPE IS 'The file type (mime type)';
COMMENT ON COLUMN dif.JASPER_REPORT_TEMPLATE_FILE.FILE_SIZE IS 'The file size';
COMMENT ON COLUMN dif.JASPER_REPORT_TEMPLATE_FILE.DOCUMENT_ID IS 'The document in the documento repository ID';


DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'JASPER_REPORT_TEMPLATE_FILE'
  AND    CONSTRAINT_NAME = 'JASPER_REPT_TEMP_FILE_PK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.JASPER_REPORT_TEMPLATE_FILE ADD CONSTRAINT JASPER_REPT_TEMP_FILE_PK PRIMARY KEY (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_SEQUENCES
  WHERE  SEQUENCE_OWNER  = 'DIF'
  AND    SEQUENCE_NAME   = 'SEQ_ID_JASPER_REPT_TEMP_FILE';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_JASPER_REPT_TEMP_FILE MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'JASPER_REPORT_TEMPLATE_FILE'
  AND    CONSTRAINT_NAME = 'FK_JASPER_TEMP_FILE_TEMPLATE';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.JASPER_REPORT_TEMPLATE_FILE ADD CONSTRAINT FK_JASPER_TEMP_FILE_TEMPLATE FOREIGN KEY (TEMPLATE_ID) REFERENCES DIF.JASPER_REPORT_TEMPLATE (ID) ON DELETE CASCADE';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'JASPER_REPORT_TEMPLATE'
  AND    CONSTRAINT_NAME = 'FK_JASPER_TEMPLATE_FILE';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.JASPER_REPORT_TEMPLATE ADD CONSTRAINT FK_JASPER_TEMPLATE_FILE FOREIGN KEY (TEMPLATE_FILE_ID) REFERENCES DIF.JASPER_REPORT_TEMPLATE_FILE (ID)';
  END IF;
END;
/

-----------------------------------------------------------------------------------------------------------------------
--- JASPER_REPORT_TEMPLATE_PARAM table
-----------------------------------------------------------------------------------------------------------------------

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'JASPER_REPORT_TEMPLATE_PARAM';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE
      'CREATE TABLE DIF.JASPER_REPORT_TEMPLATE_PARAM( '||
      '  ID                     NUMBER(10) NOT NULL, '||
      '  TEMPLATE_ID            NUMBER(10) NOT NULL, '||
      '  PARAMETER_ID           VARCHAR2(100) NOT NULL, '||
      '  PARAMETER_NAME         VARCHAR2(300) NOT NULL, '||
      '  PARAMETER_OPTIONS_TYPE NUMBER(2) NOT NULL, '||
      '  PARAMETER_OPTIONS_LIST CLOB, '||
      '  PARAMETER_OPTIONS_SQL  CLOB, '||
      '  IS_ENABLED             NUMBER(1) NOT NULL'||
      ') ';
  END IF;
END;
/

COMMENT ON COLUMN dif.JASPER_REPORT_TEMPLATE_PARAM.ID IS 'ID';
COMMENT ON COLUMN dif.JASPER_REPORT_TEMPLATE_PARAM.TEMPLATE_ID IS 'The template the param definition belongs to';
COMMENT ON COLUMN dif.JASPER_REPORT_TEMPLATE_PARAM.PARAMETER_ID IS 'The parameter ID';
COMMENT ON COLUMN dif.JASPER_REPORT_TEMPLATE_PARAM.PARAMETER_NAME IS 'The parameter name';
COMMENT ON COLUMN dif.JASPER_REPORT_TEMPLATE_PARAM.PARAMETER_OPTIONS_TYPE IS 'The parameter options type (0=No options;1=Static list;2=SQL';
COMMENT ON COLUMN dif.JASPER_REPORT_TEMPLATE_PARAM.PARAMETER_OPTIONS_LIST IS 'The parameter options list (key value list)';
COMMENT ON COLUMN dif.JASPER_REPORT_TEMPLATE_PARAM.PARAMETER_OPTIONS_SQL IS 'The parameter options SQL';
COMMENT ON COLUMN dif.JASPER_REPORT_TEMPLATE_PARAM.IS_ENABLED IS 'Is enabled';


DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'JASPER_REPORT_TEMPLATE_PARAM'
  AND    CONSTRAINT_NAME = 'JASPER_REPT_TEMP_PARAM_PK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.JASPER_REPORT_TEMPLATE_PARAM ADD CONSTRAINT JASPER_REPT_TEMP_PARAM_PK PRIMARY KEY (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_SEQUENCES
  WHERE  SEQUENCE_OWNER  = 'DIF'
  AND    SEQUENCE_NAME   = 'SEQ_ID_JASPER_REPT_TEMP_PARAM';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_JASPER_REPT_TEMP_PARAM MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'JASPER_REPORT_TEMPLATE_PARAM'
  AND    CONSTRAINT_NAME = 'FK_JASPER_TEMP_PARAM_TEMPLATE';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.JASPER_REPORT_TEMPLATE_PARAM ADD CONSTRAINT FK_JASPER_TEMP_PARAM_TEMPLATE FOREIGN KEY (TEMPLATE_ID) REFERENCES DIF.JASPER_REPORT_TEMPLATE (ID) ON DELETE CASCADE';
  END IF;
END;
/
