DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
    INTO   TOTAL
    FROM   ALL_TAB_COLUMNS 
    WHERE  OWNER      = 'DIF'
    AND    TABLE_NAME = 'CONFIG_SERVER_SET'
    AND    COLUMN_NAME = 'IS_DEFAULT';
  
  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE   'ALTER TABLE DIF.CONFIG_SERVER_SET ADD IS_DEFAULT NUMBER(1)';
  END IF;
END;
/

COMMENT ON COLUMN dif.CONFIG_SERVER_SET.IS_DEFAULT IS 'If set is the default';

UPDATE DIF.CONFIG_SERVER_SET SET IS_DEFAULT = 1
 WHERE (SERVER_UID, CONFIG_SET_ID) IN (SELECT SERVER_UID, MIN(CONFIG_SET_ID) FROM DIF.CONFIG_SERVER_SET GROUP BY SERVER_UID);

UPDATE DIF.CONFIG_SERVER_SET SET IS_DEFAULT = 0 WHERE IS_DEFAULT IS NULL;

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TAB_COLUMNS 
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'CONFIG_SERVER_SET'
  AND    COLUMN_NAME = 'IS_DEFAULT'
  AND    NULLABLE    = 'N';
      
  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.CONFIG_SERVER_SET MODIFY IS_DEFAULT DEFAULT 0 NOT NULL';
  END IF;
END;
/
