/*-------------------------------------------------------------
-- REPORT Documents Table
-------------------------------------------------------------*/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TABLES
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'REPORT_INSTANCE_DOCUMENT';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'create table DIF.REPORT_INSTANCE_DOCUMENT ( ' ||
                          '  id                     NUMBER(10) not null,' ||
                          '  report_instance_id     NUMBER(10) not null,' ||
                          '  description            VARCHAR2(500),' ||
                          '  PUBLIC_VISIBILITY varchar(1),' ||
                          '  document_repository_id number' ||
                          ')' ||
                          'tablespace USERS' ||
                          '  pctfree 10' ||
                          '  pctused 40' ||
                          '  initrans 1' ||
                          '  maxtrans 255' ||
                          '  storage' ||
                          '  (' ||
                          '    initial 64K' ||
                          '    next 1' ||
                          '    minextents 1' ||
                          '    maxextents unlimited' ||
                          '  ) ';
    END IF;
END;
/

comment on column DIF.REPORT_INSTANCE_DOCUMENT.id is 'ID column';
comment on column DIF.REPORT_INSTANCE_DOCUMENT.report_instance_id is 'The parent report ID';
comment on column DIF.REPORT_INSTANCE_DOCUMENT.description is 'Document description';
comment on column DIF.REPORT_INSTANCE_DOCUMENT.document_repository_id is 'Identifier in the Document repository table';
comment on column DIF.REPORT_INSTANCE_DOCUMENT.PUBLIC_VISIBILITY is 'Defines visibility for the document';


DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'REPORT_INSTANCE_DOCUMENT'
      AND CONSTRAINT_NAME = 'REPORT_INST_DOC_PK';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.REPORT_INSTANCE_DOCUMENT ADD CONSTRAINT REPORT_INST_DOC_PK PRIMARY KEY (ID)';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'REPORT_INSTANCE_DOCUMENT'
      AND CONSTRAINT_NAME = 'REPORT_INST_DOC_FK';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.REPORT_INSTANCE_DOCUMENT ADD CONSTRAINT REPORT_INST_DOC_FK FOREIGN KEY (REPORT_INSTANCE_ID) REFERENCES DIF.REPORT_INSTANCE (ID) ON DELETE CASCADE';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_SEQUENCES
    WHERE SEQUENCE_OWNER = 'DIF'
      AND SEQUENCE_NAME = 'REPORT_INSTANCE_DOC_ID_SEQ';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.REPORT_INSTANCE_DOC_ID_SEQ START WITH 1 INCREMENT BY 1 MAXVALUE 9999999999999999999999999999 NOCACHE';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN

    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TAB_COLUMNS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'EVENT'
      AND COLUMN_NAME = 'PAY_LOAD';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.EVENT ADD PAY_LOAD CLOB';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN

    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TAB_COLUMNS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'EVENT'
      AND COLUMN_NAME = 'ATTEMPTS_TO_GIVE_UP';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.EVENT ADD ATTEMPTS_TO_GIVE_UP NUMBER(3)';
    END IF;
END;
/

