package pt.digitalis.dif.dem.managers.impl.model.data;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.model.utils.IBeanAttributesDataSet;

/**
 * Configuration
* Generated on ORM Generator
* DIF build process for the Model layer
*
*/
@SuppressWarnings("serial")
public class Configuration extends AbstractBeanRelationsAttributes implements java.io.Serializable, IBeanAttributesDataSet<Configuration> {

    /** Configuration attributes enumeration */
    public static class Fields
    {
        /** id column */
        public static final String ID ="id";
        /** key column */
        public static final String KEY ="key";
        /** value column */
        public static final String VALUE ="value";
        /** valueXL column */
        public static final String VALUEXL ="valueXL";

        /**
         * List of existing fields
         *
         * @return list of field names
         */
        public static List<String> values()
        {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("key");
            list.add("value");
            list.add("valueXL");

            return list;
        }
    }

    /** Field attributes */
    public static ConfigurationFieldAttributes FieldAttributes=new ConfigurationFieldAttributes();

    /**
    * @return the field attributes definitions
    */
    @Override public ConfigurationFieldAttributes getDefinitions()
    {
        return FieldAttributes;
    }

    /**
     * The Class Relations.
     */
    public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations
    {

        /**
        * Instantiates a new relations.
        *
        * @param currentPath the current path
        */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * configNode relation.
         *
         * @return the configNode bean relations attributes.
         */
        public ConfigNode.Relations configNode()
        {
            ConfigNode c = new ConfigNode();
            return c.new Relations(this.buildPath("configNode"));
        }

        /**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
        /**
         * the KEY path.
         *
         * @return the path
         */
        public String KEY()
        {
            return buildPath(Fields.KEY);
        }
        /**
         * the VALUE path.
         *
         * @return the path
         */
        public String VALUE()
        {
            return buildPath(Fields.VALUE);
        }
        /**
         * the VALUEXL path.
         *
         * @return the path
         */
        public String VALUEXL()
        {
            return buildPath(Fields.VALUEXL);
        }
    }

    /** The dummy obj. */
    private static Configuration dummyObj=new Configuration();

    /**
     * Get Configuration Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public IDataSet<Configuration> getDataSet()
    {
        return new HibernateDataSet<Configuration>(Configuration.class, HibernateUtil.getSessionFactory("DIFRepository"),
            Configuration.getPKFieldListAsString(), Configuration.FieldAttributes);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public static IDataSet<Configuration> getDataSetInstance()
    {
        return new Configuration().getDataSet();
    }

    /**
    * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
    */
    @Override protected Object getAttributeNoGraphNavigation(String attributeName)
    {
        if("id".equalsIgnoreCase(attributeName))
            return id;
        if("configNode".equalsIgnoreCase(attributeName))
            return configNode;
        if("key".equalsIgnoreCase(attributeName))
            return key;
        if("value".equalsIgnoreCase(attributeName))
            return value;
        if("valueXL".equalsIgnoreCase(attributeName))
            return valueXL;

        return null;
    }

    /**
    * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
    */
    public void setAttribute(String attributeName,Object attributeValue)
    {
        if("id".equalsIgnoreCase(attributeName))
            id =(Long)attributeValue;
        if("configNode".equalsIgnoreCase(attributeName))
            configNode =(ConfigNode)attributeValue;
        if("key".equalsIgnoreCase(attributeName))
            key =(String)attributeValue;
        if("value".equalsIgnoreCase(attributeName))
            value =(String)attributeValue;
        if("valueXL".equalsIgnoreCase(attributeName))
            valueXL =(String)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** configNode private attribute */
    private ConfigNode configNode;

    /** key private attribute */
    private String key;

    /** value private attribute */
    private String value;

    /** valueXL private attribute */
    private String valueXL;

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {

        Object value = getAttribute(attributeName);

        if (value == null)
            return "";
        else {
            return value.toString().trim();
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public Configuration() {
    }

	/** 
	 * minimal constructor
	 *
     * @param configNode the configNode
     * @param key the key
    }
	 */
    public Configuration(ConfigNode configNode, String key) {
        this.configNode = configNode;
        this.key = key;
    }

    /**
     * full constructor
	 *
     * @param configNode the configNode
     * @param key the key
     * @param value the value
     * @param valueXL the valueXL
     */
    public Configuration(ConfigNode configNode, String key, String value, String valueXL) {
        this.configNode = configNode;
        this.key = key;
        this.value = value;
        this.valueXL = valueXL;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id the id
     *
     * @return Configuration modified instance
     */
    public Configuration setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * configNode getter method
     *
     * @return configNode method
     */
    public ConfigNode getConfigNode() {
        return this.configNode;
    }
    
    /**       
     * configNode setter method
     *
     * @param configNode the configNode
     *
     * @return Configuration modified instance
     */
    public Configuration setConfigNode(ConfigNode configNode) {
        this.configNode = configNode;
        
        return this;
    }
    /**       
     * key getter method
     *
     * @return key method
     */
    public String getKey() {
        return this.key;
    }
    
    /**       
     * key setter method
     *
     * @param key the key
     *
     * @return Configuration modified instance
     */
    public Configuration setKey(String key) {
        this.key = key;
        
        return this;
    }
    /**       
     * value getter method
     *
     * @return value method
     */
    public String getValue() {
        return this.value;
    }
    
    /**       
     * value setter method
     *
     * @param value the value
     *
     * @return Configuration modified instance
     */
    public Configuration setValue(String value) {
        this.value = value;
        
        return this;
    }
    /**       
     * valueXL getter method
     *
     * @return valueXL method
     */
    public String getValueXL() {
        return this.valueXL;
    }
    
    /**       
     * valueXL setter method
     *
     * @param valueXL the valueXL
     *
     * @return Configuration modified instance
     */
    public Configuration setValueXL(String valueXL) {
        this.valueXL = valueXL;
        
        return this;
    }

    /**
     * Creates a String representation of the Configuration object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("key").append("='").append(getKey()).append("' ");			
        buffer.append("value").append("='").append(getValue()).append("' ");			
        buffer.append("valueXL").append("='").append(getValueXL()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the Configuration object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(Configuration other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("key".equalsIgnoreCase(attributeName))
        	this.key = attributeValue;

        if ("value".equalsIgnoreCase(attributeName))
        	this.value = attributeValue;

        if ("valueXL".equalsIgnoreCase(attributeName))
        	this.valueXL = attributeValue;

    }


    /**
     * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
     *
     * @param session the session
     * @param id      the id
     *
     * @return the proxy
     */
    public static Configuration getProxy(Session session, Long id)
    {
        return(Configuration)session.load(Configuration.class,id);
    }

    /**
    * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
    *
    * @param id      the id
    *
    * @return the proxy
    */
    public static Configuration getProxy(Long id)
    {
        Session session = HibernateUtil.getSessionFactory("DIFRepository").getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        Configuration result = (Configuration)session.load(Configuration.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }


    /**
     * Instanciates an Hibernate data object
     *
     * @param session the session
     * @param id      the id
     *
     * @return the instance
     */
    public static Configuration getInstance(Session session, Long id)
    {
        return(Configuration)session.get(Configuration.class,id);
    }

    /**
    * Instanciates an Hibernate data object
    *
    * @param id      the id
    *
    * @return the instance
    */
    public static Configuration getInstance(Long id)
    {
        Session session = HibernateUtil.getSessionFactory("DIFRepository").getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        Configuration result = (Configuration)session.get(Configuration.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }

}
