package pt.digitalis.dif.dem.managers.impl.model.data;


import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.Session;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.model.utils.IBeanAttributesDataSet;

/**
 * Conversation
* Generated on ORM Generator
* DIF build process for the Model layer
*
*/
@SuppressWarnings("serial")
public class Conversation extends AbstractBeanRelationsAttributes implements java.io.Serializable, IBeanAttributesDataSet<Conversation> {

    /** Conversation attributes enumeration */
    public static class Fields
    {
        /** id column */
        public static final String ID ="id";
        /** description column */
        public static final String DESCRIPTION ="description";
        /** businessProcessTypeId column */
        public static final String BUSINESSPROCESSTYPEID ="businessProcessTypeId";
        /** businessProcessInstanceId column */
        public static final String BUSINESSPROCESSINSTANCEID ="businessProcessInstanceId";
        /** creationDate column */
        public static final String CREATIONDATE ="creationDate";
        /** closeDate column */
        public static final String CLOSEDATE ="closeDate";
        /** isOpen column */
        public static final String ISOPEN ="isOpen";

        /**
         * List of existing fields
         *
         * @return list of field names
         */
        public static List<String> values()
        {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("description");
            list.add("businessProcessTypeId");
            list.add("businessProcessInstanceId");
            list.add("creationDate");
            list.add("closeDate");
            list.add("isOpen");

            return list;
        }
    }

    /** Field attributes */
    public static ConversationFieldAttributes FieldAttributes=new ConversationFieldAttributes();

    /**
    * @return the field attributes definitions
    */
    @Override public ConversationFieldAttributes getDefinitions()
    {
        return FieldAttributes;
    }

    /**
     * The Class Relations.
     */
    public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations
    {

        /**
        * Instantiates a new relations.
        *
        * @param currentPath the current path
        */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * conversationMessages relation.
         *
         * @return the conversationMessages bean relations attributes.
         */
        public ConversationMessage.Relations conversationMessages()
        {
            ConversationMessage c = new ConversationMessage();
            return c.new Relations(this.buildPath("conversationMessages"));
        }

        /**
         * workflowInstances relation.
         *
         * @return the workflowInstances bean relations attributes.
         */
        public WorkflowInstance.Relations workflowInstances()
        {
            WorkflowInstance c = new WorkflowInstance();
            return c.new Relations(this.buildPath("workflowInstances"));
        }

        /**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
        /**
         * the DESCRIPTION path.
         *
         * @return the path
         */
        public String DESCRIPTION()
        {
            return buildPath(Fields.DESCRIPTION);
        }
        /**
         * the BUSINESSPROCESSTYPEID path.
         *
         * @return the path
         */
        public String BUSINESSPROCESSTYPEID()
        {
            return buildPath(Fields.BUSINESSPROCESSTYPEID);
        }
        /**
         * the BUSINESSPROCESSINSTANCEID path.
         *
         * @return the path
         */
        public String BUSINESSPROCESSINSTANCEID()
        {
            return buildPath(Fields.BUSINESSPROCESSINSTANCEID);
        }
        /**
         * the CREATIONDATE path.
         *
         * @return the path
         */
        public String CREATIONDATE()
        {
            return buildPath(Fields.CREATIONDATE);
        }
        /**
         * the CLOSEDATE path.
         *
         * @return the path
         */
        public String CLOSEDATE()
        {
            return buildPath(Fields.CLOSEDATE);
        }
        /**
         * the ISOPEN path.
         *
         * @return the path
         */
        public String ISOPEN()
        {
            return buildPath(Fields.ISOPEN);
        }
    }

    /** The dummy obj. */
    private static Conversation dummyObj=new Conversation();

    /**
     * Get Conversation Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public IDataSet<Conversation> getDataSet()
    {
        return new HibernateDataSet<Conversation>(Conversation.class, HibernateUtil.getSessionFactory("DIFRepository"),
            Conversation.getPKFieldListAsString(), Conversation.FieldAttributes);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public static IDataSet<Conversation> getDataSetInstance()
    {
        return new Conversation().getDataSet();
    }

    /**
    * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
    */
    @Override protected Object getAttributeNoGraphNavigation(String attributeName)
    {
        if("id".equalsIgnoreCase(attributeName))
            return id;
        if("description".equalsIgnoreCase(attributeName))
            return description;
        if("businessProcessTypeId".equalsIgnoreCase(attributeName))
            return businessProcessTypeId;
        if("businessProcessInstanceId".equalsIgnoreCase(attributeName))
            return businessProcessInstanceId;
        if("creationDate".equalsIgnoreCase(attributeName))
            return creationDate;
        if("closeDate".equalsIgnoreCase(attributeName))
            return closeDate;
        if("isOpen".equalsIgnoreCase(attributeName))
            return isOpen;
        if("conversationMessages".equalsIgnoreCase(attributeName))
            return conversationMessages;
        if("workflowInstances".equalsIgnoreCase(attributeName))
            return workflowInstances;

        return null;
    }

    /**
    * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
    */
    public void setAttribute(String attributeName,Object attributeValue)
    {
        if("id".equalsIgnoreCase(attributeName))
            id =(Long)attributeValue;
        if("description".equalsIgnoreCase(attributeName))
            description =(String)attributeValue;
        if("businessProcessTypeId".equalsIgnoreCase(attributeName))
            businessProcessTypeId =(String)attributeValue;
        if("businessProcessInstanceId".equalsIgnoreCase(attributeName))
            businessProcessInstanceId =(String)attributeValue;
        if("creationDate".equalsIgnoreCase(attributeName))
            creationDate =(Timestamp)attributeValue;
        if("closeDate".equalsIgnoreCase(attributeName))
            closeDate =(Timestamp)attributeValue;
        if("isOpen".equalsIgnoreCase(attributeName))
            isOpen =(Boolean)attributeValue;
        if("conversationMessages".equalsIgnoreCase(attributeName))
            conversationMessages =(Set<ConversationMessage>)attributeValue;
        if("workflowInstances".equalsIgnoreCase(attributeName))
            workflowInstances =(Set<WorkflowInstance>)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** description private attribute */
    private String description;

    /** businessProcessTypeId private attribute */
    private String businessProcessTypeId;

    /** businessProcessInstanceId private attribute */
    private String businessProcessInstanceId;

    /** creationDate private attribute */
    private Timestamp creationDate;

    /** closeDate private attribute */
    private Timestamp closeDate;

    /** isOpen private attribute */
    private boolean isOpen;

    /** conversationMessages private attribute */
    private Set<ConversationMessage> conversationMessages = new HashSet<ConversationMessage>(0);

    /** workflowInstances private attribute */
    private Set<WorkflowInstance> workflowInstances = new HashSet<WorkflowInstance>(0);

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {

        Object value = getAttribute(attributeName);

        if (value == null)
            return "";
        else {
            return value.toString().trim();
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public Conversation() {
    }

	/** 
	 * minimal constructor
	 *
     * @param creationDate the creationDate
     * @param isOpen the isOpen
    }
	 */
    public Conversation(Timestamp creationDate, boolean isOpen) {
        this.creationDate = creationDate;
        this.isOpen = isOpen;
    }

    /**
     * full constructor
	 *
     * @param description the description
     * @param businessProcessTypeId the businessProcessTypeId
     * @param businessProcessInstanceId the businessProcessInstanceId
     * @param creationDate the creationDate
     * @param closeDate the closeDate
     * @param isOpen the isOpen
     * @param conversationMessages the conversationMessages
     * @param workflowInstances the workflowInstances
     */
    public Conversation(String description, String businessProcessTypeId, String businessProcessInstanceId, Timestamp creationDate, Timestamp closeDate, boolean isOpen, Set<ConversationMessage> conversationMessages, Set<WorkflowInstance> workflowInstances) {
        this.description = description;
        this.businessProcessTypeId = businessProcessTypeId;
        this.businessProcessInstanceId = businessProcessInstanceId;
        this.creationDate = creationDate;
        this.closeDate = closeDate;
        this.isOpen = isOpen;
        this.conversationMessages = conversationMessages;
        this.workflowInstances = workflowInstances;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id the id
     *
     * @return Conversation modified instance
     */
    public Conversation setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * description getter method
     *
     * @return description method
     */
    public String getDescription() {
        return this.description;
    }
    
    /**       
     * description setter method
     *
     * @param description the description
     *
     * @return Conversation modified instance
     */
    public Conversation setDescription(String description) {
        this.description = description;
        
        return this;
    }
    /**       
     * businessProcessTypeId getter method
     *
     * @return businessProcessTypeId method
     */
    public String getBusinessProcessTypeId() {
        return this.businessProcessTypeId;
    }
    
    /**       
     * businessProcessTypeId setter method
     *
     * @param businessProcessTypeId the businessProcessTypeId
     *
     * @return Conversation modified instance
     */
    public Conversation setBusinessProcessTypeId(String businessProcessTypeId) {
        this.businessProcessTypeId = businessProcessTypeId;
        
        return this;
    }
    /**       
     * businessProcessInstanceId getter method
     *
     * @return businessProcessInstanceId method
     */
    public String getBusinessProcessInstanceId() {
        return this.businessProcessInstanceId;
    }
    
    /**       
     * businessProcessInstanceId setter method
     *
     * @param businessProcessInstanceId the businessProcessInstanceId
     *
     * @return Conversation modified instance
     */
    public Conversation setBusinessProcessInstanceId(String businessProcessInstanceId) {
        this.businessProcessInstanceId = businessProcessInstanceId;
        
        return this;
    }
    /**       
     * creationDate getter method
     *
     * @return creationDate method
     */
    public Timestamp getCreationDate() {
        return this.creationDate;
    }
    
    /**       
     * creationDate setter method
     *
     * @param creationDate the creationDate
     *
     * @return Conversation modified instance
     */
    public Conversation setCreationDate(Timestamp creationDate) {
        this.creationDate = creationDate;
        
        return this;
    }
    /**       
     * closeDate getter method
     *
     * @return closeDate method
     */
    public Timestamp getCloseDate() {
        return this.closeDate;
    }
    
    /**       
     * closeDate setter method
     *
     * @param closeDate the closeDate
     *
     * @return Conversation modified instance
     */
    public Conversation setCloseDate(Timestamp closeDate) {
        this.closeDate = closeDate;
        
        return this;
    }
    /**       
     * isOpen getter method
     *
     * @return isOpen method
     */
    public boolean isIsOpen() {
        return this.isOpen;
    }
    
    /**       
     * isOpen setter method
     *
     * @param isOpen the isOpen
     *
     * @return Conversation modified instance
     */
    public Conversation setIsOpen(boolean isOpen) {
        this.isOpen = isOpen;
        
        return this;
    }
    /**       
     * conversationMessages getter method
     *
     * @return conversationMessages method
     */
    public Set<ConversationMessage> getConversationMessages() {
        return this.conversationMessages;
    }
    
    /**       
     * conversationMessages setter method
     *
     * @param conversationMessages the conversationMessages
     *
     * @return Conversation modified instance
     */
    public Conversation setConversationMessages(Set<ConversationMessage> conversationMessages) {
        this.conversationMessages = conversationMessages;
        
        return this;
    }
    /**       
     * workflowInstances getter method
     *
     * @return workflowInstances method
     */
    public Set<WorkflowInstance> getWorkflowInstances() {
        return this.workflowInstances;
    }
    
    /**       
     * workflowInstances setter method
     *
     * @param workflowInstances the workflowInstances
     *
     * @return Conversation modified instance
     */
    public Conversation setWorkflowInstances(Set<WorkflowInstance> workflowInstances) {
        this.workflowInstances = workflowInstances;
        
        return this;
    }

    /**
     * Creates a String representation of the Conversation object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("description").append("='").append(getDescription()).append("' ");			
        buffer.append("businessProcessTypeId").append("='").append(getBusinessProcessTypeId()).append("' ");			
        buffer.append("businessProcessInstanceId").append("='").append(getBusinessProcessInstanceId()).append("' ");			
        buffer.append("creationDate").append("='").append(getCreationDate()).append("' ");			
        buffer.append("closeDate").append("='").append(getCloseDate()).append("' ");			
        buffer.append("isOpen").append("='").append(isIsOpen()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the Conversation object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(Conversation other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("description".equalsIgnoreCase(attributeName))
        	this.description = attributeValue;

        if ("businessProcessTypeId".equalsIgnoreCase(attributeName))
        	this.businessProcessTypeId = attributeValue;

        if ("businessProcessInstanceId".equalsIgnoreCase(attributeName))
        	this.businessProcessInstanceId = attributeValue;

        if ("creationDate".equalsIgnoreCase(attributeName))
            this.creationDate = Timestamp.valueOf(attributeValue);

        if ("closeDate".equalsIgnoreCase(attributeName))
            this.closeDate = Timestamp.valueOf(attributeValue);

        if ("isOpen".equalsIgnoreCase(attributeName))
            this.isOpen = Boolean.valueOf(attributeValue);

    }


    /**
     * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
     *
     * @param session the session
     * @param id      the id
     *
     * @return the proxy
     */
    public static Conversation getProxy(Session session, Long id)
    {
        return(Conversation)session.load(Conversation.class,id);
    }

    /**
    * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
    *
    * @param id      the id
    *
    * @return the proxy
    */
    public static Conversation getProxy(Long id)
    {
        Session session = HibernateUtil.getSessionFactory("DIFRepository").getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        Conversation result = (Conversation)session.load(Conversation.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }


    /**
     * Instanciates an Hibernate data object
     *
     * @param session the session
     * @param id      the id
     *
     * @return the instance
     */
    public static Conversation getInstance(Session session, Long id)
    {
        return(Conversation)session.get(Conversation.class,id);
    }

    /**
    * Instanciates an Hibernate data object
    *
    * @param id      the id
    *
    * @return the instance
    */
    public static Conversation getInstance(Long id)
    {
        Session session = HibernateUtil.getSessionFactory("DIFRepository").getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        Conversation result = (Conversation)session.get(Conversation.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }

}
