package pt.digitalis.dif.dem.managers.impl.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link CustomMessages}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class CustomMessagesFieldAttributes extends AbstractBeanAttributesDefinition{

    /** entityId (Database column: ENTITY_ID - ID da entidade a qual pertence a mensagem. Tem a forma: tipo_da_entidade:nome_da_entidade. Ex.: STAGE:homestage.) */
    static public AttributeDefinition entityId =
        new AttributeDefinition("entityId")
                .setDescription("ID da entidade a qual pertence a mensagem. Tem a forma: tipo_da_entidade:nome_da_entidade. Ex.: STAGE:homestage.")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("CUSTOM_MESSAGES")
                .setDatabaseId("ENTITY_ID")
                .setMandatory(true)
                .setMaxSize(4000)
                .setType(String.class);

    /** id (Database column: ID - PK) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDescription("PK")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("CUSTOM_MESSAGES")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setDefaultValue("0")
                .setType(Long.class);

    /** language (Database column: LANGUAGE - lingua) */
    static public AttributeDefinition language =
        new AttributeDefinition("language")
                .setDescription("lingua")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("CUSTOM_MESSAGES")
                .setDatabaseId("LANGUAGE")
                .setMandatory(true)
                .setMaxSize(4000)
                .setType(String.class);

    /** message (Database column: MESSAGE - O valor da mensagem.) */
    static public AttributeDefinition message =
        new AttributeDefinition("message")
                .setDescription("O valor da mensagem.")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("CUSTOM_MESSAGES")
                .setDatabaseId("MESSAGE")
                .setMandatory(true)
                .setMaxSize(4000)
                .setType(String.class);

    /** messageId (Database column: MESSAGE_ID - O identificador da mensagem na pagina.) */
    static public AttributeDefinition messageId =
        new AttributeDefinition("messageId")
                .setDescription("O identificador da mensagem na pagina.")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("CUSTOM_MESSAGES")
                .setDatabaseId("MESSAGE_ID")
                .setMandatory(true)
                .setMaxSize(4000)
                .setType(String.class);

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(entityId.getName(),entityId);
        map.put(id.getName(),id);
        map.put(language.getName(),language);
        map.put(message.getName(),message);
        map.put(messageId.getName(),messageId);

        return map;
    }
}