package pt.digitalis.dif.dem.managers.impl.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link Dashboard}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class DashboardFieldAttributes extends AbstractBeanAttributesDefinition{

    /** area (Database column: AREA_ID - The parent area ID) */
    static public AttributeDefinition area =
        new AttributeDefinition("area")
                .setDescription("The parent area ID")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("DASHBOARD")
                .setDatabaseId("AREA_ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setLovDataClass(pt.digitalis.dif.dem.managers.impl.model.data.Area.class)
                .setLovDataClassKey("id")
                .setType(pt.digitalis.dif.dem.managers.impl.model.data.Area.class);

    /** id (Database column: ID - ID column) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDescription("ID column")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("DASHBOARD")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(Long.class);

    /** template (Database column: TEMPLATE - The layout of the indocators contained in the dashboard) */
    static public AttributeDefinition template =
        new AttributeDefinition("template")
                .setDescription("The layout of the indocators contained in the dashboard")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("DASHBOARD")
                .setDatabaseId("TEMPLATE")
                .setMandatory(true)
                .setMaxSize(2000)
                .setType(String.class);

    /** title (Database column: TITLE - The dashboard title) */
    static public AttributeDefinition title =
        new AttributeDefinition("title")
                .setDescription("The dashboard title")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("DASHBOARD")
                .setDatabaseId("TITLE")
                .setMandatory(true)
                .setMaxSize(500)
                .setType(String.class);

    /** uniqueId (Database column: UNIQUE_ID - Business unique ID) */
    static public AttributeDefinition uniqueId =
        new AttributeDefinition("uniqueId")
                .setDescription("Business unique ID")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("DASHBOARD")
                .setDatabaseId("UNIQUE_ID")
                .setMandatory(true)
                .setMaxSize(200)
                .setType(String.class);

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(area.getName(),area);
        map.put(id.getName(),id);
        map.put(template.getName(),template);
        map.put(title.getName(),title);
        map.put(uniqueId.getName(),uniqueId);

        return map;
    }
}