package pt.digitalis.dif.dem.managers.impl.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link DataConsentReview}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class DataConsentReviewFieldAttributes extends AbstractBeanAttributesDefinition{

    /** dataConsent (Database column: CONSENT_ID - The consent the user reviewd) */
    static public AttributeDefinition dataConsent =
        new AttributeDefinition("dataConsent")
                .setDescription("The consent the user reviewd")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("DATA_CONSENT_REVIEW")
                .setDatabaseId("CONSENT_ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setLovDataClass(pt.digitalis.dif.dem.managers.impl.model.data.DataConsent.class)
                .setLovDataClassKey("id")
                .setLovDataClassDescription("description")
                .setType(pt.digitalis.dif.dem.managers.impl.model.data.DataConsent.class);

    /** dataConsentUser (Database column: DATA_CONSENT_USER_ID - The consent user record ID) */
    static public AttributeDefinition dataConsentUser =
        new AttributeDefinition("dataConsentUser")
                .setDescription("The consent user record ID")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("DATA_CONSENT_REVIEW")
                .setDatabaseId("DATA_CONSENT_USER_ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(pt.digitalis.dif.dem.managers.impl.model.data.DataConsentUser.class);

    /** id (Database column: ID - ID) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDescription("ID")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("DATA_CONSENT_REVIEW")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(Long.class);

    /** lastReviewDate (Database column: LAST_REVIEW_DATE - The last review date) */
    static public AttributeDefinition lastReviewDate =
        new AttributeDefinition("lastReviewDate")
                .setDescription("The last review date")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("DATA_CONSENT_REVIEW")
                .setDatabaseId("LAST_REVIEW_DATE")
                .setMandatory(true)
                .setMaxSize(7)
                .setType(Timestamp.class);

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(dataConsent.getName(),dataConsent);
        map.put(dataConsentUser.getName(),dataConsentUser);
        map.put(id.getName(),id);
        map.put(lastReviewDate.getName(),lastReviewDate);

        return map;
    }
}