package pt.digitalis.dif.dem.managers.impl.model.data;


import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.Session;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.model.utils.IBeanAttributesDataSet;

/**
 * DataIntegrationRecord
* Generated on ORM Generator
* DIF build process for the Model layer
*
*/
@SuppressWarnings("serial")
public class DataIntegrationRecord extends AbstractBeanRelationsAttributes implements java.io.Serializable, IBeanAttributesDataSet<DataIntegrationRecord> {

    /** DataIntegrationRecord attributes enumeration */
    public static class Fields
    {
        /** id column */
        public static final String ID ="id";
        /** entityType column */
        public static final String ENTITYTYPE ="entityType";
        /** entityId column */
        public static final String ENTITYID ="entityId";
        /** operationId column */
        public static final String OPERATIONID ="operationId";
        /** root column */
        public static final String ROOT ="root";

        /**
         * List of existing fields
         *
         * @return list of field names
         */
        public static List<String> values()
        {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("entityType");
            list.add("entityId");
            list.add("operationId");
            list.add("root");

            return list;
        }
    }

    /** Field attributes */
    public static DataIntegrationRecordFieldAttributes FieldAttributes=new DataIntegrationRecordFieldAttributes();

    /**
    * @return the field attributes definitions
    */
    @Override public DataIntegrationRecordFieldAttributes getDefinitions()
    {
        return FieldAttributes;
    }

    /**
     * The Class Relations.
     */
    public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations
    {

        /**
        * Instantiates a new relations.
        *
        * @param currentPath the current path
        */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * dataIntegrationSet relation.
         *
         * @return the dataIntegrationSet bean relations attributes.
         */
        public DataIntegrationSet.Relations dataIntegrationSet()
        {
            DataIntegrationSet c = new DataIntegrationSet();
            return c.new Relations(this.buildPath("dataIntegrationSet"));
        }

        /**
         * dataIntegrationFieldsForRelationRecordId relation.
         *
         * @return the dataIntegrationFieldsForRelationRecordId bean relations attributes.
         */
        public DataIntegrationField.Relations dataIntegrationFieldsForRelationRecordId()
        {
            DataIntegrationField c = new DataIntegrationField();
            return c.new Relations(this.buildPath("dataIntegrationFieldsForRelationRecordId"));
        }

        /**
         * dataIntegrationFieldsForDataIntegrationRecordId relation.
         *
         * @return the dataIntegrationFieldsForDataIntegrationRecordId bean relations attributes.
         */
        public DataIntegrationField.Relations dataIntegrationFieldsForDataIntegrationRecordId()
        {
            DataIntegrationField c = new DataIntegrationField();
            return c.new Relations(this.buildPath("dataIntegrationFieldsForDataIntegrationRecordId"));
        }

        /**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
        /**
         * the ENTITYTYPE path.
         *
         * @return the path
         */
        public String ENTITYTYPE()
        {
            return buildPath(Fields.ENTITYTYPE);
        }
        /**
         * the ENTITYID path.
         *
         * @return the path
         */
        public String ENTITYID()
        {
            return buildPath(Fields.ENTITYID);
        }
        /**
         * the OPERATIONID path.
         *
         * @return the path
         */
        public String OPERATIONID()
        {
            return buildPath(Fields.OPERATIONID);
        }
        /**
         * the ROOT path.
         *
         * @return the path
         */
        public String ROOT()
        {
            return buildPath(Fields.ROOT);
        }
    }

    /** The dummy obj. */
    private static DataIntegrationRecord dummyObj=new DataIntegrationRecord();

    /**
     * Get DataIntegrationRecord Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public IDataSet<DataIntegrationRecord> getDataSet()
    {
        return new HibernateDataSet<DataIntegrationRecord>(DataIntegrationRecord.class, HibernateUtil.getSessionFactory("DIFRepository"),
            DataIntegrationRecord.getPKFieldListAsString(), DataIntegrationRecord.FieldAttributes);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public static IDataSet<DataIntegrationRecord> getDataSetInstance()
    {
        return new DataIntegrationRecord().getDataSet();
    }

    /**
    * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
    */
    @Override protected Object getAttributeNoGraphNavigation(String attributeName)
    {
        if("id".equalsIgnoreCase(attributeName))
            return id;
        if("dataIntegrationSet".equalsIgnoreCase(attributeName))
            return dataIntegrationSet;
        if("entityType".equalsIgnoreCase(attributeName))
            return entityType;
        if("entityId".equalsIgnoreCase(attributeName))
            return entityId;
        if("operationId".equalsIgnoreCase(attributeName))
            return operationId;
        if("root".equalsIgnoreCase(attributeName))
            return root;
        if("dataIntegrationFieldsForRelationRecordId".equalsIgnoreCase(attributeName))
            return dataIntegrationFieldsForRelationRecordId;
        if("dataIntegrationFieldsForDataIntegrationRecordId".equalsIgnoreCase(attributeName))
            return dataIntegrationFieldsForDataIntegrationRecordId;

        return null;
    }

    /**
    * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
    */
    public void setAttribute(String attributeName,Object attributeValue)
    {
        if("id".equalsIgnoreCase(attributeName))
            id =(Long)attributeValue;
        if("dataIntegrationSet".equalsIgnoreCase(attributeName))
            dataIntegrationSet =(DataIntegrationSet)attributeValue;
        if("entityType".equalsIgnoreCase(attributeName))
            entityType =(String)attributeValue;
        if("entityId".equalsIgnoreCase(attributeName))
            entityId =(String)attributeValue;
        if("operationId".equalsIgnoreCase(attributeName))
            operationId =(String)attributeValue;
        if("root".equalsIgnoreCase(attributeName))
            root =(Boolean)attributeValue;
        if("dataIntegrationFieldsForRelationRecordId".equalsIgnoreCase(attributeName))
            dataIntegrationFieldsForRelationRecordId =(Set<DataIntegrationField>)attributeValue;
        if("dataIntegrationFieldsForDataIntegrationRecordId".equalsIgnoreCase(attributeName))
            dataIntegrationFieldsForDataIntegrationRecordId =(Set<DataIntegrationField>)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** dataIntegrationSet private attribute */
    private DataIntegrationSet dataIntegrationSet;

    /** entityType private attribute */
    private String entityType;

    /** entityId private attribute */
    private String entityId;

    /** operationId private attribute */
    private String operationId;

    /** root private attribute */
    private boolean root;

    /** dataIntegrationFieldsForRelationRecordId private attribute */
    private Set<DataIntegrationField> dataIntegrationFieldsForRelationRecordId = new HashSet<DataIntegrationField>(0);

    /** dataIntegrationFieldsForDataIntegrationRecordId private attribute */
    private Set<DataIntegrationField> dataIntegrationFieldsForDataIntegrationRecordId = new HashSet<DataIntegrationField>(0);

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {

        Object value = getAttribute(attributeName);

        if (value == null)
            return "";
        else {
            return value.toString().trim();
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public DataIntegrationRecord() {
    }

	/** 
	 * minimal constructor
	 *
     * @param dataIntegrationSet the dataIntegrationSet
     * @param entityType the entityType
     * @param entityId the entityId
     * @param operationId the operationId
     * @param root the root
    }
	 */
    public DataIntegrationRecord(DataIntegrationSet dataIntegrationSet, String entityType, String entityId, String operationId, boolean root) {
        this.dataIntegrationSet = dataIntegrationSet;
        this.entityType = entityType;
        this.entityId = entityId;
        this.operationId = operationId;
        this.root = root;
    }

    /**
     * full constructor
	 *
     * @param dataIntegrationSet the dataIntegrationSet
     * @param entityType the entityType
     * @param entityId the entityId
     * @param operationId the operationId
     * @param root the root
     * @param dataIntegrationFieldsForRelationRecordId the dataIntegrationFieldsForRelationRecordId
     * @param dataIntegrationFieldsForDataIntegrationRecordId the dataIntegrationFieldsForDataIntegrationRecordId
     */
    public DataIntegrationRecord(DataIntegrationSet dataIntegrationSet, String entityType, String entityId, String operationId, boolean root, Set<DataIntegrationField> dataIntegrationFieldsForRelationRecordId, Set<DataIntegrationField> dataIntegrationFieldsForDataIntegrationRecordId) {
        this.dataIntegrationSet = dataIntegrationSet;
        this.entityType = entityType;
        this.entityId = entityId;
        this.operationId = operationId;
        this.root = root;
        this.dataIntegrationFieldsForRelationRecordId = dataIntegrationFieldsForRelationRecordId;
        this.dataIntegrationFieldsForDataIntegrationRecordId = dataIntegrationFieldsForDataIntegrationRecordId;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id the id
     *
     * @return DataIntegrationRecord modified instance
     */
    public DataIntegrationRecord setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * dataIntegrationSet getter method
     *
     * @return dataIntegrationSet method
     */
    public DataIntegrationSet getDataIntegrationSet() {
        return this.dataIntegrationSet;
    }
    
    /**       
     * dataIntegrationSet setter method
     *
     * @param dataIntegrationSet the dataIntegrationSet
     *
     * @return DataIntegrationRecord modified instance
     */
    public DataIntegrationRecord setDataIntegrationSet(DataIntegrationSet dataIntegrationSet) {
        this.dataIntegrationSet = dataIntegrationSet;
        
        return this;
    }
    /**       
     * entityType getter method
     *
     * @return entityType method
     */
    public String getEntityType() {
        return this.entityType;
    }
    
    /**       
     * entityType setter method
     *
     * @param entityType the entityType
     *
     * @return DataIntegrationRecord modified instance
     */
    public DataIntegrationRecord setEntityType(String entityType) {
        this.entityType = entityType;
        
        return this;
    }
    /**       
     * entityId getter method
     *
     * @return entityId method
     */
    public String getEntityId() {
        return this.entityId;
    }
    
    /**       
     * entityId setter method
     *
     * @param entityId the entityId
     *
     * @return DataIntegrationRecord modified instance
     */
    public DataIntegrationRecord setEntityId(String entityId) {
        this.entityId = entityId;
        
        return this;
    }
    /**       
     * operationId getter method
     *
     * @return operationId method
     */
    public String getOperationId() {
        return this.operationId;
    }
    
    /**       
     * operationId setter method
     *
     * @param operationId the operationId
     *
     * @return DataIntegrationRecord modified instance
     */
    public DataIntegrationRecord setOperationId(String operationId) {
        this.operationId = operationId;
        
        return this;
    }
    /**       
     * root getter method
     *
     * @return root method
     */
    public boolean isRoot() {
        return this.root;
    }
    
    /**       
     * root setter method
     *
     * @param root the root
     *
     * @return DataIntegrationRecord modified instance
     */
    public DataIntegrationRecord setRoot(boolean root) {
        this.root = root;
        
        return this;
    }
    /**       
     * dataIntegrationFieldsForRelationRecordId getter method
     *
     * @return dataIntegrationFieldsForRelationRecordId method
     */
    public Set<DataIntegrationField> getDataIntegrationFieldsForRelationRecordId() {
        return this.dataIntegrationFieldsForRelationRecordId;
    }
    
    /**       
     * dataIntegrationFieldsForRelationRecordId setter method
     *
     * @param dataIntegrationFieldsForRelationRecordId the dataIntegrationFieldsForRelationRecordId
     *
     * @return DataIntegrationRecord modified instance
     */
    public DataIntegrationRecord setDataIntegrationFieldsForRelationRecordId(Set<DataIntegrationField> dataIntegrationFieldsForRelationRecordId) {
        this.dataIntegrationFieldsForRelationRecordId = dataIntegrationFieldsForRelationRecordId;
        
        return this;
    }
    /**       
     * dataIntegrationFieldsForDataIntegrationRecordId getter method
     *
     * @return dataIntegrationFieldsForDataIntegrationRecordId method
     */
    public Set<DataIntegrationField> getDataIntegrationFieldsForDataIntegrationRecordId() {
        return this.dataIntegrationFieldsForDataIntegrationRecordId;
    }
    
    /**       
     * dataIntegrationFieldsForDataIntegrationRecordId setter method
     *
     * @param dataIntegrationFieldsForDataIntegrationRecordId the dataIntegrationFieldsForDataIntegrationRecordId
     *
     * @return DataIntegrationRecord modified instance
     */
    public DataIntegrationRecord setDataIntegrationFieldsForDataIntegrationRecordId(Set<DataIntegrationField> dataIntegrationFieldsForDataIntegrationRecordId) {
        this.dataIntegrationFieldsForDataIntegrationRecordId = dataIntegrationFieldsForDataIntegrationRecordId;
        
        return this;
    }

    /**
     * Creates a String representation of the DataIntegrationRecord object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("entityType").append("='").append(getEntityType()).append("' ");			
        buffer.append("entityId").append("='").append(getEntityId()).append("' ");			
        buffer.append("operationId").append("='").append(getOperationId()).append("' ");			
        buffer.append("root").append("='").append(isRoot()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the DataIntegrationRecord object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(DataIntegrationRecord other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("entityType".equalsIgnoreCase(attributeName))
        	this.entityType = attributeValue;

        if ("entityId".equalsIgnoreCase(attributeName))
        	this.entityId = attributeValue;

        if ("operationId".equalsIgnoreCase(attributeName))
        	this.operationId = attributeValue;

        if ("root".equalsIgnoreCase(attributeName))
            this.root = Boolean.valueOf(attributeValue);

    }


    /**
     * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
     *
     * @param session the session
     * @param id      the id
     *
     * @return the proxy
     */
    public static DataIntegrationRecord getProxy(Session session, Long id)
    {
        return(DataIntegrationRecord)session.load(DataIntegrationRecord.class,id);
    }

    /**
    * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
    *
    * @param id      the id
    *
    * @return the proxy
    */
    public static DataIntegrationRecord getProxy(Long id)
    {
        Session session = HibernateUtil.getSessionFactory("DIFRepository").getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        DataIntegrationRecord result = (DataIntegrationRecord)session.load(DataIntegrationRecord.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }


    /**
     * Instanciates an Hibernate data object
     *
     * @param session the session
     * @param id      the id
     *
     * @return the instance
     */
    public static DataIntegrationRecord getInstance(Session session, Long id)
    {
        return(DataIntegrationRecord)session.get(DataIntegrationRecord.class,id);
    }

    /**
    * Instanciates an Hibernate data object
    *
    * @param id      the id
    *
    * @return the instance
    */
    public static DataIntegrationRecord getInstance(Long id)
    {
        Session session = HibernateUtil.getSessionFactory("DIFRepository").getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        DataIntegrationRecord result = (DataIntegrationRecord)session.get(DataIntegrationRecord.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }

}
