package pt.digitalis.dif.dem.managers.impl.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link DataIntegrationRecord}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class DataIntegrationRecordFieldAttributes extends AbstractBeanAttributesDefinition{

    /** dataIntegrationSet (Database column: DATA_INTEGRATION_SET_ID) */
    static public AttributeDefinition dataIntegrationSet =
        new AttributeDefinition("dataIntegrationSet")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("DATA_INTEGRATION_RECORD")
                .setDatabaseId("DATA_INTEGRATION_SET_ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setLovDataClass(pt.digitalis.dif.dem.managers.impl.model.data.DataIntegrationSet.class)
                .setLovDataClassKey("id")
                .setType(pt.digitalis.dif.dem.managers.impl.model.data.DataIntegrationSet.class);

    /** entityId (Database column: ENTITY_ID) */
    static public AttributeDefinition entityId =
        new AttributeDefinition("entityId")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("DATA_INTEGRATION_RECORD")
                .setDatabaseId("ENTITY_ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(String.class);

    /** entityType (Database column: ENTITY_TYPE) */
    static public AttributeDefinition entityType =
        new AttributeDefinition("entityType")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("DATA_INTEGRATION_RECORD")
                .setDatabaseId("ENTITY_TYPE")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(String.class);

    /** id (Database column: ID) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("DATA_INTEGRATION_RECORD")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(Long.class);

    /** operationId (Database column: OPERATION_ID) */
    static public AttributeDefinition operationId =
        new AttributeDefinition("operationId")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("DATA_INTEGRATION_RECORD")
                .setDatabaseId("OPERATION_ID")
                .setMandatory(true)
                .setMaxSize(1)
                .setType(String.class);

    /** root (Database column: ROOT) */
    static public AttributeDefinition root =
        new AttributeDefinition("root")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("DATA_INTEGRATION_RECORD")
                .setDatabaseId("ROOT")
                .setMandatory(true)
                .setMaxSize(255)
                .setDefaultValue("0")
                .setType(boolean.class);

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(dataIntegrationSet.getName(),dataIntegrationSet);
        map.put(entityId.getName(),entityId);
        map.put(entityType.getName(),entityType);
        map.put(id.getName(),id);
        map.put(operationId.getName(),operationId);
        map.put(root.getName(),root);

        return map;
    }
}