package pt.digitalis.dif.dem.managers.impl.model.data;


import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.Session;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.model.utils.IBeanAttributesDataSet;

/**
 * DataIntegrationSet
* Generated on ORM Generator
* DIF build process for the Model layer
*
*/
@SuppressWarnings("serial")
public class DataIntegrationSet extends AbstractBeanRelationsAttributes implements java.io.Serializable, IBeanAttributesDataSet<DataIntegrationSet> {

    /** DataIntegrationSet attributes enumeration */
    public static class Fields
    {
        /** id column */
        public static final String ID ="id";
        /** configId column */
        public static final String CONFIGID ="configId";
        /** creationDate column */
        public static final String CREATIONDATE ="creationDate";
        /** processId column */
        public static final String PROCESSID ="processId";

        /**
         * List of existing fields
         *
         * @return list of field names
         */
        public static List<String> values()
        {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("configId");
            list.add("creationDate");
            list.add("processId");

            return list;
        }
    }

    /** Field attributes */
    public static DataIntegrationSetFieldAttributes FieldAttributes=new DataIntegrationSetFieldAttributes();

    /**
    * @return the field attributes definitions
    */
    @Override public DataIntegrationSetFieldAttributes getDefinitions()
    {
        return FieldAttributes;
    }

    /**
     * The Class Relations.
     */
    public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations
    {

        /**
        * Instantiates a new relations.
        *
        * @param currentPath the current path
        */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * dataIntegrationRecords relation.
         *
         * @return the dataIntegrationRecords bean relations attributes.
         */
        public DataIntegrationRecord.Relations dataIntegrationRecords()
        {
            DataIntegrationRecord c = new DataIntegrationRecord();
            return c.new Relations(this.buildPath("dataIntegrationRecords"));
        }

        /**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
        /**
         * the CONFIGID path.
         *
         * @return the path
         */
        public String CONFIGID()
        {
            return buildPath(Fields.CONFIGID);
        }
        /**
         * the CREATIONDATE path.
         *
         * @return the path
         */
        public String CREATIONDATE()
        {
            return buildPath(Fields.CREATIONDATE);
        }
        /**
         * the PROCESSID path.
         *
         * @return the path
         */
        public String PROCESSID()
        {
            return buildPath(Fields.PROCESSID);
        }
    }

    /** The dummy obj. */
    private static DataIntegrationSet dummyObj=new DataIntegrationSet();

    /**
     * Get DataIntegrationSet Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public IDataSet<DataIntegrationSet> getDataSet()
    {
        return new HibernateDataSet<DataIntegrationSet>(DataIntegrationSet.class, HibernateUtil.getSessionFactory("DIFRepository"),
            DataIntegrationSet.getPKFieldListAsString(), DataIntegrationSet.FieldAttributes);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public static IDataSet<DataIntegrationSet> getDataSetInstance()
    {
        return new DataIntegrationSet().getDataSet();
    }

    /**
    * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
    */
    @Override protected Object getAttributeNoGraphNavigation(String attributeName)
    {
        if("id".equalsIgnoreCase(attributeName))
            return id;
        if("configId".equalsIgnoreCase(attributeName))
            return configId;
        if("creationDate".equalsIgnoreCase(attributeName))
            return creationDate;
        if("processId".equalsIgnoreCase(attributeName))
            return processId;
        if("dataIntegrationRecords".equalsIgnoreCase(attributeName))
            return dataIntegrationRecords;

        return null;
    }

    /**
    * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
    */
    public void setAttribute(String attributeName,Object attributeValue)
    {
        if("id".equalsIgnoreCase(attributeName))
            id =(Long)attributeValue;
        if("configId".equalsIgnoreCase(attributeName))
            configId =(String)attributeValue;
        if("creationDate".equalsIgnoreCase(attributeName))
            creationDate =(Timestamp)attributeValue;
        if("processId".equalsIgnoreCase(attributeName))
            processId =(String)attributeValue;
        if("dataIntegrationRecords".equalsIgnoreCase(attributeName))
            dataIntegrationRecords =(Set<DataIntegrationRecord>)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** configId private attribute */
    private String configId;

    /** creationDate private attribute */
    private Timestamp creationDate;

    /** processId private attribute */
    private String processId;

    /** dataIntegrationRecords private attribute */
    private Set<DataIntegrationRecord> dataIntegrationRecords = new HashSet<DataIntegrationRecord>(0);

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {

        Object value = getAttribute(attributeName);

        if (value == null)
            return "";
        else {
            return value.toString().trim();
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public DataIntegrationSet() {
    }

	/** 
	 * minimal constructor
	 *
     * @param configId the configId
     * @param creationDate the creationDate
     * @param processId the processId
    }
	 */
    public DataIntegrationSet(String configId, Timestamp creationDate, String processId) {
        this.configId = configId;
        this.creationDate = creationDate;
        this.processId = processId;
    }

    /**
     * full constructor
	 *
     * @param configId the configId
     * @param creationDate the creationDate
     * @param processId the processId
     * @param dataIntegrationRecords the dataIntegrationRecords
     */
    public DataIntegrationSet(String configId, Timestamp creationDate, String processId, Set<DataIntegrationRecord> dataIntegrationRecords) {
        this.configId = configId;
        this.creationDate = creationDate;
        this.processId = processId;
        this.dataIntegrationRecords = dataIntegrationRecords;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id the id
     *
     * @return DataIntegrationSet modified instance
     */
    public DataIntegrationSet setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * configId getter method
     *
     * @return configId method
     */
    public String getConfigId() {
        return this.configId;
    }
    
    /**       
     * configId setter method
     *
     * @param configId the configId
     *
     * @return DataIntegrationSet modified instance
     */
    public DataIntegrationSet setConfigId(String configId) {
        this.configId = configId;
        
        return this;
    }
    /**       
     * creationDate getter method
     *
     * @return creationDate method
     */
    public Timestamp getCreationDate() {
        return this.creationDate;
    }
    
    /**       
     * creationDate setter method
     *
     * @param creationDate the creationDate
     *
     * @return DataIntegrationSet modified instance
     */
    public DataIntegrationSet setCreationDate(Timestamp creationDate) {
        this.creationDate = creationDate;
        
        return this;
    }
    /**       
     * processId getter method
     *
     * @return processId method
     */
    public String getProcessId() {
        return this.processId;
    }
    
    /**       
     * processId setter method
     *
     * @param processId the processId
     *
     * @return DataIntegrationSet modified instance
     */
    public DataIntegrationSet setProcessId(String processId) {
        this.processId = processId;
        
        return this;
    }
    /**       
     * dataIntegrationRecords getter method
     *
     * @return dataIntegrationRecords method
     */
    public Set<DataIntegrationRecord> getDataIntegrationRecords() {
        return this.dataIntegrationRecords;
    }
    
    /**       
     * dataIntegrationRecords setter method
     *
     * @param dataIntegrationRecords the dataIntegrationRecords
     *
     * @return DataIntegrationSet modified instance
     */
    public DataIntegrationSet setDataIntegrationRecords(Set<DataIntegrationRecord> dataIntegrationRecords) {
        this.dataIntegrationRecords = dataIntegrationRecords;
        
        return this;
    }

    /**
     * Creates a String representation of the DataIntegrationSet object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("configId").append("='").append(getConfigId()).append("' ");			
        buffer.append("creationDate").append("='").append(getCreationDate()).append("' ");			
        buffer.append("processId").append("='").append(getProcessId()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the DataIntegrationSet object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(DataIntegrationSet other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("configId".equalsIgnoreCase(attributeName))
        	this.configId = attributeValue;

        if ("creationDate".equalsIgnoreCase(attributeName))
            this.creationDate = Timestamp.valueOf(attributeValue);

        if ("processId".equalsIgnoreCase(attributeName))
        	this.processId = attributeValue;

    }


    /**
     * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
     *
     * @param session the session
     * @param id      the id
     *
     * @return the proxy
     */
    public static DataIntegrationSet getProxy(Session session, Long id)
    {
        return(DataIntegrationSet)session.load(DataIntegrationSet.class,id);
    }

    /**
    * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
    *
    * @param id      the id
    *
    * @return the proxy
    */
    public static DataIntegrationSet getProxy(Long id)
    {
        Session session = HibernateUtil.getSessionFactory("DIFRepository").getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        DataIntegrationSet result = (DataIntegrationSet)session.load(DataIntegrationSet.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }


    /**
     * Instanciates an Hibernate data object
     *
     * @param session the session
     * @param id      the id
     *
     * @return the instance
     */
    public static DataIntegrationSet getInstance(Session session, Long id)
    {
        return(DataIntegrationSet)session.get(DataIntegrationSet.class,id);
    }

    /**
    * Instanciates an Hibernate data object
    *
    * @param id      the id
    *
    * @return the instance
    */
    public static DataIntegrationSet getInstance(Long id)
    {
        Session session = HibernateUtil.getSessionFactory("DIFRepository").getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        DataIntegrationSet result = (DataIntegrationSet)session.get(DataIntegrationSet.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }

}
