package pt.digitalis.dif.dem.managers.impl.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link EcommercePayments}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class EcommercePaymentsFieldAttributes extends AbstractBeanAttributesDefinition{

    /** authorizationId (Database column: AUTHORIZATION_ID) */
    static public AttributeDefinition authorizationId =
        new AttributeDefinition("authorizationId")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("T_ECOMMERCE_PAYMENTS")
                .setDatabaseId("AUTHORIZATION_ID")
                .setMandatory(true)
                .setMaxSize(20)
                .setType(String.class);

    /** businessContext (Database column: BUSINESS_CONTEXT) */
    static public AttributeDefinition businessContext =
        new AttributeDefinition("businessContext")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("T_ECOMMERCE_PAYMENTS")
                .setDatabaseId("BUSINESS_CONTEXT")
                .setMandatory(true)
                .setMaxSize(4000)
                .setType(String.class);

    /** businessId (Database column: BUSINESS_ID) */
    static public AttributeDefinition businessId =
        new AttributeDefinition("businessId")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("T_ECOMMERCE_PAYMENTS")
                .setDatabaseId("BUSINESS_ID")
                .setMandatory(true)
                .setMaxSize(50)
                .setType(String.class);

    /** configurationId (Database column: CONFIGURATION_ID - Identificador da configurao utilizada para inicializar o pagamento) */
    static public AttributeDefinition configurationId =
        new AttributeDefinition("configurationId")
                .setDescription("Identificador da configurao utilizada para inicializar o pagamento")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("T_ECOMMERCE_PAYMENTS")
                .setDatabaseId("CONFIGURATION_ID")
                .setMandatory(true)
                .setMaxSize(100)
                .setType(String.class);

    /** creator (Database column: CREATOR) */
    static public AttributeDefinition creator =
        new AttributeDefinition("creator")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("T_ECOMMERCE_PAYMENTS")
                .setDatabaseId("CREATOR")
                .setMandatory(true)
                .setMaxSize(50)
                .setType(String.class);

    /** dateCreation (Database column: DATE_CREATION) */
    static public AttributeDefinition dateCreation =
        new AttributeDefinition("dateCreation")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("T_ECOMMERCE_PAYMENTS")
                .setDatabaseId("DATE_CREATION")
                .setMandatory(true)
                .setMaxSize(7)
                .setType(Timestamp.class);

    /** dateProcessed (Database column: DATE_PROCESSED) */
    static public AttributeDefinition dateProcessed =
        new AttributeDefinition("dateProcessed")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("T_ECOMMERCE_PAYMENTS")
                .setDatabaseId("DATE_PROCESSED")
                .setMandatory(true)
                .setMaxSize(7)
                .setType(Timestamp.class);

    /** dateReceived (Database column: DATE_RECEIVED) */
    static public AttributeDefinition dateReceived =
        new AttributeDefinition("dateReceived")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("T_ECOMMERCE_PAYMENTS")
                .setDatabaseId("DATE_RECEIVED")
                .setMandatory(true)
                .setMaxSize(7)
                .setType(Timestamp.class);

    /** ecommerceProcessor (Database column: ECOMMERCE_PROCESSOR) */
    static public AttributeDefinition ecommerceProcessor =
        new AttributeDefinition("ecommerceProcessor")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("T_ECOMMERCE_PAYMENTS")
                .setDatabaseId("ECOMMERCE_PROCESSOR")
                .setMandatory(true)
                .setMaxSize(50)
                .setType(String.class);

    /** errorFriendlyUserMessage (Database column: ERROR_FRIENDLY_USER_MESSAGE) */
    static public AttributeDefinition errorFriendlyUserMessage =
        new AttributeDefinition("errorFriendlyUserMessage")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("T_ECOMMERCE_PAYMENTS")
                .setDatabaseId("ERROR_FRIENDLY_USER_MESSAGE")
                .setMandatory(true)
                .setMaxSize(4000)
                .setType(String.class);

    /** id (Database column: ID) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("T_ECOMMERCE_PAYMENTS")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(Long.class);

    /** paymentContext (Database column: PAYMENT_CONTEXT) */
    static public AttributeDefinition paymentContext =
        new AttributeDefinition("paymentContext")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("T_ECOMMERCE_PAYMENTS")
                .setDatabaseId("PAYMENT_CONTEXT")
                .setMandatory(true)
                .setMaxSize(2000)
                .setType(String.class);

    /** paymentFee (Database column: PAYMENT_FEE) */
    static public AttributeDefinition paymentFee =
        new AttributeDefinition("paymentFee")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("T_ECOMMERCE_PAYMENTS")
                .setDatabaseId("PAYMENT_FEE")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(BigDecimal.class);

    /** paymentValue (Database column: PAYMENT_VALUE) */
    static public AttributeDefinition paymentValue =
        new AttributeDefinition("paymentValue")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("T_ECOMMERCE_PAYMENTS")
                .setDatabaseId("PAYMENT_VALUE")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(BigDecimal.class);

    /** redirectUrl (Database column: REDIRECT_URL) */
    static public AttributeDefinition redirectUrl =
        new AttributeDefinition("redirectUrl")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("T_ECOMMERCE_PAYMENTS")
                .setDatabaseId("REDIRECT_URL")
                .setMandatory(true)
                .setMaxSize(4000)
                .setType(String.class);

    /** securityToken (Database column: SECURITY_TOKEN) */
    static public AttributeDefinition securityToken =
        new AttributeDefinition("securityToken")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("T_ECOMMERCE_PAYMENTS")
                .setDatabaseId("SECURITY_TOKEN")
                .setMandatory(true)
                .setMaxSize(1000)
                .setType(String.class);

    /** sentOnReport (Database column: SENT_ON_REPORT) */
    static public AttributeDefinition sentOnReport =
        new AttributeDefinition("sentOnReport")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("T_ECOMMERCE_PAYMENTS")
                .setDatabaseId("SENT_ON_REPORT")
                .setMandatory(true)
                .setMaxSize(255)
                .setDefaultValue("0")
                .setType(boolean.class);

    /** status (Database column: STATUS) */
    static public AttributeDefinition status =
        new AttributeDefinition("status")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("T_ECOMMERCE_PAYMENTS")
                .setDatabaseId("STATUS")
                .setMandatory(true)
                .setMaxSize(1)
                .setLovFixedList(Arrays.asList(new String[]{"W","R","P","F"}))
                .setType(String.class);

    /** statusMessage (Database column: STATUS_MESSAGE) */
    static public AttributeDefinition statusMessage =
        new AttributeDefinition("statusMessage")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("T_ECOMMERCE_PAYMENTS")
                .setDatabaseId("STATUS_MESSAGE")
                .setMandatory(true)
                .setMaxSize(4000)
                .setType(String.class);

    /** transactionDate (Database column: TRANSACTION_DATE) */
    static public AttributeDefinition transactionDate =
        new AttributeDefinition("transactionDate")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("T_ECOMMERCE_PAYMENTS")
                .setDatabaseId("TRANSACTION_DATE")
                .setMandatory(true)
                .setMaxSize(7)
                .setType(Timestamp.class);

    /** transactionId (Database column: TRANSACTION_ID) */
    static public AttributeDefinition transactionId =
        new AttributeDefinition("transactionId")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("T_ECOMMERCE_PAYMENTS")
                .setDatabaseId("TRANSACTION_ID")
                .setMandatory(true)
                .setMaxSize(100)
                .setType(String.class);

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(authorizationId.getName(),authorizationId);
        map.put(businessContext.getName(),businessContext);
        map.put(businessId.getName(),businessId);
        map.put(configurationId.getName(),configurationId);
        map.put(creator.getName(),creator);
        map.put(dateCreation.getName(),dateCreation);
        map.put(dateProcessed.getName(),dateProcessed);
        map.put(dateReceived.getName(),dateReceived);
        map.put(ecommerceProcessor.getName(),ecommerceProcessor);
        map.put(errorFriendlyUserMessage.getName(),errorFriendlyUserMessage);
        map.put(id.getName(),id);
        map.put(paymentContext.getName(),paymentContext);
        map.put(paymentFee.getName(),paymentFee);
        map.put(paymentValue.getName(),paymentValue);
        map.put(redirectUrl.getName(),redirectUrl);
        map.put(securityToken.getName(),securityToken);
        map.put(sentOnReport.getName(),sentOnReport);
        map.put(status.getName(),status);
        map.put(statusMessage.getName(),statusMessage);
        map.put(transactionDate.getName(),transactionDate);
        map.put(transactionId.getName(),transactionId);

        return map;
    }
}