package pt.digitalis.dif.dem.managers.impl.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link ErrorLog}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class ErrorLogFieldAttributes extends AbstractBeanAttributesDefinition{

    /** appName (Database column: APP_NAME) */
    static public AttributeDefinition appName =
        new AttributeDefinition("appName")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("ERROR_LOG")
                .setDatabaseId("APP_NAME")
                .setMandatory(true)
                .setMaxSize(150)
                .setType(String.class);

    /** errorDescription (Database column: ERROR_DESCRIPTION - THE ERROR DESCRIPTION) */
    static public AttributeDefinition errorDescription =
        new AttributeDefinition("errorDescription")
                .setDescription("THE ERROR DESCRIPTION")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("ERROR_LOG")
                .setDatabaseId("ERROR_DESCRIPTION")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(String.class);

    /** erroDate (Database column: ERRO_DATE - THE DATE WHEN THE ERROR WAS LOGGED) */
    static public AttributeDefinition erroDate =
        new AttributeDefinition("erroDate")
                .setDescription("THE DATE WHEN THE ERROR WAS LOGGED")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("ERROR_LOG")
                .setDatabaseId("ERRO_DATE")
                .setMandatory(true)
                .setMaxSize(7)
                .setType(Timestamp.class);

    /** id (Database column: ID - Unique identifier for PK) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDescription("Unique identifier for PK")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("ERROR_LOG")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(Long.class);

    /** processName (Database column: PROCESS_NAME - THE PROCESS NAME) */
    static public AttributeDefinition processName =
        new AttributeDefinition("processName")
                .setDescription("THE PROCESS NAME")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("ERROR_LOG")
                .setDatabaseId("PROCESS_NAME")
                .setMandatory(true)
                .setMaxSize(500)
                .setType(String.class);

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(appName.getName(),appName);
        map.put(errorDescription.getName(),errorDescription);
        map.put(erroDate.getName(),erroDate);
        map.put(id.getName(),id);
        map.put(processName.getName(),processName);

        return map;
    }
}