package pt.digitalis.dif.dem.managers.impl.model.data;


import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.model.utils.IBeanAttributesDataSet;

/**
 * EventLogProcess
* Generated on ORM Generator
* DIF build process for the Model layer
*
*/
@SuppressWarnings("serial")
public class EventLogProcess extends AbstractBeanRelationsAttributes implements java.io.Serializable, IBeanAttributesDataSet<EventLogProcess> {

    /** EventLogProcess attributes enumeration */
    public static class Fields
    {
        /** id column */
        public static final String ID ="id";
        /** configId column */
        public static final String CONFIGID ="configId";
        /** dateEventProcess column */
        public static final String DATEEVENTPROCESS ="dateEventProcess";
        /** state column */
        public static final String STATE ="state";
        /** result column */
        public static final String RESULT ="result";
        /** externalId column */
        public static final String EXTERNALID ="externalId";

        /**
         * List of existing fields
         *
         * @return list of field names
         */
        public static List<String> values()
        {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("configId");
            list.add("dateEventProcess");
            list.add("state");
            list.add("result");
            list.add("externalId");

            return list;
        }
    }

    /** Field attributes */
    public static EventLogProcessFieldAttributes FieldAttributes=new EventLogProcessFieldAttributes();

    /**
    * @return the field attributes definitions
    */
    @Override public EventLogProcessFieldAttributes getDefinitions()
    {
        return FieldAttributes;
    }

    /**
     * The Class Relations.
     */
    public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations
    {

        /**
        * Instantiates a new relations.
        *
        * @param currentPath the current path
        */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * event relation.
         *
         * @return the event bean relations attributes.
         */
        public Event.Relations event()
        {
            Event c = new Event();
            return c.new Relations(this.buildPath("event"));
        }

        /**
         * eventSubscription relation.
         *
         * @return the eventSubscription bean relations attributes.
         */
        public EventSubscription.Relations eventSubscription()
        {
            EventSubscription c = new EventSubscription();
            return c.new Relations(this.buildPath("eventSubscription"));
        }

        /**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
        /**
         * the CONFIGID path.
         *
         * @return the path
         */
        public String CONFIGID()
        {
            return buildPath(Fields.CONFIGID);
        }
        /**
         * the DATEEVENTPROCESS path.
         *
         * @return the path
         */
        public String DATEEVENTPROCESS()
        {
            return buildPath(Fields.DATEEVENTPROCESS);
        }
        /**
         * the STATE path.
         *
         * @return the path
         */
        public String STATE()
        {
            return buildPath(Fields.STATE);
        }
        /**
         * the RESULT path.
         *
         * @return the path
         */
        public String RESULT()
        {
            return buildPath(Fields.RESULT);
        }
        /**
         * the EXTERNALID path.
         *
         * @return the path
         */
        public String EXTERNALID()
        {
            return buildPath(Fields.EXTERNALID);
        }
    }

    /** The dummy obj. */
    private static EventLogProcess dummyObj=new EventLogProcess();

    /**
     * Get EventLogProcess Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public IDataSet<EventLogProcess> getDataSet()
    {
        return new HibernateDataSet<EventLogProcess>(EventLogProcess.class, HibernateUtil.getSessionFactory("DIFRepository"),
            EventLogProcess.getPKFieldListAsString(), EventLogProcess.FieldAttributes);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public static IDataSet<EventLogProcess> getDataSetInstance()
    {
        return new EventLogProcess().getDataSet();
    }

    /**
    * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
    */
    @Override protected Object getAttributeNoGraphNavigation(String attributeName)
    {
        if("id".equalsIgnoreCase(attributeName))
            return id;
        if("event".equalsIgnoreCase(attributeName))
            return event;
        if("eventSubscription".equalsIgnoreCase(attributeName))
            return eventSubscription;
        if("configId".equalsIgnoreCase(attributeName))
            return configId;
        if("dateEventProcess".equalsIgnoreCase(attributeName))
            return dateEventProcess;
        if("state".equalsIgnoreCase(attributeName))
            return state;
        if("result".equalsIgnoreCase(attributeName))
            return result;
        if("externalId".equalsIgnoreCase(attributeName))
            return externalId;

        return null;
    }

    /**
    * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
    */
    public void setAttribute(String attributeName,Object attributeValue)
    {
        if("id".equalsIgnoreCase(attributeName))
            id =(Long)attributeValue;
        if("event".equalsIgnoreCase(attributeName))
            event =(Event)attributeValue;
        if("eventSubscription".equalsIgnoreCase(attributeName))
            eventSubscription =(EventSubscription)attributeValue;
        if("configId".equalsIgnoreCase(attributeName))
            configId =(String)attributeValue;
        if("dateEventProcess".equalsIgnoreCase(attributeName))
            dateEventProcess =(Timestamp)attributeValue;
        if("state".equalsIgnoreCase(attributeName))
            state =(String)attributeValue;
        if("result".equalsIgnoreCase(attributeName))
            result =(String)attributeValue;
        if("externalId".equalsIgnoreCase(attributeName))
            externalId =(String)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** event private attribute */
    private Event event;

    /** eventSubscription private attribute */
    private EventSubscription eventSubscription;

    /** configId private attribute */
    private String configId;

    /** dateEventProcess private attribute */
    private Timestamp dateEventProcess;

    /** state private attribute */
    private String state;

    /** result private attribute */
    private String result;

    /** externalId private attribute */
    private String externalId;

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {

        Object value = getAttribute(attributeName);

        if (value == null)
            return "";
        else {
            return value.toString().trim();
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public EventLogProcess() {
    }

	/** 
	 * minimal constructor
	 *
     * @param eventSubscription the eventSubscription
     * @param configId the configId
     * @param dateEventProcess the dateEventProcess
     * @param state the state
     * @param result the result
    }
	 */
    public EventLogProcess(EventSubscription eventSubscription, String configId, Timestamp dateEventProcess, String state, String result) {
        this.eventSubscription = eventSubscription;
        this.configId = configId;
        this.dateEventProcess = dateEventProcess;
        this.state = state;
        this.result = result;
    }

    /**
     * full constructor
	 *
     * @param event the event
     * @param eventSubscription the eventSubscription
     * @param configId the configId
     * @param dateEventProcess the dateEventProcess
     * @param state the state
     * @param result the result
     * @param externalId the externalId
     */
    public EventLogProcess(Event event, EventSubscription eventSubscription, String configId, Timestamp dateEventProcess, String state, String result, String externalId) {
        this.event = event;
        this.eventSubscription = eventSubscription;
        this.configId = configId;
        this.dateEventProcess = dateEventProcess;
        this.state = state;
        this.result = result;
        this.externalId = externalId;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id the id
     *
     * @return EventLogProcess modified instance
     */
    public EventLogProcess setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * event getter method
     *
     * @return event method
     */
    public Event getEvent() {
        return this.event;
    }
    
    /**       
     * event setter method
     *
     * @param event the event
     *
     * @return EventLogProcess modified instance
     */
    public EventLogProcess setEvent(Event event) {
        this.event = event;
        
        return this;
    }
    /**       
     * eventSubscription getter method
     *
     * @return eventSubscription method
     */
    public EventSubscription getEventSubscription() {
        return this.eventSubscription;
    }
    
    /**       
     * eventSubscription setter method
     *
     * @param eventSubscription the eventSubscription
     *
     * @return EventLogProcess modified instance
     */
    public EventLogProcess setEventSubscription(EventSubscription eventSubscription) {
        this.eventSubscription = eventSubscription;
        
        return this;
    }
    /**       
     * configId getter method
     *
     * @return configId method
     */
    public String getConfigId() {
        return this.configId;
    }
    
    /**       
     * configId setter method
     *
     * @param configId the configId
     *
     * @return EventLogProcess modified instance
     */
    public EventLogProcess setConfigId(String configId) {
        this.configId = configId;
        
        return this;
    }
    /**       
     * dateEventProcess getter method
     *
     * @return dateEventProcess method
     */
    public Timestamp getDateEventProcess() {
        return this.dateEventProcess;
    }
    
    /**       
     * dateEventProcess setter method
     *
     * @param dateEventProcess the dateEventProcess
     *
     * @return EventLogProcess modified instance
     */
    public EventLogProcess setDateEventProcess(Timestamp dateEventProcess) {
        this.dateEventProcess = dateEventProcess;
        
        return this;
    }
    /**       
     * state getter method
     *
     * @return state method
     */
    public String getState() {
        return this.state;
    }
    
    /**       
     * state setter method
     *
     * @param state the state
     *
     * @return EventLogProcess modified instance
     */
    public EventLogProcess setState(String state) {
        this.state = state;
        
        return this;
    }
    /**       
     * result getter method
     *
     * @return result method
     */
    public String getResult() {
        return this.result;
    }
    
    /**       
     * result setter method
     *
     * @param result the result
     *
     * @return EventLogProcess modified instance
     */
    public EventLogProcess setResult(String result) {
        this.result = result;
        
        return this;
    }
    /**       
     * externalId getter method
     *
     * @return externalId method
     */
    public String getExternalId() {
        return this.externalId;
    }
    
    /**       
     * externalId setter method
     *
     * @param externalId the externalId
     *
     * @return EventLogProcess modified instance
     */
    public EventLogProcess setExternalId(String externalId) {
        this.externalId = externalId;
        
        return this;
    }

    /**
     * Creates a String representation of the EventLogProcess object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("configId").append("='").append(getConfigId()).append("' ");			
        buffer.append("dateEventProcess").append("='").append(getDateEventProcess()).append("' ");			
        buffer.append("state").append("='").append(getState()).append("' ");			
        buffer.append("result").append("='").append(getResult()).append("' ");			
        buffer.append("externalId").append("='").append(getExternalId()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the EventLogProcess object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(EventLogProcess other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("configId".equalsIgnoreCase(attributeName))
        	this.configId = attributeValue;

        if ("dateEventProcess".equalsIgnoreCase(attributeName))
            this.dateEventProcess = Timestamp.valueOf(attributeValue);

        if ("state".equalsIgnoreCase(attributeName))
        	this.state = attributeValue;

        if ("result".equalsIgnoreCase(attributeName))
        	this.result = attributeValue;

        if ("externalId".equalsIgnoreCase(attributeName))
        	this.externalId = attributeValue;

    }


    /**
     * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
     *
     * @param session the session
     * @param id      the id
     *
     * @return the proxy
     */
    public static EventLogProcess getProxy(Session session, Long id)
    {
        return(EventLogProcess)session.load(EventLogProcess.class,id);
    }

    /**
    * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
    *
    * @param id      the id
    *
    * @return the proxy
    */
    public static EventLogProcess getProxy(Long id)
    {
        Session session = HibernateUtil.getSessionFactory("DIFRepository").getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        EventLogProcess result = (EventLogProcess)session.load(EventLogProcess.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }


    /**
     * Instanciates an Hibernate data object
     *
     * @param session the session
     * @param id      the id
     *
     * @return the instance
     */
    public static EventLogProcess getInstance(Session session, Long id)
    {
        return(EventLogProcess)session.get(EventLogProcess.class,id);
    }

    /**
    * Instanciates an Hibernate data object
    *
    * @param id      the id
    *
    * @return the instance
    */
    public static EventLogProcess getInstance(Long id)
    {
        Session session = HibernateUtil.getSessionFactory("DIFRepository").getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        EventLogProcess result = (EventLogProcess)session.get(EventLogProcess.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }

}
