package pt.digitalis.dif.dem.managers.impl.model.data;


import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.Session;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.model.utils.IBeanAttributesDataSet;

/**
 * EventSubscription
* Generated on ORM Generator
* DIF build process for the Model layer
*
*/
@SuppressWarnings("serial")
public class EventSubscription extends AbstractBeanRelationsAttributes implements java.io.Serializable, IBeanAttributesDataSet<EventSubscription> {

    /** EventSubscription attributes enumeration */
    public static class Fields
    {
        /** id column */
        public static final String ID ="id";
        /** configId column */
        public static final String CONFIGID ="configId";
        /** publisherId column */
        public static final String PUBLISHERID ="publisherId";
        /** categoryId column */
        public static final String CATEGORYID ="categoryId";
        /** subscriberId column */
        public static final String SUBSCRIBERID ="subscriberId";
        /** configuration column */
        public static final String CONFIGURATION ="configuration";
        /** isEnabled column */
        public static final String ISENABLED ="isEnabled";

        /**
         * List of existing fields
         *
         * @return list of field names
         */
        public static List<String> values()
        {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("configId");
            list.add("publisherId");
            list.add("categoryId");
            list.add("subscriberId");
            list.add("configuration");
            list.add("isEnabled");

            return list;
        }
    }

    /** Field attributes */
    public static EventSubscriptionFieldAttributes FieldAttributes=new EventSubscriptionFieldAttributes();

    /**
    * @return the field attributes definitions
    */
    @Override public EventSubscriptionFieldAttributes getDefinitions()
    {
        return FieldAttributes;
    }

    /**
     * The Class Relations.
     */
    public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations
    {

        /**
        * Instantiates a new relations.
        *
        * @param currentPath the current path
        */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * eventLogProcesses relation.
         *
         * @return the eventLogProcesses bean relations attributes.
         */
        public EventLogProcess.Relations eventLogProcesses()
        {
            EventLogProcess c = new EventLogProcess();
            return c.new Relations(this.buildPath("eventLogProcesses"));
        }

        /**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
        /**
         * the CONFIGID path.
         *
         * @return the path
         */
        public String CONFIGID()
        {
            return buildPath(Fields.CONFIGID);
        }
        /**
         * the PUBLISHERID path.
         *
         * @return the path
         */
        public String PUBLISHERID()
        {
            return buildPath(Fields.PUBLISHERID);
        }
        /**
         * the CATEGORYID path.
         *
         * @return the path
         */
        public String CATEGORYID()
        {
            return buildPath(Fields.CATEGORYID);
        }
        /**
         * the SUBSCRIBERID path.
         *
         * @return the path
         */
        public String SUBSCRIBERID()
        {
            return buildPath(Fields.SUBSCRIBERID);
        }
        /**
         * the CONFIGURATION path.
         *
         * @return the path
         */
        public String CONFIGURATION()
        {
            return buildPath(Fields.CONFIGURATION);
        }
        /**
         * the ISENABLED path.
         *
         * @return the path
         */
        public String ISENABLED()
        {
            return buildPath(Fields.ISENABLED);
        }
    }

    /** The dummy obj. */
    private static EventSubscription dummyObj=new EventSubscription();

    /**
     * Get EventSubscription Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public IDataSet<EventSubscription> getDataSet()
    {
        return new HibernateDataSet<EventSubscription>(EventSubscription.class, HibernateUtil.getSessionFactory("DIFRepository"),
            EventSubscription.getPKFieldListAsString(), EventSubscription.FieldAttributes);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public static IDataSet<EventSubscription> getDataSetInstance()
    {
        return new EventSubscription().getDataSet();
    }

    /**
    * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
    */
    @Override protected Object getAttributeNoGraphNavigation(String attributeName)
    {
        if("id".equalsIgnoreCase(attributeName))
            return id;
        if("configId".equalsIgnoreCase(attributeName))
            return configId;
        if("publisherId".equalsIgnoreCase(attributeName))
            return publisherId;
        if("categoryId".equalsIgnoreCase(attributeName))
            return categoryId;
        if("subscriberId".equalsIgnoreCase(attributeName))
            return subscriberId;
        if("configuration".equalsIgnoreCase(attributeName))
            return configuration;
        if("isEnabled".equalsIgnoreCase(attributeName))
            return isEnabled;
        if("eventLogProcesses".equalsIgnoreCase(attributeName))
            return eventLogProcesses;

        return null;
    }

    /**
    * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
    */
    public void setAttribute(String attributeName,Object attributeValue)
    {
        if("id".equalsIgnoreCase(attributeName))
            id =(Long)attributeValue;
        if("configId".equalsIgnoreCase(attributeName))
            configId =(String)attributeValue;
        if("publisherId".equalsIgnoreCase(attributeName))
            publisherId =(String)attributeValue;
        if("categoryId".equalsIgnoreCase(attributeName))
            categoryId =(String)attributeValue;
        if("subscriberId".equalsIgnoreCase(attributeName))
            subscriberId =(String)attributeValue;
        if("configuration".equalsIgnoreCase(attributeName))
            configuration =(String)attributeValue;
        if("isEnabled".equalsIgnoreCase(attributeName))
            isEnabled =(Boolean)attributeValue;
        if("eventLogProcesses".equalsIgnoreCase(attributeName))
            eventLogProcesses =(Set<EventLogProcess>)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** configId private attribute */
    private String configId;

    /** publisherId private attribute */
    private String publisherId;

    /** categoryId private attribute */
    private String categoryId;

    /** subscriberId private attribute */
    private String subscriberId;

    /** configuration private attribute */
    private String configuration;

    /** isEnabled private attribute */
    private boolean isEnabled;

    /** eventLogProcesses private attribute */
    private Set<EventLogProcess> eventLogProcesses = new HashSet<EventLogProcess>(0);

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {

        Object value = getAttribute(attributeName);

        if (value == null)
            return "";
        else {
            return value.toString().trim();
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public EventSubscription() {
    }

	/** 
	 * minimal constructor
	 *
     * @param configId the configId
     * @param isEnabled the isEnabled
    }
	 */
    public EventSubscription(String configId, boolean isEnabled) {
        this.configId = configId;
        this.isEnabled = isEnabled;
    }

    /**
     * full constructor
	 *
     * @param configId the configId
     * @param publisherId the publisherId
     * @param categoryId the categoryId
     * @param subscriberId the subscriberId
     * @param configuration the configuration
     * @param isEnabled the isEnabled
     * @param eventLogProcesses the eventLogProcesses
     */
    public EventSubscription(String configId, String publisherId, String categoryId, String subscriberId, String configuration, boolean isEnabled, Set<EventLogProcess> eventLogProcesses) {
        this.configId = configId;
        this.publisherId = publisherId;
        this.categoryId = categoryId;
        this.subscriberId = subscriberId;
        this.configuration = configuration;
        this.isEnabled = isEnabled;
        this.eventLogProcesses = eventLogProcesses;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id the id
     *
     * @return EventSubscription modified instance
     */
    public EventSubscription setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * configId getter method
     *
     * @return configId method
     */
    public String getConfigId() {
        return this.configId;
    }
    
    /**       
     * configId setter method
     *
     * @param configId the configId
     *
     * @return EventSubscription modified instance
     */
    public EventSubscription setConfigId(String configId) {
        this.configId = configId;
        
        return this;
    }
    /**       
     * publisherId getter method
     *
     * @return publisherId method
     */
    public String getPublisherId() {
        return this.publisherId;
    }
    
    /**       
     * publisherId setter method
     *
     * @param publisherId the publisherId
     *
     * @return EventSubscription modified instance
     */
    public EventSubscription setPublisherId(String publisherId) {
        this.publisherId = publisherId;
        
        return this;
    }
    /**       
     * categoryId getter method
     *
     * @return categoryId method
     */
    public String getCategoryId() {
        return this.categoryId;
    }
    
    /**       
     * categoryId setter method
     *
     * @param categoryId the categoryId
     *
     * @return EventSubscription modified instance
     */
    public EventSubscription setCategoryId(String categoryId) {
        this.categoryId = categoryId;
        
        return this;
    }
    /**       
     * subscriberId getter method
     *
     * @return subscriberId method
     */
    public String getSubscriberId() {
        return this.subscriberId;
    }
    
    /**       
     * subscriberId setter method
     *
     * @param subscriberId the subscriberId
     *
     * @return EventSubscription modified instance
     */
    public EventSubscription setSubscriberId(String subscriberId) {
        this.subscriberId = subscriberId;
        
        return this;
    }
    /**       
     * configuration getter method
     *
     * @return configuration method
     */
    public String getConfiguration() {
        return this.configuration;
    }
    
    /**       
     * configuration setter method
     *
     * @param configuration the configuration
     *
     * @return EventSubscription modified instance
     */
    public EventSubscription setConfiguration(String configuration) {
        this.configuration = configuration;
        
        return this;
    }
    /**       
     * isEnabled getter method
     *
     * @return isEnabled method
     */
    public boolean isIsEnabled() {
        return this.isEnabled;
    }
    
    /**       
     * isEnabled setter method
     *
     * @param isEnabled the isEnabled
     *
     * @return EventSubscription modified instance
     */
    public EventSubscription setIsEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
        
        return this;
    }
    /**       
     * eventLogProcesses getter method
     *
     * @return eventLogProcesses method
     */
    public Set<EventLogProcess> getEventLogProcesses() {
        return this.eventLogProcesses;
    }
    
    /**       
     * eventLogProcesses setter method
     *
     * @param eventLogProcesses the eventLogProcesses
     *
     * @return EventSubscription modified instance
     */
    public EventSubscription setEventLogProcesses(Set<EventLogProcess> eventLogProcesses) {
        this.eventLogProcesses = eventLogProcesses;
        
        return this;
    }

    /**
     * Creates a String representation of the EventSubscription object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("configId").append("='").append(getConfigId()).append("' ");			
        buffer.append("publisherId").append("='").append(getPublisherId()).append("' ");			
        buffer.append("categoryId").append("='").append(getCategoryId()).append("' ");			
        buffer.append("subscriberId").append("='").append(getSubscriberId()).append("' ");			
        buffer.append("configuration").append("='").append(getConfiguration()).append("' ");			
        buffer.append("isEnabled").append("='").append(isIsEnabled()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the EventSubscription object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(EventSubscription other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("configId".equalsIgnoreCase(attributeName))
        	this.configId = attributeValue;

        if ("publisherId".equalsIgnoreCase(attributeName))
        	this.publisherId = attributeValue;

        if ("categoryId".equalsIgnoreCase(attributeName))
        	this.categoryId = attributeValue;

        if ("subscriberId".equalsIgnoreCase(attributeName))
        	this.subscriberId = attributeValue;

        if ("configuration".equalsIgnoreCase(attributeName))
        	this.configuration = attributeValue;

        if ("isEnabled".equalsIgnoreCase(attributeName))
            this.isEnabled = Boolean.valueOf(attributeValue);

    }


    /**
     * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
     *
     * @param session the session
     * @param id      the id
     *
     * @return the proxy
     */
    public static EventSubscription getProxy(Session session, Long id)
    {
        return(EventSubscription)session.load(EventSubscription.class,id);
    }

    /**
    * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
    *
    * @param id      the id
    *
    * @return the proxy
    */
    public static EventSubscription getProxy(Long id)
    {
        Session session = HibernateUtil.getSessionFactory("DIFRepository").getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        EventSubscription result = (EventSubscription)session.load(EventSubscription.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }


    /**
     * Instanciates an Hibernate data object
     *
     * @param session the session
     * @param id      the id
     *
     * @return the instance
     */
    public static EventSubscription getInstance(Session session, Long id)
    {
        return(EventSubscription)session.get(EventSubscription.class,id);
    }

    /**
    * Instanciates an Hibernate data object
    *
    * @param id      the id
    *
    * @return the instance
    */
    public static EventSubscription getInstance(Long id)
    {
        Session session = HibernateUtil.getSessionFactory("DIFRepository").getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        EventSubscription result = (EventSubscription)session.get(EventSubscription.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }

}
