package pt.digitalis.dif.dem.managers.impl.model.data;


import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.Session;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.model.utils.IBeanAttributesDataSet;

/**
 * FileBundleFile
* Generated on ORM Generator
* DIF build process for the Model layer
*
*/
@SuppressWarnings("serial")
public class FileBundleFile extends AbstractBeanRelationsAttributes implements java.io.Serializable, IBeanAttributesDataSet<FileBundleFile> {

    /** FileBundleFile attributes enumeration */
    public static class Fields
    {
        /** id column */
        public static final String ID ="id";
        /** title column */
        public static final String TITLE ="title";
        /** description column */
        public static final String DESCRIPTION ="description";
        /** isMandatory column */
        public static final String ISMANDATORY ="isMandatory";
        /** isVersioned column */
        public static final String ISVERSIONED ="isVersioned";
        /** hasValidation column */
        public static final String HASVALIDATION ="hasValidation";

        /**
         * List of existing fields
         *
         * @return list of field names
         */
        public static List<String> values()
        {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("title");
            list.add("description");
            list.add("isMandatory");
            list.add("isVersioned");
            list.add("hasValidation");

            return list;
        }
    }

    /** Field attributes */
    public static FileBundleFileFieldAttributes FieldAttributes=new FileBundleFileFieldAttributes();

    /**
    * @return the field attributes definitions
    */
    @Override public FileBundleFileFieldAttributes getDefinitions()
    {
        return FieldAttributes;
    }

    /**
     * The Class Relations.
     */
    public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations
    {

        /**
        * Instantiates a new relations.
        *
        * @param currentPath the current path
        */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * fileType relation.
         *
         * @return the fileType bean relations attributes.
         */
        public FileType.Relations fileType()
        {
            FileType c = new FileType();
            return c.new Relations(this.buildPath("fileType"));
        }

        /**
         * fileBundle relation.
         *
         * @return the fileBundle bean relations attributes.
         */
        public FileBundle.Relations fileBundle()
        {
            FileBundle c = new FileBundle();
            return c.new Relations(this.buildPath("fileBundle"));
        }

        /**
         * workflowFileAcls relation.
         *
         * @return the workflowFileAcls bean relations attributes.
         */
        public WorkflowFileAcl.Relations workflowFileAcls()
        {
            WorkflowFileAcl c = new WorkflowFileAcl();
            return c.new Relations(this.buildPath("workflowFileAcls"));
        }

        /**
         * fileBundleInstanceFiles relation.
         *
         * @return the fileBundleInstanceFiles bean relations attributes.
         */
        public FileBundleInstanceFile.Relations fileBundleInstanceFiles()
        {
            FileBundleInstanceFile c = new FileBundleInstanceFile();
            return c.new Relations(this.buildPath("fileBundleInstanceFiles"));
        }

        /**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
        /**
         * the TITLE path.
         *
         * @return the path
         */
        public String TITLE()
        {
            return buildPath(Fields.TITLE);
        }
        /**
         * the DESCRIPTION path.
         *
         * @return the path
         */
        public String DESCRIPTION()
        {
            return buildPath(Fields.DESCRIPTION);
        }
        /**
         * the ISMANDATORY path.
         *
         * @return the path
         */
        public String ISMANDATORY()
        {
            return buildPath(Fields.ISMANDATORY);
        }
        /**
         * the ISVERSIONED path.
         *
         * @return the path
         */
        public String ISVERSIONED()
        {
            return buildPath(Fields.ISVERSIONED);
        }
        /**
         * the HASVALIDATION path.
         *
         * @return the path
         */
        public String HASVALIDATION()
        {
            return buildPath(Fields.HASVALIDATION);
        }
    }

    /** The dummy obj. */
    private static FileBundleFile dummyObj=new FileBundleFile();

    /**
     * Get FileBundleFile Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public IDataSet<FileBundleFile> getDataSet()
    {
        return new HibernateDataSet<FileBundleFile>(FileBundleFile.class, HibernateUtil.getSessionFactory("DIFRepository"),
            FileBundleFile.getPKFieldListAsString(), FileBundleFile.FieldAttributes);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public static IDataSet<FileBundleFile> getDataSetInstance()
    {
        return new FileBundleFile().getDataSet();
    }

    /**
    * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
    */
    @Override protected Object getAttributeNoGraphNavigation(String attributeName)
    {
        if("id".equalsIgnoreCase(attributeName))
            return id;
        if("fileType".equalsIgnoreCase(attributeName))
            return fileType;
        if("fileBundle".equalsIgnoreCase(attributeName))
            return fileBundle;
        if("title".equalsIgnoreCase(attributeName))
            return title;
        if("description".equalsIgnoreCase(attributeName))
            return description;
        if("isMandatory".equalsIgnoreCase(attributeName))
            return isMandatory;
        if("isVersioned".equalsIgnoreCase(attributeName))
            return isVersioned;
        if("hasValidation".equalsIgnoreCase(attributeName))
            return hasValidation;
        if("workflowFileAcls".equalsIgnoreCase(attributeName))
            return workflowFileAcls;
        if("fileBundleInstanceFiles".equalsIgnoreCase(attributeName))
            return fileBundleInstanceFiles;

        return null;
    }

    /**
    * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
    */
    public void setAttribute(String attributeName,Object attributeValue)
    {
        if("id".equalsIgnoreCase(attributeName))
            id =(Long)attributeValue;
        if("fileType".equalsIgnoreCase(attributeName))
            fileType =(FileType)attributeValue;
        if("fileBundle".equalsIgnoreCase(attributeName))
            fileBundle =(FileBundle)attributeValue;
        if("title".equalsIgnoreCase(attributeName))
            title =(String)attributeValue;
        if("description".equalsIgnoreCase(attributeName))
            description =(String)attributeValue;
        if("isMandatory".equalsIgnoreCase(attributeName))
            isMandatory =(Boolean)attributeValue;
        if("isVersioned".equalsIgnoreCase(attributeName))
            isVersioned =(Boolean)attributeValue;
        if("hasValidation".equalsIgnoreCase(attributeName))
            hasValidation =(Boolean)attributeValue;
        if("workflowFileAcls".equalsIgnoreCase(attributeName))
            workflowFileAcls =(Set<WorkflowFileAcl>)attributeValue;
        if("fileBundleInstanceFiles".equalsIgnoreCase(attributeName))
            fileBundleInstanceFiles =(Set<FileBundleInstanceFile>)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** fileType private attribute */
    private FileType fileType;

    /** fileBundle private attribute */
    private FileBundle fileBundle;

    /** title private attribute */
    private String title;

    /** description private attribute */
    private String description;

    /** isMandatory private attribute */
    private boolean isMandatory;

    /** isVersioned private attribute */
    private boolean isVersioned;

    /** hasValidation private attribute */
    private boolean hasValidation;

    /** workflowFileAcls private attribute */
    private Set<WorkflowFileAcl> workflowFileAcls = new HashSet<WorkflowFileAcl>(0);

    /** fileBundleInstanceFiles private attribute */
    private Set<FileBundleInstanceFile> fileBundleInstanceFiles = new HashSet<FileBundleInstanceFile>(0);

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {

        Object value = getAttribute(attributeName);

        if (value == null)
            return "";
        else {
            return value.toString().trim();
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public FileBundleFile() {
    }

	/** 
	 * minimal constructor
	 *
     * @param fileBundle the fileBundle
     * @param title the title
     * @param isMandatory the isMandatory
     * @param isVersioned the isVersioned
     * @param hasValidation the hasValidation
    }
	 */
    public FileBundleFile(FileBundle fileBundle, String title, boolean isMandatory, boolean isVersioned, boolean hasValidation) {
        this.fileBundle = fileBundle;
        this.title = title;
        this.isMandatory = isMandatory;
        this.isVersioned = isVersioned;
        this.hasValidation = hasValidation;
    }

    /**
     * full constructor
	 *
     * @param fileType the fileType
     * @param fileBundle the fileBundle
     * @param title the title
     * @param description the description
     * @param isMandatory the isMandatory
     * @param isVersioned the isVersioned
     * @param hasValidation the hasValidation
     * @param workflowFileAcls the workflowFileAcls
     * @param fileBundleInstanceFiles the fileBundleInstanceFiles
     */
    public FileBundleFile(FileType fileType, FileBundle fileBundle, String title, String description, boolean isMandatory, boolean isVersioned, boolean hasValidation, Set<WorkflowFileAcl> workflowFileAcls, Set<FileBundleInstanceFile> fileBundleInstanceFiles) {
        this.fileType = fileType;
        this.fileBundle = fileBundle;
        this.title = title;
        this.description = description;
        this.isMandatory = isMandatory;
        this.isVersioned = isVersioned;
        this.hasValidation = hasValidation;
        this.workflowFileAcls = workflowFileAcls;
        this.fileBundleInstanceFiles = fileBundleInstanceFiles;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id the id
     *
     * @return FileBundleFile modified instance
     */
    public FileBundleFile setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * fileType getter method
     *
     * @return fileType method
     */
    public FileType getFileType() {
        return this.fileType;
    }
    
    /**       
     * fileType setter method
     *
     * @param fileType the fileType
     *
     * @return FileBundleFile modified instance
     */
    public FileBundleFile setFileType(FileType fileType) {
        this.fileType = fileType;
        
        return this;
    }
    /**       
     * fileBundle getter method
     *
     * @return fileBundle method
     */
    public FileBundle getFileBundle() {
        return this.fileBundle;
    }
    
    /**       
     * fileBundle setter method
     *
     * @param fileBundle the fileBundle
     *
     * @return FileBundleFile modified instance
     */
    public FileBundleFile setFileBundle(FileBundle fileBundle) {
        this.fileBundle = fileBundle;
        
        return this;
    }
    /**       
     * title getter method
     *
     * @return title method
     */
    public String getTitle() {
        return this.title;
    }
    
    /**       
     * title setter method
     *
     * @param title the title
     *
     * @return FileBundleFile modified instance
     */
    public FileBundleFile setTitle(String title) {
        this.title = title;
        
        return this;
    }
    /**       
     * description getter method
     *
     * @return description method
     */
    public String getDescription() {
        return this.description;
    }
    
    /**       
     * description setter method
     *
     * @param description the description
     *
     * @return FileBundleFile modified instance
     */
    public FileBundleFile setDescription(String description) {
        this.description = description;
        
        return this;
    }
    /**       
     * isMandatory getter method
     *
     * @return isMandatory method
     */
    public boolean isIsMandatory() {
        return this.isMandatory;
    }
    
    /**       
     * isMandatory setter method
     *
     * @param isMandatory the isMandatory
     *
     * @return FileBundleFile modified instance
     */
    public FileBundleFile setIsMandatory(boolean isMandatory) {
        this.isMandatory = isMandatory;
        
        return this;
    }
    /**       
     * isVersioned getter method
     *
     * @return isVersioned method
     */
    public boolean isIsVersioned() {
        return this.isVersioned;
    }
    
    /**       
     * isVersioned setter method
     *
     * @param isVersioned the isVersioned
     *
     * @return FileBundleFile modified instance
     */
    public FileBundleFile setIsVersioned(boolean isVersioned) {
        this.isVersioned = isVersioned;
        
        return this;
    }
    /**       
     * hasValidation getter method
     *
     * @return hasValidation method
     */
    public boolean isHasValidation() {
        return this.hasValidation;
    }
    
    /**       
     * hasValidation setter method
     *
     * @param hasValidation the hasValidation
     *
     * @return FileBundleFile modified instance
     */
    public FileBundleFile setHasValidation(boolean hasValidation) {
        this.hasValidation = hasValidation;
        
        return this;
    }
    /**       
     * workflowFileAcls getter method
     *
     * @return workflowFileAcls method
     */
    public Set<WorkflowFileAcl> getWorkflowFileAcls() {
        return this.workflowFileAcls;
    }
    
    /**       
     * workflowFileAcls setter method
     *
     * @param workflowFileAcls the workflowFileAcls
     *
     * @return FileBundleFile modified instance
     */
    public FileBundleFile setWorkflowFileAcls(Set<WorkflowFileAcl> workflowFileAcls) {
        this.workflowFileAcls = workflowFileAcls;
        
        return this;
    }
    /**       
     * fileBundleInstanceFiles getter method
     *
     * @return fileBundleInstanceFiles method
     */
    public Set<FileBundleInstanceFile> getFileBundleInstanceFiles() {
        return this.fileBundleInstanceFiles;
    }
    
    /**       
     * fileBundleInstanceFiles setter method
     *
     * @param fileBundleInstanceFiles the fileBundleInstanceFiles
     *
     * @return FileBundleFile modified instance
     */
    public FileBundleFile setFileBundleInstanceFiles(Set<FileBundleInstanceFile> fileBundleInstanceFiles) {
        this.fileBundleInstanceFiles = fileBundleInstanceFiles;
        
        return this;
    }

    /**
     * Creates a String representation of the FileBundleFile object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("title").append("='").append(getTitle()).append("' ");			
        buffer.append("description").append("='").append(getDescription()).append("' ");			
        buffer.append("isMandatory").append("='").append(isIsMandatory()).append("' ");			
        buffer.append("isVersioned").append("='").append(isIsVersioned()).append("' ");			
        buffer.append("hasValidation").append("='").append(isHasValidation()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the FileBundleFile object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(FileBundleFile other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("title".equalsIgnoreCase(attributeName))
        	this.title = attributeValue;

        if ("description".equalsIgnoreCase(attributeName))
        	this.description = attributeValue;

        if ("isMandatory".equalsIgnoreCase(attributeName))
            this.isMandatory = Boolean.valueOf(attributeValue);

        if ("isVersioned".equalsIgnoreCase(attributeName))
            this.isVersioned = Boolean.valueOf(attributeValue);

        if ("hasValidation".equalsIgnoreCase(attributeName))
            this.hasValidation = Boolean.valueOf(attributeValue);

    }


    /**
     * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
     *
     * @param session the session
     * @param id      the id
     *
     * @return the proxy
     */
    public static FileBundleFile getProxy(Session session, Long id)
    {
        return(FileBundleFile)session.load(FileBundleFile.class,id);
    }

    /**
    * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
    *
    * @param id      the id
    *
    * @return the proxy
    */
    public static FileBundleFile getProxy(Long id)
    {
        Session session = HibernateUtil.getSessionFactory("DIFRepository").getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        FileBundleFile result = (FileBundleFile)session.load(FileBundleFile.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }


    /**
     * Instanciates an Hibernate data object
     *
     * @param session the session
     * @param id      the id
     *
     * @return the instance
     */
    public static FileBundleFile getInstance(Session session, Long id)
    {
        return(FileBundleFile)session.get(FileBundleFile.class,id);
    }

    /**
    * Instanciates an Hibernate data object
    *
    * @param id      the id
    *
    * @return the instance
    */
    public static FileBundleFile getInstance(Long id)
    {
        Session session = HibernateUtil.getSessionFactory("DIFRepository").getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        FileBundleFile result = (FileBundleFile)session.get(FileBundleFile.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }

}
