package pt.digitalis.dif.dem.managers.impl.model.data;


import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.model.utils.IBeanAttributesDataSet;

/**
 * FileBundleHistory
* Generated on ORM Generator
* DIF build process for the Model layer
*
*/
@SuppressWarnings("serial")
public class FileBundleHistory extends AbstractBeanRelationsAttributes implements java.io.Serializable, IBeanAttributesDataSet<FileBundleHistory> {

    /** FileBundleHistory attributes enumeration */
    public static class Fields
    {
        /** id column */
        public static final String ID ="id";
        /** documentId column */
        public static final String DOCUMENTID ="documentId";
        /** version column */
        public static final String VERSION ="version";
        /** uploadDate column */
        public static final String UPLOADDATE ="uploadDate";
        /** deprecationDate column */
        public static final String DEPRECATIONDATE ="deprecationDate";
        /** uploadUserId column */
        public static final String UPLOADUSERID ="uploadUserId";

        /**
         * List of existing fields
         *
         * @return list of field names
         */
        public static List<String> values()
        {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("documentId");
            list.add("version");
            list.add("uploadDate");
            list.add("deprecationDate");
            list.add("uploadUserId");

            return list;
        }
    }

    /** Field attributes */
    public static FileBundleHistoryFieldAttributes FieldAttributes=new FileBundleHistoryFieldAttributes();

    /**
    * @return the field attributes definitions
    */
    @Override public FileBundleHistoryFieldAttributes getDefinitions()
    {
        return FieldAttributes;
    }

    /**
     * The Class Relations.
     */
    public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations
    {

        /**
        * Instantiates a new relations.
        *
        * @param currentPath the current path
        */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * fileBundleInstanceFile relation.
         *
         * @return the fileBundleInstanceFile bean relations attributes.
         */
        public FileBundleInstanceFile.Relations fileBundleInstanceFile()
        {
            FileBundleInstanceFile c = new FileBundleInstanceFile();
            return c.new Relations(this.buildPath("fileBundleInstanceFile"));
        }

        /**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
        /**
         * the DOCUMENTID path.
         *
         * @return the path
         */
        public String DOCUMENTID()
        {
            return buildPath(Fields.DOCUMENTID);
        }
        /**
         * the VERSION path.
         *
         * @return the path
         */
        public String VERSION()
        {
            return buildPath(Fields.VERSION);
        }
        /**
         * the UPLOADDATE path.
         *
         * @return the path
         */
        public String UPLOADDATE()
        {
            return buildPath(Fields.UPLOADDATE);
        }
        /**
         * the DEPRECATIONDATE path.
         *
         * @return the path
         */
        public String DEPRECATIONDATE()
        {
            return buildPath(Fields.DEPRECATIONDATE);
        }
        /**
         * the UPLOADUSERID path.
         *
         * @return the path
         */
        public String UPLOADUSERID()
        {
            return buildPath(Fields.UPLOADUSERID);
        }
    }

    /** The dummy obj. */
    private static FileBundleHistory dummyObj=new FileBundleHistory();

    /**
     * Get FileBundleHistory Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public IDataSet<FileBundleHistory> getDataSet()
    {
        return new HibernateDataSet<FileBundleHistory>(FileBundleHistory.class, HibernateUtil.getSessionFactory("DIFRepository"),
            FileBundleHistory.getPKFieldListAsString(), FileBundleHistory.FieldAttributes);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public static IDataSet<FileBundleHistory> getDataSetInstance()
    {
        return new FileBundleHistory().getDataSet();
    }

    /**
    * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
    */
    @Override protected Object getAttributeNoGraphNavigation(String attributeName)
    {
        if("id".equalsIgnoreCase(attributeName))
            return id;
        if("fileBundleInstanceFile".equalsIgnoreCase(attributeName))
            return fileBundleInstanceFile;
        if("documentId".equalsIgnoreCase(attributeName))
            return documentId;
        if("version".equalsIgnoreCase(attributeName))
            return version;
        if("uploadDate".equalsIgnoreCase(attributeName))
            return uploadDate;
        if("deprecationDate".equalsIgnoreCase(attributeName))
            return deprecationDate;
        if("uploadUserId".equalsIgnoreCase(attributeName))
            return uploadUserId;

        return null;
    }

    /**
    * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
    */
    public void setAttribute(String attributeName,Object attributeValue)
    {
        if("id".equalsIgnoreCase(attributeName))
            id =(Long)attributeValue;
        if("fileBundleInstanceFile".equalsIgnoreCase(attributeName))
            fileBundleInstanceFile =(FileBundleInstanceFile)attributeValue;
        if("documentId".equalsIgnoreCase(attributeName))
            documentId =(Long)attributeValue;
        if("version".equalsIgnoreCase(attributeName))
            version =(Long)attributeValue;
        if("uploadDate".equalsIgnoreCase(attributeName))
            uploadDate =(Timestamp)attributeValue;
        if("deprecationDate".equalsIgnoreCase(attributeName))
            deprecationDate =(Timestamp)attributeValue;
        if("uploadUserId".equalsIgnoreCase(attributeName))
            uploadUserId =(String)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** fileBundleInstanceFile private attribute */
    private FileBundleInstanceFile fileBundleInstanceFile;

    /** documentId private attribute */
    private Long documentId;

    /** version private attribute */
    private Long version;

    /** uploadDate private attribute */
    private Timestamp uploadDate;

    /** deprecationDate private attribute */
    private Timestamp deprecationDate;

    /** uploadUserId private attribute */
    private String uploadUserId;

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {

        Object value = getAttribute(attributeName);

        if (value == null)
            return "";
        else {
            return value.toString().trim();
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public FileBundleHistory() {
    }


    /**
     * full constructor
	 *
     * @param fileBundleInstanceFile the fileBundleInstanceFile
     * @param documentId the documentId
     * @param version the version
     * @param uploadDate the uploadDate
     * @param deprecationDate the deprecationDate
     * @param uploadUserId the uploadUserId
     */
    public FileBundleHistory(FileBundleInstanceFile fileBundleInstanceFile, Long documentId, Long version, Timestamp uploadDate, Timestamp deprecationDate, String uploadUserId) {
        this.fileBundleInstanceFile = fileBundleInstanceFile;
        this.documentId = documentId;
        this.version = version;
        this.uploadDate = uploadDate;
        this.deprecationDate = deprecationDate;
        this.uploadUserId = uploadUserId;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id the id
     *
     * @return FileBundleHistory modified instance
     */
    public FileBundleHistory setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * fileBundleInstanceFile getter method
     *
     * @return fileBundleInstanceFile method
     */
    public FileBundleInstanceFile getFileBundleInstanceFile() {
        return this.fileBundleInstanceFile;
    }
    
    /**       
     * fileBundleInstanceFile setter method
     *
     * @param fileBundleInstanceFile the fileBundleInstanceFile
     *
     * @return FileBundleHistory modified instance
     */
    public FileBundleHistory setFileBundleInstanceFile(FileBundleInstanceFile fileBundleInstanceFile) {
        this.fileBundleInstanceFile = fileBundleInstanceFile;
        
        return this;
    }
    /**       
     * documentId getter method
     *
     * @return documentId method
     */
    public Long getDocumentId() {
        return this.documentId;
    }
    
    /**       
     * documentId setter method
     *
     * @param documentId the documentId
     *
     * @return FileBundleHistory modified instance
     */
    public FileBundleHistory setDocumentId(Long documentId) {
        this.documentId = documentId;
        
        return this;
    }
    /**       
     * version getter method
     *
     * @return version method
     */
    public Long getVersion() {
        return this.version;
    }
    
    /**       
     * version setter method
     *
     * @param version the version
     *
     * @return FileBundleHistory modified instance
     */
    public FileBundleHistory setVersion(Long version) {
        this.version = version;
        
        return this;
    }
    /**       
     * uploadDate getter method
     *
     * @return uploadDate method
     */
    public Timestamp getUploadDate() {
        return this.uploadDate;
    }
    
    /**       
     * uploadDate setter method
     *
     * @param uploadDate the uploadDate
     *
     * @return FileBundleHistory modified instance
     */
    public FileBundleHistory setUploadDate(Timestamp uploadDate) {
        this.uploadDate = uploadDate;
        
        return this;
    }
    /**       
     * deprecationDate getter method
     *
     * @return deprecationDate method
     */
    public Timestamp getDeprecationDate() {
        return this.deprecationDate;
    }
    
    /**       
     * deprecationDate setter method
     *
     * @param deprecationDate the deprecationDate
     *
     * @return FileBundleHistory modified instance
     */
    public FileBundleHistory setDeprecationDate(Timestamp deprecationDate) {
        this.deprecationDate = deprecationDate;
        
        return this;
    }
    /**       
     * uploadUserId getter method
     *
     * @return uploadUserId method
     */
    public String getUploadUserId() {
        return this.uploadUserId;
    }
    
    /**       
     * uploadUserId setter method
     *
     * @param uploadUserId the uploadUserId
     *
     * @return FileBundleHistory modified instance
     */
    public FileBundleHistory setUploadUserId(String uploadUserId) {
        this.uploadUserId = uploadUserId;
        
        return this;
    }

    /**
     * Creates a String representation of the FileBundleHistory object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("documentId").append("='").append(getDocumentId()).append("' ");			
        buffer.append("version").append("='").append(getVersion()).append("' ");			
        buffer.append("uploadDate").append("='").append(getUploadDate()).append("' ");			
        buffer.append("deprecationDate").append("='").append(getDeprecationDate()).append("' ");			
        buffer.append("uploadUserId").append("='").append(getUploadUserId()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the FileBundleHistory object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(FileBundleHistory other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("documentId".equalsIgnoreCase(attributeName))
            this.documentId = Long.valueOf(attributeValue);

        if ("version".equalsIgnoreCase(attributeName))
            this.version = Long.valueOf(attributeValue);

        if ("uploadDate".equalsIgnoreCase(attributeName))
            this.uploadDate = Timestamp.valueOf(attributeValue);

        if ("deprecationDate".equalsIgnoreCase(attributeName))
            this.deprecationDate = Timestamp.valueOf(attributeValue);

        if ("uploadUserId".equalsIgnoreCase(attributeName))
        	this.uploadUserId = attributeValue;

    }


    /**
     * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
     *
     * @param session the session
     * @param id      the id
     *
     * @return the proxy
     */
    public static FileBundleHistory getProxy(Session session, Long id)
    {
        return(FileBundleHistory)session.load(FileBundleHistory.class,id);
    }

    /**
    * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
    *
    * @param id      the id
    *
    * @return the proxy
    */
    public static FileBundleHistory getProxy(Long id)
    {
        Session session = HibernateUtil.getSessionFactory("DIFRepository").getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        FileBundleHistory result = (FileBundleHistory)session.load(FileBundleHistory.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }


    /**
     * Instanciates an Hibernate data object
     *
     * @param session the session
     * @param id      the id
     *
     * @return the instance
     */
    public static FileBundleHistory getInstance(Session session, Long id)
    {
        return(FileBundleHistory)session.get(FileBundleHistory.class,id);
    }

    /**
    * Instanciates an Hibernate data object
    *
    * @param id      the id
    *
    * @return the instance
    */
    public static FileBundleHistory getInstance(Long id)
    {
        Session session = HibernateUtil.getSessionFactory("DIFRepository").getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        FileBundleHistory result = (FileBundleHistory)session.get(FileBundleHistory.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }

}
