package pt.digitalis.dif.dem.managers.impl.model.data;


import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.Session;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.model.utils.IBeanAttributesDataSet;

/**
 * FileBundleInstance
* Generated on ORM Generator
* DIF build process for the Model layer
*
*/
@SuppressWarnings("serial")
public class FileBundleInstance extends AbstractBeanRelationsAttributes implements java.io.Serializable, IBeanAttributesDataSet<FileBundleInstance> {

    /** FileBundleInstance attributes enumeration */
    public static class Fields
    {
        /** id column */
        public static final String ID ="id";
        /** businessProcessInstanceId column */
        public static final String BUSINESSPROCESSINSTANCEID ="businessProcessInstanceId";
        /** creationDate column */
        public static final String CREATIONDATE ="creationDate";
        /** isOpen column */
        public static final String ISOPEN ="isOpen";
        /** closeDate column */
        public static final String CLOSEDATE ="closeDate";

        /**
         * List of existing fields
         *
         * @return list of field names
         */
        public static List<String> values()
        {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("businessProcessInstanceId");
            list.add("creationDate");
            list.add("isOpen");
            list.add("closeDate");

            return list;
        }
    }

    /** Field attributes */
    public static FileBundleInstanceFieldAttributes FieldAttributes=new FileBundleInstanceFieldAttributes();

    /**
    * @return the field attributes definitions
    */
    @Override public FileBundleInstanceFieldAttributes getDefinitions()
    {
        return FieldAttributes;
    }

    /**
     * The Class Relations.
     */
    public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations
    {

        /**
        * Instantiates a new relations.
        *
        * @param currentPath the current path
        */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * fileBundle relation.
         *
         * @return the fileBundle bean relations attributes.
         */
        public FileBundle.Relations fileBundle()
        {
            FileBundle c = new FileBundle();
            return c.new Relations(this.buildPath("fileBundle"));
        }

        /**
         * fileBundleInstanceFiles relation.
         *
         * @return the fileBundleInstanceFiles bean relations attributes.
         */
        public FileBundleInstanceFile.Relations fileBundleInstanceFiles()
        {
            FileBundleInstanceFile c = new FileBundleInstanceFile();
            return c.new Relations(this.buildPath("fileBundleInstanceFiles"));
        }

        /**
         * workflowInstances relation.
         *
         * @return the workflowInstances bean relations attributes.
         */
        public WorkflowInstance.Relations workflowInstances()
        {
            WorkflowInstance c = new WorkflowInstance();
            return c.new Relations(this.buildPath("workflowInstances"));
        }

        /**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
        /**
         * the BUSINESSPROCESSINSTANCEID path.
         *
         * @return the path
         */
        public String BUSINESSPROCESSINSTANCEID()
        {
            return buildPath(Fields.BUSINESSPROCESSINSTANCEID);
        }
        /**
         * the CREATIONDATE path.
         *
         * @return the path
         */
        public String CREATIONDATE()
        {
            return buildPath(Fields.CREATIONDATE);
        }
        /**
         * the ISOPEN path.
         *
         * @return the path
         */
        public String ISOPEN()
        {
            return buildPath(Fields.ISOPEN);
        }
        /**
         * the CLOSEDATE path.
         *
         * @return the path
         */
        public String CLOSEDATE()
        {
            return buildPath(Fields.CLOSEDATE);
        }
    }

    /** The dummy obj. */
    private static FileBundleInstance dummyObj=new FileBundleInstance();

    /**
     * Get FileBundleInstance Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public IDataSet<FileBundleInstance> getDataSet()
    {
        return new HibernateDataSet<FileBundleInstance>(FileBundleInstance.class, HibernateUtil.getSessionFactory("DIFRepository"),
            FileBundleInstance.getPKFieldListAsString(), FileBundleInstance.FieldAttributes);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public static IDataSet<FileBundleInstance> getDataSetInstance()
    {
        return new FileBundleInstance().getDataSet();
    }

    /**
    * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
    */
    @Override protected Object getAttributeNoGraphNavigation(String attributeName)
    {
        if("id".equalsIgnoreCase(attributeName))
            return id;
        if("fileBundle".equalsIgnoreCase(attributeName))
            return fileBundle;
        if("businessProcessInstanceId".equalsIgnoreCase(attributeName))
            return businessProcessInstanceId;
        if("creationDate".equalsIgnoreCase(attributeName))
            return creationDate;
        if("isOpen".equalsIgnoreCase(attributeName))
            return isOpen;
        if("closeDate".equalsIgnoreCase(attributeName))
            return closeDate;
        if("fileBundleInstanceFiles".equalsIgnoreCase(attributeName))
            return fileBundleInstanceFiles;
        if("workflowInstances".equalsIgnoreCase(attributeName))
            return workflowInstances;

        return null;
    }

    /**
    * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
    */
    public void setAttribute(String attributeName,Object attributeValue)
    {
        if("id".equalsIgnoreCase(attributeName))
            id =(Long)attributeValue;
        if("fileBundle".equalsIgnoreCase(attributeName))
            fileBundle =(FileBundle)attributeValue;
        if("businessProcessInstanceId".equalsIgnoreCase(attributeName))
            businessProcessInstanceId =(String)attributeValue;
        if("creationDate".equalsIgnoreCase(attributeName))
            creationDate =(Timestamp)attributeValue;
        if("isOpen".equalsIgnoreCase(attributeName))
            isOpen =(Boolean)attributeValue;
        if("closeDate".equalsIgnoreCase(attributeName))
            closeDate =(Timestamp)attributeValue;
        if("fileBundleInstanceFiles".equalsIgnoreCase(attributeName))
            fileBundleInstanceFiles =(Set<FileBundleInstanceFile>)attributeValue;
        if("workflowInstances".equalsIgnoreCase(attributeName))
            workflowInstances =(Set<WorkflowInstance>)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** fileBundle private attribute */
    private FileBundle fileBundle;

    /** businessProcessInstanceId private attribute */
    private String businessProcessInstanceId;

    /** creationDate private attribute */
    private Timestamp creationDate;

    /** isOpen private attribute */
    private boolean isOpen;

    /** closeDate private attribute */
    private Timestamp closeDate;

    /** fileBundleInstanceFiles private attribute */
    private Set<FileBundleInstanceFile> fileBundleInstanceFiles = new HashSet<FileBundleInstanceFile>(0);

    /** workflowInstances private attribute */
    private Set<WorkflowInstance> workflowInstances = new HashSet<WorkflowInstance>(0);

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {

        Object value = getAttribute(attributeName);

        if (value == null)
            return "";
        else {
            return value.toString().trim();
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public FileBundleInstance() {
    }

	/** 
	 * minimal constructor
	 *
     * @param fileBundle the fileBundle
     * @param creationDate the creationDate
     * @param isOpen the isOpen
    }
	 */
    public FileBundleInstance(FileBundle fileBundle, Timestamp creationDate, boolean isOpen) {
        this.fileBundle = fileBundle;
        this.creationDate = creationDate;
        this.isOpen = isOpen;
    }

    /**
     * full constructor
	 *
     * @param fileBundle the fileBundle
     * @param businessProcessInstanceId the businessProcessInstanceId
     * @param creationDate the creationDate
     * @param isOpen the isOpen
     * @param closeDate the closeDate
     * @param fileBundleInstanceFiles the fileBundleInstanceFiles
     * @param workflowInstances the workflowInstances
     */
    public FileBundleInstance(FileBundle fileBundle, String businessProcessInstanceId, Timestamp creationDate, boolean isOpen, Timestamp closeDate, Set<FileBundleInstanceFile> fileBundleInstanceFiles, Set<WorkflowInstance> workflowInstances) {
        this.fileBundle = fileBundle;
        this.businessProcessInstanceId = businessProcessInstanceId;
        this.creationDate = creationDate;
        this.isOpen = isOpen;
        this.closeDate = closeDate;
        this.fileBundleInstanceFiles = fileBundleInstanceFiles;
        this.workflowInstances = workflowInstances;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id the id
     *
     * @return FileBundleInstance modified instance
     */
    public FileBundleInstance setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * fileBundle getter method
     *
     * @return fileBundle method
     */
    public FileBundle getFileBundle() {
        return this.fileBundle;
    }
    
    /**       
     * fileBundle setter method
     *
     * @param fileBundle the fileBundle
     *
     * @return FileBundleInstance modified instance
     */
    public FileBundleInstance setFileBundle(FileBundle fileBundle) {
        this.fileBundle = fileBundle;
        
        return this;
    }
    /**       
     * businessProcessInstanceId getter method
     *
     * @return businessProcessInstanceId method
     */
    public String getBusinessProcessInstanceId() {
        return this.businessProcessInstanceId;
    }
    
    /**       
     * businessProcessInstanceId setter method
     *
     * @param businessProcessInstanceId the businessProcessInstanceId
     *
     * @return FileBundleInstance modified instance
     */
    public FileBundleInstance setBusinessProcessInstanceId(String businessProcessInstanceId) {
        this.businessProcessInstanceId = businessProcessInstanceId;
        
        return this;
    }
    /**       
     * creationDate getter method
     *
     * @return creationDate method
     */
    public Timestamp getCreationDate() {
        return this.creationDate;
    }
    
    /**       
     * creationDate setter method
     *
     * @param creationDate the creationDate
     *
     * @return FileBundleInstance modified instance
     */
    public FileBundleInstance setCreationDate(Timestamp creationDate) {
        this.creationDate = creationDate;
        
        return this;
    }
    /**       
     * isOpen getter method
     *
     * @return isOpen method
     */
    public boolean isIsOpen() {
        return this.isOpen;
    }
    
    /**       
     * isOpen setter method
     *
     * @param isOpen the isOpen
     *
     * @return FileBundleInstance modified instance
     */
    public FileBundleInstance setIsOpen(boolean isOpen) {
        this.isOpen = isOpen;
        
        return this;
    }
    /**       
     * closeDate getter method
     *
     * @return closeDate method
     */
    public Timestamp getCloseDate() {
        return this.closeDate;
    }
    
    /**       
     * closeDate setter method
     *
     * @param closeDate the closeDate
     *
     * @return FileBundleInstance modified instance
     */
    public FileBundleInstance setCloseDate(Timestamp closeDate) {
        this.closeDate = closeDate;
        
        return this;
    }
    /**       
     * fileBundleInstanceFiles getter method
     *
     * @return fileBundleInstanceFiles method
     */
    public Set<FileBundleInstanceFile> getFileBundleInstanceFiles() {
        return this.fileBundleInstanceFiles;
    }
    
    /**       
     * fileBundleInstanceFiles setter method
     *
     * @param fileBundleInstanceFiles the fileBundleInstanceFiles
     *
     * @return FileBundleInstance modified instance
     */
    public FileBundleInstance setFileBundleInstanceFiles(Set<FileBundleInstanceFile> fileBundleInstanceFiles) {
        this.fileBundleInstanceFiles = fileBundleInstanceFiles;
        
        return this;
    }
    /**       
     * workflowInstances getter method
     *
     * @return workflowInstances method
     */
    public Set<WorkflowInstance> getWorkflowInstances() {
        return this.workflowInstances;
    }
    
    /**       
     * workflowInstances setter method
     *
     * @param workflowInstances the workflowInstances
     *
     * @return FileBundleInstance modified instance
     */
    public FileBundleInstance setWorkflowInstances(Set<WorkflowInstance> workflowInstances) {
        this.workflowInstances = workflowInstances;
        
        return this;
    }

    /**
     * Creates a String representation of the FileBundleInstance object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("businessProcessInstanceId").append("='").append(getBusinessProcessInstanceId()).append("' ");			
        buffer.append("creationDate").append("='").append(getCreationDate()).append("' ");			
        buffer.append("isOpen").append("='").append(isIsOpen()).append("' ");			
        buffer.append("closeDate").append("='").append(getCloseDate()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the FileBundleInstance object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(FileBundleInstance other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("businessProcessInstanceId".equalsIgnoreCase(attributeName))
        	this.businessProcessInstanceId = attributeValue;

        if ("creationDate".equalsIgnoreCase(attributeName))
            this.creationDate = Timestamp.valueOf(attributeValue);

        if ("isOpen".equalsIgnoreCase(attributeName))
            this.isOpen = Boolean.valueOf(attributeValue);

        if ("closeDate".equalsIgnoreCase(attributeName))
            this.closeDate = Timestamp.valueOf(attributeValue);

    }


    /**
     * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
     *
     * @param session the session
     * @param id      the id
     *
     * @return the proxy
     */
    public static FileBundleInstance getProxy(Session session, Long id)
    {
        return(FileBundleInstance)session.load(FileBundleInstance.class,id);
    }

    /**
    * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
    *
    * @param id      the id
    *
    * @return the proxy
    */
    public static FileBundleInstance getProxy(Long id)
    {
        Session session = HibernateUtil.getSessionFactory("DIFRepository").getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        FileBundleInstance result = (FileBundleInstance)session.load(FileBundleInstance.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }


    /**
     * Instanciates an Hibernate data object
     *
     * @param session the session
     * @param id      the id
     *
     * @return the instance
     */
    public static FileBundleInstance getInstance(Session session, Long id)
    {
        return(FileBundleInstance)session.get(FileBundleInstance.class,id);
    }

    /**
    * Instanciates an Hibernate data object
    *
    * @param id      the id
    *
    * @return the instance
    */
    public static FileBundleInstance getInstance(Long id)
    {
        Session session = HibernateUtil.getSessionFactory("DIFRepository").getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        FileBundleInstance result = (FileBundleInstance)session.get(FileBundleInstance.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }

}
