package pt.digitalis.dif.dem.managers.impl.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link FileBundleInstance}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class FileBundleInstanceFieldAttributes extends AbstractBeanAttributesDefinition{

    /** businessProcessInstanceId (Database column: BUSINESS_PROCESS_INSTANCE_ID) */
    static public AttributeDefinition businessProcessInstanceId =
        new AttributeDefinition("businessProcessInstanceId")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("FILE_BUNDLE_INSTANCE")
                .setDatabaseId("BUSINESS_PROCESS_INSTANCE_ID")
                .setMandatory(true)
                .setMaxSize(200)
                .setType(String.class);

    /** closeDate (Database column: CLOSE_DATE) */
    static public AttributeDefinition closeDate =
        new AttributeDefinition("closeDate")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("FILE_BUNDLE_INSTANCE")
                .setDatabaseId("CLOSE_DATE")
                .setMandatory(true)
                .setMaxSize(7)
                .setType(Timestamp.class);

    /** creationDate (Database column: CREATION_DATE) */
    static public AttributeDefinition creationDate =
        new AttributeDefinition("creationDate")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("FILE_BUNDLE_INSTANCE")
                .setDatabaseId("CREATION_DATE")
                .setMandatory(true)
                .setMaxSize(7)
                .setType(Timestamp.class);

    /** fileBundle (Database column: FILE_BUNDLE_ID) */
    static public AttributeDefinition fileBundle =
        new AttributeDefinition("fileBundle")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("FILE_BUNDLE_INSTANCE")
                .setDatabaseId("FILE_BUNDLE_ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setLovDataClass(pt.digitalis.dif.dem.managers.impl.model.data.FileBundle.class)
                .setLovDataClassKey("id")
                .setLovDataClassDescription("name")
                .setType(pt.digitalis.dif.dem.managers.impl.model.data.FileBundle.class);

    /** id (Database column: ID) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("FILE_BUNDLE_INSTANCE")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(Long.class);

    /** isOpen (Database column: IS_OPEN) */
    static public AttributeDefinition isOpen =
        new AttributeDefinition("isOpen")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("FILE_BUNDLE_INSTANCE")
                .setDatabaseId("IS_OPEN")
                .setMandatory(true)
                .setMaxSize(255)
                .setDefaultValue("1")
                .setType(boolean.class);

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(businessProcessInstanceId.getName(),businessProcessInstanceId);
        map.put(closeDate.getName(),closeDate);
        map.put(creationDate.getName(),creationDate);
        map.put(fileBundle.getName(),fileBundle);
        map.put(id.getName(),id);
        map.put(isOpen.getName(),isOpen);

        return map;
    }
}