package pt.digitalis.dif.dem.managers.impl.model.data;


import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.Session;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.model.utils.IBeanAttributesDataSet;

/**
 * FileBundleInstanceFile
* Generated on ORM Generator
* DIF build process for the Model layer
*
*/
@SuppressWarnings("serial")
public class FileBundleInstanceFile extends AbstractBeanRelationsAttributes implements java.io.Serializable, IBeanAttributesDataSet<FileBundleInstanceFile> {

    /** FileBundleInstanceFile attributes enumeration */
    public static class Fields
    {
        /** id column */
        public static final String ID ="id";
        /** documentId column */
        public static final String DOCUMENTID ="documentId";
        /** isPrivate column */
        public static final String ISPRIVATE ="isPrivate";
        /** isValid column */
        public static final String ISVALID ="isValid";
        /** uploadUserId column */
        public static final String UPLOADUSERID ="uploadUserId";
        /** uploadDate column */
        public static final String UPLOADDATE ="uploadDate";
        /** uploadUserBusinessId column */
        public static final String UPLOADUSERBUSINESSID ="uploadUserBusinessId";
        /** validateUserId column */
        public static final String VALIDATEUSERID ="validateUserId";
        /** validateDate column */
        public static final String VALIDATEDATE ="validateDate";
        /** validateUserBusinessId column */
        public static final String VALIDATEUSERBUSINESSID ="validateUserBusinessId";
        /** version column */
        public static final String VERSION ="version";
        /** isInvalid column */
        public static final String ISINVALID ="isInvalid";

        /**
         * List of existing fields
         *
         * @return list of field names
         */
        public static List<String> values()
        {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("documentId");
            list.add("isPrivate");
            list.add("isValid");
            list.add("uploadUserId");
            list.add("uploadDate");
            list.add("uploadUserBusinessId");
            list.add("validateUserId");
            list.add("validateDate");
            list.add("validateUserBusinessId");
            list.add("version");
            list.add("isInvalid");

            return list;
        }
    }

    /** Field attributes */
    public static FileBundleInstanceFileFieldAttributes FieldAttributes=new FileBundleInstanceFileFieldAttributes();

    /**
    * @return the field attributes definitions
    */
    @Override public FileBundleInstanceFileFieldAttributes getDefinitions()
    {
        return FieldAttributes;
    }

    /**
     * The Class Relations.
     */
    public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations
    {

        /**
        * Instantiates a new relations.
        *
        * @param currentPath the current path
        */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * fileBundleInstance relation.
         *
         * @return the fileBundleInstance bean relations attributes.
         */
        public FileBundleInstance.Relations fileBundleInstance()
        {
            FileBundleInstance c = new FileBundleInstance();
            return c.new Relations(this.buildPath("fileBundleInstance"));
        }

        /**
         * fileBundleFile relation.
         *
         * @return the fileBundleFile bean relations attributes.
         */
        public FileBundleFile.Relations fileBundleFile()
        {
            FileBundleFile c = new FileBundleFile();
            return c.new Relations(this.buildPath("fileBundleFile"));
        }

        /**
         * fileBundleHistories relation.
         *
         * @return the fileBundleHistories bean relations attributes.
         */
        public FileBundleHistory.Relations fileBundleHistories()
        {
            FileBundleHistory c = new FileBundleHistory();
            return c.new Relations(this.buildPath("fileBundleHistories"));
        }

        /**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
        /**
         * the DOCUMENTID path.
         *
         * @return the path
         */
        public String DOCUMENTID()
        {
            return buildPath(Fields.DOCUMENTID);
        }
        /**
         * the ISPRIVATE path.
         *
         * @return the path
         */
        public String ISPRIVATE()
        {
            return buildPath(Fields.ISPRIVATE);
        }
        /**
         * the ISVALID path.
         *
         * @return the path
         */
        public String ISVALID()
        {
            return buildPath(Fields.ISVALID);
        }
        /**
         * the UPLOADUSERID path.
         *
         * @return the path
         */
        public String UPLOADUSERID()
        {
            return buildPath(Fields.UPLOADUSERID);
        }
        /**
         * the UPLOADDATE path.
         *
         * @return the path
         */
        public String UPLOADDATE()
        {
            return buildPath(Fields.UPLOADDATE);
        }
        /**
         * the UPLOADUSERBUSINESSID path.
         *
         * @return the path
         */
        public String UPLOADUSERBUSINESSID()
        {
            return buildPath(Fields.UPLOADUSERBUSINESSID);
        }
        /**
         * the VALIDATEUSERID path.
         *
         * @return the path
         */
        public String VALIDATEUSERID()
        {
            return buildPath(Fields.VALIDATEUSERID);
        }
        /**
         * the VALIDATEDATE path.
         *
         * @return the path
         */
        public String VALIDATEDATE()
        {
            return buildPath(Fields.VALIDATEDATE);
        }
        /**
         * the VALIDATEUSERBUSINESSID path.
         *
         * @return the path
         */
        public String VALIDATEUSERBUSINESSID()
        {
            return buildPath(Fields.VALIDATEUSERBUSINESSID);
        }
        /**
         * the VERSION path.
         *
         * @return the path
         */
        public String VERSION()
        {
            return buildPath(Fields.VERSION);
        }
        /**
         * the ISINVALID path.
         *
         * @return the path
         */
        public String ISINVALID()
        {
            return buildPath(Fields.ISINVALID);
        }
    }

    /** The dummy obj. */
    private static FileBundleInstanceFile dummyObj=new FileBundleInstanceFile();

    /**
     * Get FileBundleInstanceFile Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public IDataSet<FileBundleInstanceFile> getDataSet()
    {
        return new HibernateDataSet<FileBundleInstanceFile>(FileBundleInstanceFile.class, HibernateUtil.getSessionFactory("DIFRepository"),
            FileBundleInstanceFile.getPKFieldListAsString(), FileBundleInstanceFile.FieldAttributes);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public static IDataSet<FileBundleInstanceFile> getDataSetInstance()
    {
        return new FileBundleInstanceFile().getDataSet();
    }

    /**
    * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
    */
    @Override protected Object getAttributeNoGraphNavigation(String attributeName)
    {
        if("id".equalsIgnoreCase(attributeName))
            return id;
        if("fileBundleInstance".equalsIgnoreCase(attributeName))
            return fileBundleInstance;
        if("fileBundleFile".equalsIgnoreCase(attributeName))
            return fileBundleFile;
        if("documentId".equalsIgnoreCase(attributeName))
            return documentId;
        if("isPrivate".equalsIgnoreCase(attributeName))
            return isPrivate;
        if("isValid".equalsIgnoreCase(attributeName))
            return isValid;
        if("uploadUserId".equalsIgnoreCase(attributeName))
            return uploadUserId;
        if("uploadDate".equalsIgnoreCase(attributeName))
            return uploadDate;
        if("uploadUserBusinessId".equalsIgnoreCase(attributeName))
            return uploadUserBusinessId;
        if("validateUserId".equalsIgnoreCase(attributeName))
            return validateUserId;
        if("validateDate".equalsIgnoreCase(attributeName))
            return validateDate;
        if("validateUserBusinessId".equalsIgnoreCase(attributeName))
            return validateUserBusinessId;
        if("version".equalsIgnoreCase(attributeName))
            return version;
        if("isInvalid".equalsIgnoreCase(attributeName))
            return isInvalid;
        if("fileBundleHistories".equalsIgnoreCase(attributeName))
            return fileBundleHistories;

        return null;
    }

    /**
    * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
    */
    public void setAttribute(String attributeName,Object attributeValue)
    {
        if("id".equalsIgnoreCase(attributeName))
            id =(Long)attributeValue;
        if("fileBundleInstance".equalsIgnoreCase(attributeName))
            fileBundleInstance =(FileBundleInstance)attributeValue;
        if("fileBundleFile".equalsIgnoreCase(attributeName))
            fileBundleFile =(FileBundleFile)attributeValue;
        if("documentId".equalsIgnoreCase(attributeName))
            documentId =(Long)attributeValue;
        if("isPrivate".equalsIgnoreCase(attributeName))
            isPrivate =(Boolean)attributeValue;
        if("isValid".equalsIgnoreCase(attributeName))
            isValid =(Boolean)attributeValue;
        if("uploadUserId".equalsIgnoreCase(attributeName))
            uploadUserId =(String)attributeValue;
        if("uploadDate".equalsIgnoreCase(attributeName))
            uploadDate =(Timestamp)attributeValue;
        if("uploadUserBusinessId".equalsIgnoreCase(attributeName))
            uploadUserBusinessId =(String)attributeValue;
        if("validateUserId".equalsIgnoreCase(attributeName))
            validateUserId =(String)attributeValue;
        if("validateDate".equalsIgnoreCase(attributeName))
            validateDate =(Timestamp)attributeValue;
        if("validateUserBusinessId".equalsIgnoreCase(attributeName))
            validateUserBusinessId =(String)attributeValue;
        if("version".equalsIgnoreCase(attributeName))
            version =(Long)attributeValue;
        if("isInvalid".equalsIgnoreCase(attributeName))
            isInvalid =(Boolean)attributeValue;
        if("fileBundleHistories".equalsIgnoreCase(attributeName))
            fileBundleHistories =(Set<FileBundleHistory>)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** fileBundleInstance private attribute */
    private FileBundleInstance fileBundleInstance;

    /** fileBundleFile private attribute */
    private FileBundleFile fileBundleFile;

    /** documentId private attribute */
    private Long documentId;

    /** isPrivate private attribute */
    private boolean isPrivate;

    /** isValid private attribute */
    private boolean isValid;

    /** uploadUserId private attribute */
    private String uploadUserId;

    /** uploadDate private attribute */
    private Timestamp uploadDate;

    /** uploadUserBusinessId private attribute */
    private String uploadUserBusinessId;

    /** validateUserId private attribute */
    private String validateUserId;

    /** validateDate private attribute */
    private Timestamp validateDate;

    /** validateUserBusinessId private attribute */
    private String validateUserBusinessId;

    /** version private attribute */
    private Long version;

    /** isInvalid private attribute */
    private boolean isInvalid;

    /** fileBundleHistories private attribute */
    private Set<FileBundleHistory> fileBundleHistories = new HashSet<FileBundleHistory>(0);

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {

        Object value = getAttribute(attributeName);

        if (value == null)
            return "";
        else {
            return value.toString().trim();
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public FileBundleInstanceFile() {
    }

	/** 
	 * minimal constructor
	 *
     * @param fileBundleInstance the fileBundleInstance
     * @param fileBundleFile the fileBundleFile
     * @param isPrivate the isPrivate
     * @param isValid the isValid
     * @param isInvalid the isInvalid
    }
	 */
    public FileBundleInstanceFile(FileBundleInstance fileBundleInstance, FileBundleFile fileBundleFile, boolean isPrivate, boolean isValid, boolean isInvalid) {
        this.fileBundleInstance = fileBundleInstance;
        this.fileBundleFile = fileBundleFile;
        this.isPrivate = isPrivate;
        this.isValid = isValid;
        this.isInvalid = isInvalid;
    }

    /**
     * full constructor
	 *
     * @param fileBundleInstance the fileBundleInstance
     * @param fileBundleFile the fileBundleFile
     * @param documentId the documentId
     * @param isPrivate the isPrivate
     * @param isValid the isValid
     * @param uploadUserId the uploadUserId
     * @param uploadDate the uploadDate
     * @param uploadUserBusinessId the uploadUserBusinessId
     * @param validateUserId the validateUserId
     * @param validateDate the validateDate
     * @param validateUserBusinessId the validateUserBusinessId
     * @param version the version
     * @param isInvalid the isInvalid
     * @param fileBundleHistories the fileBundleHistories
     */
    public FileBundleInstanceFile(FileBundleInstance fileBundleInstance, FileBundleFile fileBundleFile, Long documentId, boolean isPrivate, boolean isValid, String uploadUserId, Timestamp uploadDate, String uploadUserBusinessId, String validateUserId, Timestamp validateDate, String validateUserBusinessId, Long version, boolean isInvalid, Set<FileBundleHistory> fileBundleHistories) {
        this.fileBundleInstance = fileBundleInstance;
        this.fileBundleFile = fileBundleFile;
        this.documentId = documentId;
        this.isPrivate = isPrivate;
        this.isValid = isValid;
        this.uploadUserId = uploadUserId;
        this.uploadDate = uploadDate;
        this.uploadUserBusinessId = uploadUserBusinessId;
        this.validateUserId = validateUserId;
        this.validateDate = validateDate;
        this.validateUserBusinessId = validateUserBusinessId;
        this.version = version;
        this.isInvalid = isInvalid;
        this.fileBundleHistories = fileBundleHistories;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id the id
     *
     * @return FileBundleInstanceFile modified instance
     */
    public FileBundleInstanceFile setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * fileBundleInstance getter method
     *
     * @return fileBundleInstance method
     */
    public FileBundleInstance getFileBundleInstance() {
        return this.fileBundleInstance;
    }
    
    /**       
     * fileBundleInstance setter method
     *
     * @param fileBundleInstance the fileBundleInstance
     *
     * @return FileBundleInstanceFile modified instance
     */
    public FileBundleInstanceFile setFileBundleInstance(FileBundleInstance fileBundleInstance) {
        this.fileBundleInstance = fileBundleInstance;
        
        return this;
    }
    /**       
     * fileBundleFile getter method
     *
     * @return fileBundleFile method
     */
    public FileBundleFile getFileBundleFile() {
        return this.fileBundleFile;
    }
    
    /**       
     * fileBundleFile setter method
     *
     * @param fileBundleFile the fileBundleFile
     *
     * @return FileBundleInstanceFile modified instance
     */
    public FileBundleInstanceFile setFileBundleFile(FileBundleFile fileBundleFile) {
        this.fileBundleFile = fileBundleFile;
        
        return this;
    }
    /**       
     * documentId getter method
     *
     * @return documentId method
     */
    public Long getDocumentId() {
        return this.documentId;
    }
    
    /**       
     * documentId setter method
     *
     * @param documentId the documentId
     *
     * @return FileBundleInstanceFile modified instance
     */
    public FileBundleInstanceFile setDocumentId(Long documentId) {
        this.documentId = documentId;
        
        return this;
    }
    /**       
     * isPrivate getter method
     *
     * @return isPrivate method
     */
    public boolean isIsPrivate() {
        return this.isPrivate;
    }
    
    /**       
     * isPrivate setter method
     *
     * @param isPrivate the isPrivate
     *
     * @return FileBundleInstanceFile modified instance
     */
    public FileBundleInstanceFile setIsPrivate(boolean isPrivate) {
        this.isPrivate = isPrivate;
        
        return this;
    }
    /**       
     * isValid getter method
     *
     * @return isValid method
     */
    public boolean isIsValid() {
        return this.isValid;
    }
    
    /**       
     * isValid setter method
     *
     * @param isValid the isValid
     *
     * @return FileBundleInstanceFile modified instance
     */
    public FileBundleInstanceFile setIsValid(boolean isValid) {
        this.isValid = isValid;
        
        return this;
    }
    /**       
     * uploadUserId getter method
     *
     * @return uploadUserId method
     */
    public String getUploadUserId() {
        return this.uploadUserId;
    }
    
    /**       
     * uploadUserId setter method
     *
     * @param uploadUserId the uploadUserId
     *
     * @return FileBundleInstanceFile modified instance
     */
    public FileBundleInstanceFile setUploadUserId(String uploadUserId) {
        this.uploadUserId = uploadUserId;
        
        return this;
    }
    /**       
     * uploadDate getter method
     *
     * @return uploadDate method
     */
    public Timestamp getUploadDate() {
        return this.uploadDate;
    }
    
    /**       
     * uploadDate setter method
     *
     * @param uploadDate the uploadDate
     *
     * @return FileBundleInstanceFile modified instance
     */
    public FileBundleInstanceFile setUploadDate(Timestamp uploadDate) {
        this.uploadDate = uploadDate;
        
        return this;
    }
    /**       
     * uploadUserBusinessId getter method
     *
     * @return uploadUserBusinessId method
     */
    public String getUploadUserBusinessId() {
        return this.uploadUserBusinessId;
    }
    
    /**       
     * uploadUserBusinessId setter method
     *
     * @param uploadUserBusinessId the uploadUserBusinessId
     *
     * @return FileBundleInstanceFile modified instance
     */
    public FileBundleInstanceFile setUploadUserBusinessId(String uploadUserBusinessId) {
        this.uploadUserBusinessId = uploadUserBusinessId;
        
        return this;
    }
    /**       
     * validateUserId getter method
     *
     * @return validateUserId method
     */
    public String getValidateUserId() {
        return this.validateUserId;
    }
    
    /**       
     * validateUserId setter method
     *
     * @param validateUserId the validateUserId
     *
     * @return FileBundleInstanceFile modified instance
     */
    public FileBundleInstanceFile setValidateUserId(String validateUserId) {
        this.validateUserId = validateUserId;
        
        return this;
    }
    /**       
     * validateDate getter method
     *
     * @return validateDate method
     */
    public Timestamp getValidateDate() {
        return this.validateDate;
    }
    
    /**       
     * validateDate setter method
     *
     * @param validateDate the validateDate
     *
     * @return FileBundleInstanceFile modified instance
     */
    public FileBundleInstanceFile setValidateDate(Timestamp validateDate) {
        this.validateDate = validateDate;
        
        return this;
    }
    /**       
     * validateUserBusinessId getter method
     *
     * @return validateUserBusinessId method
     */
    public String getValidateUserBusinessId() {
        return this.validateUserBusinessId;
    }
    
    /**       
     * validateUserBusinessId setter method
     *
     * @param validateUserBusinessId the validateUserBusinessId
     *
     * @return FileBundleInstanceFile modified instance
     */
    public FileBundleInstanceFile setValidateUserBusinessId(String validateUserBusinessId) {
        this.validateUserBusinessId = validateUserBusinessId;
        
        return this;
    }
    /**       
     * version getter method
     *
     * @return version method
     */
    public Long getVersion() {
        return this.version;
    }
    
    /**       
     * version setter method
     *
     * @param version the version
     *
     * @return FileBundleInstanceFile modified instance
     */
    public FileBundleInstanceFile setVersion(Long version) {
        this.version = version;
        
        return this;
    }
    /**       
     * isInvalid getter method
     *
     * @return isInvalid method
     */
    public boolean isIsInvalid() {
        return this.isInvalid;
    }
    
    /**       
     * isInvalid setter method
     *
     * @param isInvalid the isInvalid
     *
     * @return FileBundleInstanceFile modified instance
     */
    public FileBundleInstanceFile setIsInvalid(boolean isInvalid) {
        this.isInvalid = isInvalid;
        
        return this;
    }
    /**       
     * fileBundleHistories getter method
     *
     * @return fileBundleHistories method
     */
    public Set<FileBundleHistory> getFileBundleHistories() {
        return this.fileBundleHistories;
    }
    
    /**       
     * fileBundleHistories setter method
     *
     * @param fileBundleHistories the fileBundleHistories
     *
     * @return FileBundleInstanceFile modified instance
     */
    public FileBundleInstanceFile setFileBundleHistories(Set<FileBundleHistory> fileBundleHistories) {
        this.fileBundleHistories = fileBundleHistories;
        
        return this;
    }

    /**
     * Creates a String representation of the FileBundleInstanceFile object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("documentId").append("='").append(getDocumentId()).append("' ");			
        buffer.append("isPrivate").append("='").append(isIsPrivate()).append("' ");			
        buffer.append("isValid").append("='").append(isIsValid()).append("' ");			
        buffer.append("uploadUserId").append("='").append(getUploadUserId()).append("' ");			
        buffer.append("uploadDate").append("='").append(getUploadDate()).append("' ");			
        buffer.append("uploadUserBusinessId").append("='").append(getUploadUserBusinessId()).append("' ");			
        buffer.append("validateUserId").append("='").append(getValidateUserId()).append("' ");			
        buffer.append("validateDate").append("='").append(getValidateDate()).append("' ");			
        buffer.append("validateUserBusinessId").append("='").append(getValidateUserBusinessId()).append("' ");			
        buffer.append("version").append("='").append(getVersion()).append("' ");			
        buffer.append("isInvalid").append("='").append(isIsInvalid()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the FileBundleInstanceFile object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(FileBundleInstanceFile other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("documentId".equalsIgnoreCase(attributeName))
            this.documentId = Long.valueOf(attributeValue);

        if ("isPrivate".equalsIgnoreCase(attributeName))
            this.isPrivate = Boolean.valueOf(attributeValue);

        if ("isValid".equalsIgnoreCase(attributeName))
            this.isValid = Boolean.valueOf(attributeValue);

        if ("uploadUserId".equalsIgnoreCase(attributeName))
        	this.uploadUserId = attributeValue;

        if ("uploadDate".equalsIgnoreCase(attributeName))
            this.uploadDate = Timestamp.valueOf(attributeValue);

        if ("uploadUserBusinessId".equalsIgnoreCase(attributeName))
        	this.uploadUserBusinessId = attributeValue;

        if ("validateUserId".equalsIgnoreCase(attributeName))
        	this.validateUserId = attributeValue;

        if ("validateDate".equalsIgnoreCase(attributeName))
            this.validateDate = Timestamp.valueOf(attributeValue);

        if ("validateUserBusinessId".equalsIgnoreCase(attributeName))
        	this.validateUserBusinessId = attributeValue;

        if ("version".equalsIgnoreCase(attributeName))
            this.version = Long.valueOf(attributeValue);

        if ("isInvalid".equalsIgnoreCase(attributeName))
            this.isInvalid = Boolean.valueOf(attributeValue);

    }


    /**
     * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
     *
     * @param session the session
     * @param id      the id
     *
     * @return the proxy
     */
    public static FileBundleInstanceFile getProxy(Session session, Long id)
    {
        return(FileBundleInstanceFile)session.load(FileBundleInstanceFile.class,id);
    }

    /**
    * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
    *
    * @param id      the id
    *
    * @return the proxy
    */
    public static FileBundleInstanceFile getProxy(Long id)
    {
        Session session = HibernateUtil.getSessionFactory("DIFRepository").getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        FileBundleInstanceFile result = (FileBundleInstanceFile)session.load(FileBundleInstanceFile.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }


    /**
     * Instanciates an Hibernate data object
     *
     * @param session the session
     * @param id      the id
     *
     * @return the instance
     */
    public static FileBundleInstanceFile getInstance(Session session, Long id)
    {
        return(FileBundleInstanceFile)session.get(FileBundleInstanceFile.class,id);
    }

    /**
    * Instanciates an Hibernate data object
    *
    * @param id      the id
    *
    * @return the instance
    */
    public static FileBundleInstanceFile getInstance(Long id)
    {
        Session session = HibernateUtil.getSessionFactory("DIFRepository").getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        FileBundleInstanceFile result = (FileBundleInstanceFile)session.get(FileBundleInstanceFile.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }

}
