package pt.digitalis.dif.dem.managers.impl.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link FileBundleInstanceFile}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class FileBundleInstanceFileFieldAttributes extends AbstractBeanAttributesDefinition{

    /** documentId (Database column: DOCUMENT_ID) */
    static public AttributeDefinition documentId =
        new AttributeDefinition("documentId")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("FILE_BUNDLE_INSTANCE_FILE")
                .setDatabaseId("DOCUMENT_ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(Long.class);

    /** fileBundleFile (Database column: FILE_BUNDLE_FILE_ID) */
    static public AttributeDefinition fileBundleFile =
        new AttributeDefinition("fileBundleFile")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("FILE_BUNDLE_INSTANCE_FILE")
                .setDatabaseId("FILE_BUNDLE_FILE_ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setLovDataClass(pt.digitalis.dif.dem.managers.impl.model.data.FileBundleFile.class)
                .setLovDataClassKey("id")
                .setLovDataClassDescription("description")
                .setType(pt.digitalis.dif.dem.managers.impl.model.data.FileBundleFile.class);

    /** fileBundleInstance (Database column: FILE_BUNDLE_INSTANCE_ID) */
    static public AttributeDefinition fileBundleInstance =
        new AttributeDefinition("fileBundleInstance")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("FILE_BUNDLE_INSTANCE_FILE")
                .setDatabaseId("FILE_BUNDLE_INSTANCE_ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setLovDataClass(pt.digitalis.dif.dem.managers.impl.model.data.FileBundleInstance.class)
                .setLovDataClassKey("id")
                .setLovDataClassDescription("businessProcessInstanceId")
                .setType(pt.digitalis.dif.dem.managers.impl.model.data.FileBundleInstance.class);

    /** id (Database column: ID) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("FILE_BUNDLE_INSTANCE_FILE")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(Long.class);

    /** isInvalid (Database column: IS_INVALID) */
    static public AttributeDefinition isInvalid =
        new AttributeDefinition("isInvalid")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("FILE_BUNDLE_INSTANCE_FILE")
                .setDatabaseId("IS_INVALID")
                .setMandatory(true)
                .setMaxSize(255)
                .setDefaultValue("0")
                .setType(boolean.class);

    /** isPrivate (Database column: IS_PRIVATE) */
    static public AttributeDefinition isPrivate =
        new AttributeDefinition("isPrivate")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("FILE_BUNDLE_INSTANCE_FILE")
                .setDatabaseId("IS_PRIVATE")
                .setMandatory(true)
                .setMaxSize(255)
                .setDefaultValue("0")
                .setType(boolean.class);

    /** isValid (Database column: IS_VALID) */
    static public AttributeDefinition isValid =
        new AttributeDefinition("isValid")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("FILE_BUNDLE_INSTANCE_FILE")
                .setDatabaseId("IS_VALID")
                .setMandatory(true)
                .setMaxSize(255)
                .setDefaultValue("0")
                .setType(boolean.class);

    /** uploadDate (Database column: UPLOAD_DATE) */
    static public AttributeDefinition uploadDate =
        new AttributeDefinition("uploadDate")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("FILE_BUNDLE_INSTANCE_FILE")
                .setDatabaseId("UPLOAD_DATE")
                .setMandatory(true)
                .setMaxSize(7)
                .setType(Timestamp.class);

    /** uploadUserBusinessId (Database column: UPLOAD_USER_BUSINESS_ID) */
    static public AttributeDefinition uploadUserBusinessId =
        new AttributeDefinition("uploadUserBusinessId")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("FILE_BUNDLE_INSTANCE_FILE")
                .setDatabaseId("UPLOAD_USER_BUSINESS_ID")
                .setMandatory(true)
                .setMaxSize(300)
                .setType(String.class);

    /** uploadUserId (Database column: UPLOAD_USER_ID) */
    static public AttributeDefinition uploadUserId =
        new AttributeDefinition("uploadUserId")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("FILE_BUNDLE_INSTANCE_FILE")
                .setDatabaseId("UPLOAD_USER_ID")
                .setMandatory(true)
                .setMaxSize(300)
                .setType(String.class);

    /** validateDate (Database column: VALIDATE_DATE) */
    static public AttributeDefinition validateDate =
        new AttributeDefinition("validateDate")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("FILE_BUNDLE_INSTANCE_FILE")
                .setDatabaseId("VALIDATE_DATE")
                .setMandatory(true)
                .setMaxSize(7)
                .setType(Timestamp.class);

    /** validateUserBusinessId (Database column: VALIDATE_USER_BUSINESS_ID) */
    static public AttributeDefinition validateUserBusinessId =
        new AttributeDefinition("validateUserBusinessId")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("FILE_BUNDLE_INSTANCE_FILE")
                .setDatabaseId("VALIDATE_USER_BUSINESS_ID")
                .setMandatory(true)
                .setMaxSize(300)
                .setType(String.class);

    /** validateUserId (Database column: VALIDATE_USER_ID) */
    static public AttributeDefinition validateUserId =
        new AttributeDefinition("validateUserId")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("FILE_BUNDLE_INSTANCE_FILE")
                .setDatabaseId("VALIDATE_USER_ID")
                .setMandatory(true)
                .setMaxSize(300)
                .setType(String.class);

    /** version (Database column: VERSION) */
    static public AttributeDefinition version =
        new AttributeDefinition("version")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("FILE_BUNDLE_INSTANCE_FILE")
                .setDatabaseId("VERSION")
                .setMandatory(true)
                .setMaxSize(255)
                .setDefaultValue("1")
                .setType(Long.class);

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(documentId.getName(),documentId);
        map.put(fileBundleFile.getName(),fileBundleFile);
        map.put(fileBundleInstance.getName(),fileBundleInstance);
        map.put(id.getName(),id);
        map.put(isInvalid.getName(),isInvalid);
        map.put(isPrivate.getName(),isPrivate);
        map.put(isValid.getName(),isValid);
        map.put(uploadDate.getName(),uploadDate);
        map.put(uploadUserBusinessId.getName(),uploadUserBusinessId);
        map.put(uploadUserId.getName(),uploadUserId);
        map.put(validateDate.getName(),validateDate);
        map.put(validateUserBusinessId.getName(),validateUserBusinessId);
        map.put(validateUserId.getName(),validateUserId);
        map.put(version.getName(),version);

        return map;
    }
}