package pt.digitalis.dif.dem.managers.impl.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link FileType}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class FileTypeFieldAttributes extends AbstractBeanAttributesDefinition{

    /** businessProcessTypeId (Database column: BUSINESS_PROCESS_TYPE_ID) */
    static public AttributeDefinition businessProcessTypeId =
        new AttributeDefinition("businessProcessTypeId")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("FILE_TYPE")
                .setDatabaseId("BUSINESS_PROCESS_TYPE_ID")
                .setMandatory(true)
                .setMaxSize(300)
                .setType(String.class);

    /** description (Database column: DESCRIPTION) */
    static public AttributeDefinition description =
        new AttributeDefinition("description")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("FILE_TYPE")
                .setDatabaseId("DESCRIPTION")
                .setMandatory(true)
                .setMaxSize(500)
                .setType(String.class);

    /** id (Database column: ID) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("FILE_TYPE")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(Long.class);

    /** maxFileSize (Database column: MAX_FILE_SIZE) */
    static public AttributeDefinition maxFileSize =
        new AttributeDefinition("maxFileSize")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("FILE_TYPE")
                .setDatabaseId("MAX_FILE_SIZE")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(Long.class);

    /** mimeTypes (Database column: MIME_TYPES) */
    static public AttributeDefinition mimeTypes =
        new AttributeDefinition("mimeTypes")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("FILE_TYPE")
                .setDatabaseId("MIME_TYPES")
                .setMandatory(true)
                .setMaxSize(200)
                .setType(String.class);

    /** name (Database column: NAME) */
    static public AttributeDefinition name =
        new AttributeDefinition("name")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("FILE_TYPE")
                .setDatabaseId("NAME")
                .setMandatory(true)
                .setMaxSize(200)
                .setType(String.class);

    /** templateDocumentId (Database column: TEMPLATE_DOCUMENT_ID) */
    static public AttributeDefinition templateDocumentId =
        new AttributeDefinition("templateDocumentId")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("FILE_TYPE")
                .setDatabaseId("TEMPLATE_DOCUMENT_ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(Long.class);

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(businessProcessTypeId.getName(),businessProcessTypeId);
        map.put(description.getName(),description);
        map.put(id.getName(),id);
        map.put(maxFileSize.getName(),maxFileSize);
        map.put(mimeTypes.getName(),mimeTypes);
        map.put(name.getName(),name);
        map.put(templateDocumentId.getName(),templateDocumentId);

        return map;
    }
}