package pt.digitalis.dif.dem.managers.impl.model.data;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.model.utils.IBeanAttributesDataSet;

/**
 * FileTypeGenParameters
* Generated on ORM Generator
* DIF build process for the Model layer
*
*/
@SuppressWarnings("serial")
public class FileTypeGenParameters extends AbstractBeanRelationsAttributes implements java.io.Serializable, IBeanAttributesDataSet<FileTypeGenParameters> {

    /** FileTypeGenParameters attributes enumeration */
    public static class Fields
    {
        /** id column */
        public static final String ID ="id";
        /** name column */
        public static final String NAME ="name";
        /** type column */
        public static final String TYPE ="type";
        /** options column */
        public static final String OPTIONS ="options";
        /** optionsAjaxEvent column */
        public static final String OPTIONSAJAXEVENT ="optionsAjaxEvent";
        /** isMandatory column */
        public static final String ISMANDATORY ="isMandatory";
        /** hint column */
        public static final String HINT ="hint";
        /** help column */
        public static final String HELP ="help";

        /**
         * List of existing fields
         *
         * @return list of field names
         */
        public static List<String> values()
        {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("name");
            list.add("type");
            list.add("options");
            list.add("optionsAjaxEvent");
            list.add("isMandatory");
            list.add("hint");
            list.add("help");

            return list;
        }
    }

    /** Field attributes */
    public static FileTypeGenParametersFieldAttributes FieldAttributes=new FileTypeGenParametersFieldAttributes();

    /**
    * @return the field attributes definitions
    */
    @Override public FileTypeGenParametersFieldAttributes getDefinitions()
    {
        return FieldAttributes;
    }

    /**
     * The Class Relations.
     */
    public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations
    {

        /**
        * Instantiates a new relations.
        *
        * @param currentPath the current path
        */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * fileType relation.
         *
         * @return the fileType bean relations attributes.
         */
        public FileType.Relations fileType()
        {
            FileType c = new FileType();
            return c.new Relations(this.buildPath("fileType"));
        }

        /**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
        /**
         * the NAME path.
         *
         * @return the path
         */
        public String NAME()
        {
            return buildPath(Fields.NAME);
        }
        /**
         * the TYPE path.
         *
         * @return the path
         */
        public String TYPE()
        {
            return buildPath(Fields.TYPE);
        }
        /**
         * the OPTIONS path.
         *
         * @return the path
         */
        public String OPTIONS()
        {
            return buildPath(Fields.OPTIONS);
        }
        /**
         * the OPTIONSAJAXEVENT path.
         *
         * @return the path
         */
        public String OPTIONSAJAXEVENT()
        {
            return buildPath(Fields.OPTIONSAJAXEVENT);
        }
        /**
         * the ISMANDATORY path.
         *
         * @return the path
         */
        public String ISMANDATORY()
        {
            return buildPath(Fields.ISMANDATORY);
        }
        /**
         * the HINT path.
         *
         * @return the path
         */
        public String HINT()
        {
            return buildPath(Fields.HINT);
        }
        /**
         * the HELP path.
         *
         * @return the path
         */
        public String HELP()
        {
            return buildPath(Fields.HELP);
        }
    }

    /** The dummy obj. */
    private static FileTypeGenParameters dummyObj=new FileTypeGenParameters();

    /**
     * Get FileTypeGenParameters Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public IDataSet<FileTypeGenParameters> getDataSet()
    {
        return new HibernateDataSet<FileTypeGenParameters>(FileTypeGenParameters.class, HibernateUtil.getSessionFactory("DIFRepository"),
            FileTypeGenParameters.getPKFieldListAsString(), FileTypeGenParameters.FieldAttributes);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public static IDataSet<FileTypeGenParameters> getDataSetInstance()
    {
        return new FileTypeGenParameters().getDataSet();
    }

    /**
    * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
    */
    @Override protected Object getAttributeNoGraphNavigation(String attributeName)
    {
        if("id".equalsIgnoreCase(attributeName))
            return id;
        if("fileType".equalsIgnoreCase(attributeName))
            return fileType;
        if("name".equalsIgnoreCase(attributeName))
            return name;
        if("type".equalsIgnoreCase(attributeName))
            return type;
        if("options".equalsIgnoreCase(attributeName))
            return options;
        if("optionsAjaxEvent".equalsIgnoreCase(attributeName))
            return optionsAjaxEvent;
        if("isMandatory".equalsIgnoreCase(attributeName))
            return isMandatory;
        if("hint".equalsIgnoreCase(attributeName))
            return hint;
        if("help".equalsIgnoreCase(attributeName))
            return help;

        return null;
    }

    /**
    * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
    */
    public void setAttribute(String attributeName,Object attributeValue)
    {
        if("id".equalsIgnoreCase(attributeName))
            id =(Long)attributeValue;
        if("fileType".equalsIgnoreCase(attributeName))
            fileType =(FileType)attributeValue;
        if("name".equalsIgnoreCase(attributeName))
            name =(String)attributeValue;
        if("type".equalsIgnoreCase(attributeName))
            type =(String)attributeValue;
        if("options".equalsIgnoreCase(attributeName))
            options =(String)attributeValue;
        if("optionsAjaxEvent".equalsIgnoreCase(attributeName))
            optionsAjaxEvent =(String)attributeValue;
        if("isMandatory".equalsIgnoreCase(attributeName))
            isMandatory =(Boolean)attributeValue;
        if("hint".equalsIgnoreCase(attributeName))
            hint =(String)attributeValue;
        if("help".equalsIgnoreCase(attributeName))
            help =(String)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** fileType private attribute */
    private FileType fileType;

    /** name private attribute */
    private String name;

    /** type private attribute */
    private String type;

    /** options private attribute */
    private String options;

    /** optionsAjaxEvent private attribute */
    private String optionsAjaxEvent;

    /** isMandatory private attribute */
    private boolean isMandatory;

    /** hint private attribute */
    private String hint;

    /** help private attribute */
    private String help;

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {

        Object value = getAttribute(attributeName);

        if (value == null)
            return "";
        else {
            return value.toString().trim();
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public FileTypeGenParameters() {
    }

	/** 
	 * minimal constructor
	 *
     * @param fileType the fileType
     * @param name the name
     * @param type the type
    }
	 */
    public FileTypeGenParameters(FileType fileType, String name, String type) {
        this.fileType = fileType;
        this.name = name;
        this.type = type;
    }

    /**
     * full constructor
	 *
     * @param fileType the fileType
     * @param name the name
     * @param type the type
     * @param options the options
     * @param optionsAjaxEvent the optionsAjaxEvent
     * @param isMandatory the isMandatory
     * @param hint the hint
     * @param help the help
     */
    public FileTypeGenParameters(FileType fileType, String name, String type, String options, String optionsAjaxEvent, boolean isMandatory, String hint, String help) {
        this.fileType = fileType;
        this.name = name;
        this.type = type;
        this.options = options;
        this.optionsAjaxEvent = optionsAjaxEvent;
        this.isMandatory = isMandatory;
        this.hint = hint;
        this.help = help;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id the id
     *
     * @return FileTypeGenParameters modified instance
     */
    public FileTypeGenParameters setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * fileType getter method
     *
     * @return fileType method
     */
    public FileType getFileType() {
        return this.fileType;
    }
    
    /**       
     * fileType setter method
     *
     * @param fileType the fileType
     *
     * @return FileTypeGenParameters modified instance
     */
    public FileTypeGenParameters setFileType(FileType fileType) {
        this.fileType = fileType;
        
        return this;
    }
    /**       
     * name getter method
     *
     * @return name method
     */
    public String getName() {
        return this.name;
    }
    
    /**       
     * name setter method
     *
     * @param name the name
     *
     * @return FileTypeGenParameters modified instance
     */
    public FileTypeGenParameters setName(String name) {
        this.name = name;
        
        return this;
    }
    /**       
     * type getter method
     *
     * @return type method
     */
    public String getType() {
        return this.type;
    }
    
    /**       
     * type setter method
     *
     * @param type the type
     *
     * @return FileTypeGenParameters modified instance
     */
    public FileTypeGenParameters setType(String type) {
        this.type = type;
        
        return this;
    }
    /**       
     * options getter method
     *
     * @return options method
     */
    public String getOptions() {
        return this.options;
    }
    
    /**       
     * options setter method
     *
     * @param options the options
     *
     * @return FileTypeGenParameters modified instance
     */
    public FileTypeGenParameters setOptions(String options) {
        this.options = options;
        
        return this;
    }
    /**       
     * optionsAjaxEvent getter method
     *
     * @return optionsAjaxEvent method
     */
    public String getOptionsAjaxEvent() {
        return this.optionsAjaxEvent;
    }
    
    /**       
     * optionsAjaxEvent setter method
     *
     * @param optionsAjaxEvent the optionsAjaxEvent
     *
     * @return FileTypeGenParameters modified instance
     */
    public FileTypeGenParameters setOptionsAjaxEvent(String optionsAjaxEvent) {
        this.optionsAjaxEvent = optionsAjaxEvent;
        
        return this;
    }
    /**       
     * isMandatory getter method
     *
     * @return isMandatory method
     */
    public boolean isIsMandatory() {
        return this.isMandatory;
    }
    
    /**       
     * isMandatory setter method
     *
     * @param isMandatory the isMandatory
     *
     * @return FileTypeGenParameters modified instance
     */
    public FileTypeGenParameters setIsMandatory(boolean isMandatory) {
        this.isMandatory = isMandatory;
        
        return this;
    }
    /**       
     * hint getter method
     *
     * @return hint method
     */
    public String getHint() {
        return this.hint;
    }
    
    /**       
     * hint setter method
     *
     * @param hint the hint
     *
     * @return FileTypeGenParameters modified instance
     */
    public FileTypeGenParameters setHint(String hint) {
        this.hint = hint;
        
        return this;
    }
    /**       
     * help getter method
     *
     * @return help method
     */
    public String getHelp() {
        return this.help;
    }
    
    /**       
     * help setter method
     *
     * @param help the help
     *
     * @return FileTypeGenParameters modified instance
     */
    public FileTypeGenParameters setHelp(String help) {
        this.help = help;
        
        return this;
    }

    /**
     * Creates a String representation of the FileTypeGenParameters object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("name").append("='").append(getName()).append("' ");			
        buffer.append("type").append("='").append(getType()).append("' ");			
        buffer.append("options").append("='").append(getOptions()).append("' ");			
        buffer.append("optionsAjaxEvent").append("='").append(getOptionsAjaxEvent()).append("' ");			
        buffer.append("isMandatory").append("='").append(isIsMandatory()).append("' ");			
        buffer.append("hint").append("='").append(getHint()).append("' ");			
        buffer.append("help").append("='").append(getHelp()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the FileTypeGenParameters object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(FileTypeGenParameters other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("name".equalsIgnoreCase(attributeName))
        	this.name = attributeValue;

        if ("type".equalsIgnoreCase(attributeName))
        	this.type = attributeValue;

        if ("options".equalsIgnoreCase(attributeName))
        	this.options = attributeValue;

        if ("optionsAjaxEvent".equalsIgnoreCase(attributeName))
        	this.optionsAjaxEvent = attributeValue;

        if ("isMandatory".equalsIgnoreCase(attributeName))
            this.isMandatory = Boolean.valueOf(attributeValue);

        if ("hint".equalsIgnoreCase(attributeName))
        	this.hint = attributeValue;

        if ("help".equalsIgnoreCase(attributeName))
        	this.help = attributeValue;

    }


    /**
     * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
     *
     * @param session the session
     * @param id      the id
     *
     * @return the proxy
     */
    public static FileTypeGenParameters getProxy(Session session, Long id)
    {
        return(FileTypeGenParameters)session.load(FileTypeGenParameters.class,id);
    }

    /**
    * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
    *
    * @param id      the id
    *
    * @return the proxy
    */
    public static FileTypeGenParameters getProxy(Long id)
    {
        Session session = HibernateUtil.getSessionFactory("DIFRepository").getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        FileTypeGenParameters result = (FileTypeGenParameters)session.load(FileTypeGenParameters.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }


    /**
     * Instanciates an Hibernate data object
     *
     * @param session the session
     * @param id      the id
     *
     * @return the instance
     */
    public static FileTypeGenParameters getInstance(Session session, Long id)
    {
        return(FileTypeGenParameters)session.get(FileTypeGenParameters.class,id);
    }

    /**
    * Instanciates an Hibernate data object
    *
    * @param id      the id
    *
    * @return the instance
    */
    public static FileTypeGenParameters getInstance(Long id)
    {
        Session session = HibernateUtil.getSessionFactory("DIFRepository").getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        FileTypeGenParameters result = (FileTypeGenParameters)session.get(FileTypeGenParameters.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }

}
