package pt.digitalis.dif.dem.managers.impl.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link Filter}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class FilterFieldAttributes extends AbstractBeanAttributesDefinition{

    /** bindToProfile (Database column: BIND_TO_PROFILE - The profile to bind this filter to (auto-apply filter to profile users)) */
    static public AttributeDefinition bindToProfile =
        new AttributeDefinition("bindToProfile")
                .setDescription("The profile to bind this filter to (auto-apply filter to profile users)")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("FILTER")
                .setDatabaseId("BIND_TO_PROFILE")
                .setMandatory(true)
                .setMaxSize(100)
                .setType(String.class);

    /** defaultValue (Database column: DEFAULT_VALUE - The default filter value) */
    static public AttributeDefinition defaultValue =
        new AttributeDefinition("defaultValue")
                .setDescription("The default filter value")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("FILTER")
                .setDatabaseId("DEFAULT_VALUE")
                .setMandatory(true)
                .setMaxSize(500)
                .setType(String.class);

    /** description (Database column: DESCRIPTION - The filter description) */
    static public AttributeDefinition description =
        new AttributeDefinition("description")
                .setDescription("The filter description")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("FILTER")
                .setDatabaseId("DESCRIPTION")
                .setMandatory(true)
                .setMaxSize(4000)
                .setType(String.class);

    /** id (Database column: ID - ID column) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDescription("ID column")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("FILTER")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(Long.class);

    /** indicator (Database column: INDICATOR_ID - The indicator ID) */
    static public AttributeDefinition indicator =
        new AttributeDefinition("indicator")
                .setDescription("The indicator ID")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("FILTER")
                .setDatabaseId("INDICATOR_ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setLovDataClass(pt.digitalis.dif.dem.managers.impl.model.data.Indicator.class)
                .setLovDataClassKey("id")
                .setLovDataClassDescription("description")
                .setType(pt.digitalis.dif.dem.managers.impl.model.data.Indicator.class);

    /** itemsList (Database column: ITEMS_LIST - The LOV values) */
    static public AttributeDefinition itemsList =
        new AttributeDefinition("itemsList")
                .setDescription("The LOV values")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("FILTER")
                .setDatabaseId("ITEMS_LIST")
                .setMandatory(true)
                .setMaxSize(4000)
                .setType(String.class);

    /** itemsQuerySql (Database column: ITEMS_QUERY_SQL - The LOV SQL query) */
    static public AttributeDefinition itemsQuerySql =
        new AttributeDefinition("itemsQuerySql")
                .setDescription("The LOV SQL query")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("FILTER")
                .setDatabaseId("ITEMS_QUERY_SQL")
                .setMandatory(true)
                .setMaxSize(4000)
                .setType(String.class);

    /** sqlTemplate (Database column: SQL_TEMPLATE - The SQL template to apply to the indicator query when the filter is used) */
    static public AttributeDefinition sqlTemplate =
        new AttributeDefinition("sqlTemplate")
                .setDescription("The SQL template to apply to the indicator query when the filter is used")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("FILTER")
                .setDatabaseId("SQL_TEMPLATE")
                .setMandatory(true)
                .setMaxSize(4000)
                .setType(String.class);

    /** title (Database column: TITLE - The filter title) */
    static public AttributeDefinition title =
        new AttributeDefinition("title")
                .setDescription("The filter title")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("FILTER")
                .setDatabaseId("TITLE")
                .setMandatory(true)
                .setMaxSize(500)
                .setType(String.class);

    /** type (Database column: TYPE - The filter type) */
    static public AttributeDefinition type =
        new AttributeDefinition("type")
                .setDescription("The filter type")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("FILTER")
                .setDatabaseId("TYPE")
                .setMandatory(true)
                .setMaxSize(1)
                .setDefaultValue("T")
                .setType(Character.class);

    /** uniqueId (Database column: UNIQUE_ID - Business unique ID) */
    static public AttributeDefinition uniqueId =
        new AttributeDefinition("uniqueId")
                .setDescription("Business unique ID")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("FILTER")
                .setDatabaseId("UNIQUE_ID")
                .setMandatory(true)
                .setMaxSize(200)
                .setType(String.class);

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(bindToProfile.getName(),bindToProfile);
        map.put(defaultValue.getName(),defaultValue);
        map.put(description.getName(),description);
        map.put(id.getName(),id);
        map.put(indicator.getName(),indicator);
        map.put(itemsList.getName(),itemsList);
        map.put(itemsQuerySql.getName(),itemsQuerySql);
        map.put(sqlTemplate.getName(),sqlTemplate);
        map.put(title.getName(),title);
        map.put(type.getName(),type);
        map.put(uniqueId.getName(),uniqueId);

        return map;
    }
}