package pt.digitalis.dif.dem.managers.impl.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link Indicator}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class IndicatorFieldAttributes extends AbstractBeanAttributesDefinition{

    /** area (Database column: AREA_ID - The parent area ID) */
    static public AttributeDefinition area =
        new AttributeDefinition("area")
                .setDescription("The parent area ID")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("INDICATOR")
                .setDatabaseId("AREA_ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setLovDataClass(pt.digitalis.dif.dem.managers.impl.model.data.Area.class)
                .setLovDataClassKey("id")
                .setType(pt.digitalis.dif.dem.managers.impl.model.data.Area.class);

    /** autoRefreshInt (Database column: AUTO_REFRESH_INT - If auto-refresh is present (in ms)) */
    static public AttributeDefinition autoRefreshInt =
        new AttributeDefinition("autoRefreshInt")
                .setDescription("If auto-refresh is present (in ms)")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("INDICATOR")
                .setDatabaseId("AUTO_REFRESH_INT")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(Long.class);

    /** axisXTitle (Database column: AXIS_X_TITLE - The title of the X axis) */
    static public AttributeDefinition axisXTitle =
        new AttributeDefinition("axisXTitle")
                .setDescription("The title of the X axis")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("INDICATOR")
                .setDatabaseId("AXIS_X_TITLE")
                .setMandatory(true)
                .setMaxSize(200)
                .setType(String.class);

    /** axisYTitle (Database column: AXIS_Y_TITLE - The title of the y axis) */
    static public AttributeDefinition axisYTitle =
        new AttributeDefinition("axisYTitle")
                .setDescription("The title of the y axis")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("INDICATOR")
                .setDatabaseId("AXIS_Y_TITLE")
                .setMandatory(true)
                .setMaxSize(200)
                .setType(String.class);

    /** chartMode (Database column: CHART_MODE - If the indicator is a chart.) */
    static public AttributeDefinition chartMode =
        new AttributeDefinition("chartMode")
                .setDescription("If the indicator is a chart.")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("INDICATOR")
                .setDatabaseId("CHART_MODE")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(boolean.class);

    /** definitionType (Database column: DEFINITION_TYPE - The indicator type of definition) */
    static public AttributeDefinition definitionType =
        new AttributeDefinition("definitionType")
                .setDescription("The indicator type of definition")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("INDICATOR")
                .setDatabaseId("DEFINITION_TYPE")
                .setMandatory(true)
                .setMaxSize(1)
                .setType(Character.class);

    /** description (Database column: DESCRIPTION - The indicator description) */
    static public AttributeDefinition description =
        new AttributeDefinition("description")
                .setDescription("The indicator description")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("INDICATOR")
                .setDatabaseId("DESCRIPTION")
                .setMandatory(true)
                .setMaxSize(4000)
                .setType(String.class);

    /** descriptionTitle (Database column: DESCRIPTION_TITLE - The indicator title description) */
    static public AttributeDefinition descriptionTitle =
        new AttributeDefinition("descriptionTitle")
                .setDescription("The indicator title description")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("INDICATOR")
                .setDatabaseId("DESCRIPTION_TITLE")
                .setMandatory(true)
                .setMaxSize(500)
                .setType(String.class);

    /** gridColumns (Database column: GRID_COLUMNS - The grid columns configuration.) */
    static public AttributeDefinition gridColumns =
        new AttributeDefinition("gridColumns")
                .setDescription("The grid columns configuration.")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("INDICATOR")
                .setDatabaseId("GRID_COLUMNS")
                .setMandatory(true)
                .setMaxSize(4000)
                .setType(String.class);

    /** groupPosition (Database column: GROUP_POSITION - The custom position of the group.) */
    static public AttributeDefinition groupPosition =
        new AttributeDefinition("groupPosition")
                .setDescription("The custom position of the group.")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("INDICATOR")
                .setDatabaseId("GROUP_POSITION")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(Long.class);

    /** groupTitle (Database column: GROUP_TITLE - The group title) */
    static public AttributeDefinition groupTitle =
        new AttributeDefinition("groupTitle")
                .setDescription("The group title")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("INDICATOR")
                .setDatabaseId("GROUP_TITLE")
                .setMandatory(true)
                .setMaxSize(2000)
                .setType(String.class);

    /** hideMarkers (Database column: HIDE_MARKERS - Hide markers in line charts) */
    static public AttributeDefinition hideMarkers =
        new AttributeDefinition("hideMarkers")
                .setDescription("Hide markers in line charts")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("INDICATOR")
                .setDatabaseId("HIDE_MARKERS")
                .setMandatory(true)
                .setMaxSize(255)
                .setDefaultValue("0")
                .setType(boolean.class);

    /** id (Database column: ID - ID column) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDescription("ID column")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("INDICATOR")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(Long.class);

    /** isVisible (Database column: IS_VISIBLE - If the indicator is visible.) */
    static public AttributeDefinition isVisible =
        new AttributeDefinition("isVisible")
                .setDescription("If the indicator is visible.")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("INDICATOR")
                .setDatabaseId("IS_VISIBLE")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(boolean.class);

    /** legend (Database column: LEGEND - Show legend) */
    static public AttributeDefinition legend =
        new AttributeDefinition("legend")
                .setDescription("Show legend")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("INDICATOR")
                .setDatabaseId("LEGEND")
                .setMandatory(true)
                .setMaxSize(255)
                .setDefaultValue("0")
                .setType(boolean.class);

    /** limitTopRecords (Database column: LIMIT_TOP_RECORDS - Limit the first records) */
    static public AttributeDefinition limitTopRecords =
        new AttributeDefinition("limitTopRecords")
                .setDescription("Limit the first records")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("INDICATOR")
                .setDatabaseId("LIMIT_TOP_RECORDS")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(Long.class);

    /** maxValue (Database column: MAX_VALUE - The scale max value if rigid) */
    static public AttributeDefinition maxValue =
        new AttributeDefinition("maxValue")
                .setDescription("The scale max value if rigid")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("INDICATOR")
                .setDatabaseId("MAX_VALUE")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(Long.class);

    /** position (Database column: POSITION - The custom position inside it's group.) */
    static public AttributeDefinition position =
        new AttributeDefinition("position")
                .setDescription("The custom position inside it's group.")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("INDICATOR")
                .setDatabaseId("POSITION")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(Long.class);

    /** querySql (Database column: QUERY_SQL - The SQL to gt the data from) */
    static public AttributeDefinition querySql =
        new AttributeDefinition("querySql")
                .setDescription("The SQL to gt the data from")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("INDICATOR")
                .setDatabaseId("QUERY_SQL")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(String.class);

    /** restrictGroups (Database column: RESTRICT_GROUPS - List of groups to restrict access to the indicators) */
    static public AttributeDefinition restrictGroups =
        new AttributeDefinition("restrictGroups")
                .setDescription("List of groups to restrict access to the indicators")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("INDICATOR")
                .setDatabaseId("RESTRICT_GROUPS")
                .setMandatory(true)
                .setMaxSize(4000)
                .setType(String.class);

    /** restrictProfiles (Database column: RESTRICT_PROFILES - List of profiles to restrict access to the indicators) */
    static public AttributeDefinition restrictProfiles =
        new AttributeDefinition("restrictProfiles")
                .setDescription("List of profiles to restrict access to the indicators")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("INDICATOR")
                .setDatabaseId("RESTRICT_PROFILES")
                .setMandatory(true)
                .setMaxSize(4000)
                .setType(String.class);

    /** timeKeys (Database column: TIME_KEYS - Time key values) */
    static public AttributeDefinition timeKeys =
        new AttributeDefinition("timeKeys")
                .setDescription("Time key values")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("INDICATOR")
                .setDatabaseId("TIME_KEYS")
                .setMandatory(true)
                .setMaxSize(255)
                .setDefaultValue("0")
                .setType(boolean.class);

    /** title (Database column: TITLE - The indicator title) */
    static public AttributeDefinition title =
        new AttributeDefinition("title")
                .setDescription("The indicator title")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("INDICATOR")
                .setDatabaseId("TITLE")
                .setMandatory(true)
                .setMaxSize(500)
                .setType(String.class);

    /** totalField (Database column: TOTAL_FIELD - The total field if exists) */
    static public AttributeDefinition totalField =
        new AttributeDefinition("totalField")
                .setDescription("The total field if exists")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("INDICATOR")
                .setDatabaseId("TOTAL_FIELD")
                .setMandatory(true)
                .setMaxSize(255)
                .setDefaultValue("0")
                .setType(boolean.class);

    /** uniqueId (Database column: UNIQUE_ID - Business unique ID) */
    static public AttributeDefinition uniqueId =
        new AttributeDefinition("uniqueId")
                .setDescription("Business unique ID")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("INDICATOR")
                .setDatabaseId("UNIQUE_ID")
                .setMandatory(true)
                .setMaxSize(200)
                .setType(String.class);

    /** unitSuffix (Database column: UNIT_SUFFIX - The unix suffix) */
    static public AttributeDefinition unitSuffix =
        new AttributeDefinition("unitSuffix")
                .setDescription("The unix suffix")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("INDICATOR")
                .setDatabaseId("UNIT_SUFFIX")
                .setMandatory(true)
                .setMaxSize(100)
                .setType(String.class);

    /** useMinutes (Database column: USE_MINUTES - Show minutes) */
    static public AttributeDefinition useMinutes =
        new AttributeDefinition("useMinutes")
                .setDescription("Show minutes")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("INDICATOR")
                .setDatabaseId("USE_MINUTES")
                .setMandatory(true)
                .setMaxSize(255)
                .setDefaultValue("0")
                .setType(boolean.class);

    /** viewsToRefresh (Database column: VIEWS_TO_REFRESH - The database view to refresh data for materialized or persistent pre calculated data sets) */
    static public AttributeDefinition viewsToRefresh =
        new AttributeDefinition("viewsToRefresh")
                .setDescription("The database view to refresh data for materialized or persistent pre calculated data sets")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("INDICATOR")
                .setDatabaseId("VIEWS_TO_REFRESH")
                .setMandatory(true)
                .setMaxSize(4000)
                .setType(String.class);

    /** visibleFor (Database column: VISIBLE_FOR - Configurations for wich the indicator is visible.) */
    static public AttributeDefinition visibleFor =
        new AttributeDefinition("visibleFor")
                .setDescription("Configurations for wich the indicator is visible.")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("INDICATOR")
                .setDatabaseId("VISIBLE_FOR")
                .setMandatory(true)
                .setMaxSize(500)
                .setType(String.class);

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(area.getName(),area);
        map.put(autoRefreshInt.getName(),autoRefreshInt);
        map.put(axisXTitle.getName(),axisXTitle);
        map.put(axisYTitle.getName(),axisYTitle);
        map.put(chartMode.getName(),chartMode);
        map.put(definitionType.getName(),definitionType);
        map.put(description.getName(),description);
        map.put(descriptionTitle.getName(),descriptionTitle);
        map.put(gridColumns.getName(),gridColumns);
        map.put(groupPosition.getName(),groupPosition);
        map.put(groupTitle.getName(),groupTitle);
        map.put(hideMarkers.getName(),hideMarkers);
        map.put(id.getName(),id);
        map.put(isVisible.getName(),isVisible);
        map.put(legend.getName(),legend);
        map.put(limitTopRecords.getName(),limitTopRecords);
        map.put(maxValue.getName(),maxValue);
        map.put(position.getName(),position);
        map.put(querySql.getName(),querySql);
        map.put(restrictGroups.getName(),restrictGroups);
        map.put(restrictProfiles.getName(),restrictProfiles);
        map.put(timeKeys.getName(),timeKeys);
        map.put(title.getName(),title);
        map.put(totalField.getName(),totalField);
        map.put(uniqueId.getName(),uniqueId);
        map.put(unitSuffix.getName(),unitSuffix);
        map.put(useMinutes.getName(),useMinutes);
        map.put(viewsToRefresh.getName(),viewsToRefresh);
        map.put(visibleFor.getName(),visibleFor);

        return map;
    }
}