package pt.digitalis.dif.dem.managers.impl.model.data;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.model.utils.IBeanAttributesDataSet;

/**
 * JasperReportConfig
* Generated on ORM Generator
* DIF build process for the Model layer
*
*/
@SuppressWarnings("serial")
public class JasperReportConfig extends AbstractBeanRelationsAttributes implements java.io.Serializable, IBeanAttributesDataSet<JasperReportConfig> {

    /** JasperReportConfig attributes enumeration */
    public static class Fields
    {
        /** id column */
        public static final String ID ="id";
        /** businessId column */
        public static final String BUSINESSID ="businessId";
        /** parametersValues column */
        public static final String PARAMETERSVALUES ="parametersValues";

        /**
         * List of existing fields
         *
         * @return list of field names
         */
        public static List<String> values()
        {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("businessId");
            list.add("parametersValues");

            return list;
        }
    }

    /** Field attributes */
    public static JasperReportConfigFieldAttributes FieldAttributes=new JasperReportConfigFieldAttributes();

    /**
    * @return the field attributes definitions
    */
    @Override public JasperReportConfigFieldAttributes getDefinitions()
    {
        return FieldAttributes;
    }

    /**
     * The Class Relations.
     */
    public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations
    {

        /**
        * Instantiates a new relations.
        *
        * @param currentPath the current path
        */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * jasperReportTemplate relation.
         *
         * @return the jasperReportTemplate bean relations attributes.
         */
        public JasperReportTemplate.Relations jasperReportTemplate()
        {
            JasperReportTemplate c = new JasperReportTemplate();
            return c.new Relations(this.buildPath("jasperReportTemplate"));
        }

        /**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
        /**
         * the BUSINESSID path.
         *
         * @return the path
         */
        public String BUSINESSID()
        {
            return buildPath(Fields.BUSINESSID);
        }
        /**
         * the PARAMETERSVALUES path.
         *
         * @return the path
         */
        public String PARAMETERSVALUES()
        {
            return buildPath(Fields.PARAMETERSVALUES);
        }
    }

    /** The dummy obj. */
    private static JasperReportConfig dummyObj=new JasperReportConfig();

    /**
     * Get JasperReportConfig Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public IDataSet<JasperReportConfig> getDataSet()
    {
        return new HibernateDataSet<JasperReportConfig>(JasperReportConfig.class, HibernateUtil.getSessionFactory("DIFRepository"),
            JasperReportConfig.getPKFieldListAsString(), JasperReportConfig.FieldAttributes);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public static IDataSet<JasperReportConfig> getDataSetInstance()
    {
        return new JasperReportConfig().getDataSet();
    }

    /**
    * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
    */
    @Override protected Object getAttributeNoGraphNavigation(String attributeName)
    {
        if("id".equalsIgnoreCase(attributeName))
            return id;
        if("jasperReportTemplate".equalsIgnoreCase(attributeName))
            return jasperReportTemplate;
        if("businessId".equalsIgnoreCase(attributeName))
            return businessId;
        if("parametersValues".equalsIgnoreCase(attributeName))
            return parametersValues;

        return null;
    }

    /**
    * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
    */
    public void setAttribute(String attributeName,Object attributeValue)
    {
        if("id".equalsIgnoreCase(attributeName))
            id =(Long)attributeValue;
        if("jasperReportTemplate".equalsIgnoreCase(attributeName))
            jasperReportTemplate =(JasperReportTemplate)attributeValue;
        if("businessId".equalsIgnoreCase(attributeName))
            businessId =(String)attributeValue;
        if("parametersValues".equalsIgnoreCase(attributeName))
            parametersValues =(String)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** jasperReportTemplate private attribute */
    private JasperReportTemplate jasperReportTemplate;

    /** businessId private attribute */
    private String businessId;

    /** parametersValues private attribute */
    private String parametersValues;

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {

        Object value = getAttribute(attributeName);

        if (value == null)
            return "";
        else {
            return value.toString().trim();
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public JasperReportConfig() {
    }

	/** 
	 * minimal constructor
	 *
     * @param jasperReportTemplate the jasperReportTemplate
    }
	 */
    public JasperReportConfig(JasperReportTemplate jasperReportTemplate) {
        this.jasperReportTemplate = jasperReportTemplate;
    }

    /**
     * full constructor
	 *
     * @param jasperReportTemplate the jasperReportTemplate
     * @param businessId the businessId
     * @param parametersValues the parametersValues
     */
    public JasperReportConfig(JasperReportTemplate jasperReportTemplate, String businessId, String parametersValues) {
        this.jasperReportTemplate = jasperReportTemplate;
        this.businessId = businessId;
        this.parametersValues = parametersValues;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id the id
     *
     * @return JasperReportConfig modified instance
     */
    public JasperReportConfig setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * jasperReportTemplate getter method
     *
     * @return jasperReportTemplate method
     */
    public JasperReportTemplate getJasperReportTemplate() {
        return this.jasperReportTemplate;
    }
    
    /**       
     * jasperReportTemplate setter method
     *
     * @param jasperReportTemplate the jasperReportTemplate
     *
     * @return JasperReportConfig modified instance
     */
    public JasperReportConfig setJasperReportTemplate(JasperReportTemplate jasperReportTemplate) {
        this.jasperReportTemplate = jasperReportTemplate;
        
        return this;
    }
    /**       
     * businessId getter method
     *
     * @return businessId method
     */
    public String getBusinessId() {
        return this.businessId;
    }
    
    /**       
     * businessId setter method
     *
     * @param businessId the businessId
     *
     * @return JasperReportConfig modified instance
     */
    public JasperReportConfig setBusinessId(String businessId) {
        this.businessId = businessId;
        
        return this;
    }
    /**       
     * parametersValues getter method
     *
     * @return parametersValues method
     */
    public String getParametersValues() {
        return this.parametersValues;
    }
    
    /**       
     * parametersValues setter method
     *
     * @param parametersValues the parametersValues
     *
     * @return JasperReportConfig modified instance
     */
    public JasperReportConfig setParametersValues(String parametersValues) {
        this.parametersValues = parametersValues;
        
        return this;
    }

    /**
     * Creates a String representation of the JasperReportConfig object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("businessId").append("='").append(getBusinessId()).append("' ");			
        buffer.append("parametersValues").append("='").append(getParametersValues()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the JasperReportConfig object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(JasperReportConfig other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("businessId".equalsIgnoreCase(attributeName))
        	this.businessId = attributeValue;

        if ("parametersValues".equalsIgnoreCase(attributeName))
        	this.parametersValues = attributeValue;

    }


    /**
     * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
     *
     * @param session the session
     * @param id      the id
     *
     * @return the proxy
     */
    public static JasperReportConfig getProxy(Session session, Long id)
    {
        return(JasperReportConfig)session.load(JasperReportConfig.class,id);
    }

    /**
    * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
    *
    * @param id      the id
    *
    * @return the proxy
    */
    public static JasperReportConfig getProxy(Long id)
    {
        Session session = HibernateUtil.getSessionFactory("DIFRepository").getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        JasperReportConfig result = (JasperReportConfig)session.load(JasperReportConfig.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }


    /**
     * Instanciates an Hibernate data object
     *
     * @param session the session
     * @param id      the id
     *
     * @return the instance
     */
    public static JasperReportConfig getInstance(Session session, Long id)
    {
        return(JasperReportConfig)session.get(JasperReportConfig.class,id);
    }

    /**
    * Instanciates an Hibernate data object
    *
    * @param id      the id
    *
    * @return the instance
    */
    public static JasperReportConfig getInstance(Long id)
    {
        Session session = HibernateUtil.getSessionFactory("DIFRepository").getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        JasperReportConfig result = (JasperReportConfig)session.get(JasperReportConfig.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }

}
