package pt.digitalis.dif.dem.managers.impl.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link JasperReportConfig}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class JasperReportConfigFieldAttributes extends AbstractBeanAttributesDefinition{

    /** businessId (Database column: BUSINESS_ID - The business ID that somehow links this configuration to is business use) */
    static public AttributeDefinition businessId =
        new AttributeDefinition("businessId")
                .setDescription("The business ID that somehow links this configuration to is business use")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("JASPER_REPORT_CONFIG")
                .setDatabaseId("BUSINESS_ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(String.class);

    /** id (Database column: ID - ID) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDescription("ID")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("JASPER_REPORT_CONFIG")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(Long.class);

    /** parametersValues (Database column: PARAMETERS_VALUES - The parameter values in JSON format) */
    static public AttributeDefinition parametersValues =
        new AttributeDefinition("parametersValues")
                .setDescription("The parameter values in JSON format")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("JASPER_REPORT_CONFIG")
                .setDatabaseId("PARAMETERS_VALUES")
                .setMandatory(true)
                .setMaxSize(4000)
                .setType(String.class);

    /** jasperReportTemplate (Database column: TEMPLATE_ID - Jasper Report Template ID) */
    static public AttributeDefinition jasperReportTemplate =
        new AttributeDefinition("jasperReportTemplate")
                .setDescription("Jasper Report Template ID")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("JASPER_REPORT_CONFIG")
                .setDatabaseId("TEMPLATE_ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setLovDataClass(pt.digitalis.dif.dem.managers.impl.model.data.JasperReportTemplate.class)
                .setLovDataClassKey("id")
                .setLovDataClassDescription("description")
                .setType(pt.digitalis.dif.dem.managers.impl.model.data.JasperReportTemplate.class);

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(businessId.getName(),businessId);
        map.put(id.getName(),id);
        map.put(parametersValues.getName(),parametersValues);
        map.put(jasperReportTemplate.getName(),jasperReportTemplate);

        return map;
    }
}