package pt.digitalis.dif.dem.managers.impl.model.data;


import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.Session;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.model.utils.IBeanAttributesDataSet;

/**
 * JasperReportTemplate
* Generated on ORM Generator
* DIF build process for the Model layer
*
*/
@SuppressWarnings("serial")
public class JasperReportTemplate extends AbstractBeanRelationsAttributes implements java.io.Serializable, IBeanAttributesDataSet<JasperReportTemplate> {

    /** JasperReportTemplate attributes enumeration */
    public static class Fields
    {
        /** id column */
        public static final String ID ="id";
        /** configId column */
        public static final String CONFIGID ="configId";
        /** businessId column */
        public static final String BUSINESSID ="businessId";
        /** title column */
        public static final String TITLE ="title";
        /** description column */
        public static final String DESCRIPTION ="description";
        /** type column */
        public static final String TYPE ="type";
        /** templatePath column */
        public static final String TEMPLATEPATH ="templatePath";
        /** isEnabled column */
        public static final String ISENABLED ="isEnabled";
        /** logExecution column */
        public static final String LOGEXECUTION ="logExecution";
        /** logFileResult column */
        public static final String LOGFILERESULT ="logFileResult";

        /**
         * List of existing fields
         *
         * @return list of field names
         */
        public static List<String> values()
        {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("configId");
            list.add("businessId");
            list.add("title");
            list.add("description");
            list.add("type");
            list.add("templatePath");
            list.add("isEnabled");
            list.add("logExecution");
            list.add("logFileResult");

            return list;
        }
    }

    /** Field attributes */
    public static JasperReportTemplateFieldAttributes FieldAttributes=new JasperReportTemplateFieldAttributes();

    /**
    * @return the field attributes definitions
    */
    @Override public JasperReportTemplateFieldAttributes getDefinitions()
    {
        return FieldAttributes;
    }

    /**
     * The Class Relations.
     */
    public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations
    {

        /**
        * Instantiates a new relations.
        *
        * @param currentPath the current path
        */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * jasperReportTemplateFile relation.
         *
         * @return the jasperReportTemplateFile bean relations attributes.
         */
        public JasperReportTemplateFile.Relations jasperReportTemplateFile()
        {
            JasperReportTemplateFile c = new JasperReportTemplateFile();
            return c.new Relations(this.buildPath("jasperReportTemplateFile"));
        }

        /**
         * jasperReportTemplateFiles relation.
         *
         * @return the jasperReportTemplateFiles bean relations attributes.
         */
        public JasperReportTemplateFile.Relations jasperReportTemplateFiles()
        {
            JasperReportTemplateFile c = new JasperReportTemplateFile();
            return c.new Relations(this.buildPath("jasperReportTemplateFiles"));
        }

        /**
         * jasperReportLogs relation.
         *
         * @return the jasperReportLogs bean relations attributes.
         */
        public JasperReportLog.Relations jasperReportLogs()
        {
            JasperReportLog c = new JasperReportLog();
            return c.new Relations(this.buildPath("jasperReportLogs"));
        }

        /**
         * jasperReportTemplateParams relation.
         *
         * @return the jasperReportTemplateParams bean relations attributes.
         */
        public JasperReportTemplateParam.Relations jasperReportTemplateParams()
        {
            JasperReportTemplateParam c = new JasperReportTemplateParam();
            return c.new Relations(this.buildPath("jasperReportTemplateParams"));
        }

        /**
         * jasperReportConfigs relation.
         *
         * @return the jasperReportConfigs bean relations attributes.
         */
        public JasperReportConfig.Relations jasperReportConfigs()
        {
            JasperReportConfig c = new JasperReportConfig();
            return c.new Relations(this.buildPath("jasperReportConfigs"));
        }

        /**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
        /**
         * the CONFIGID path.
         *
         * @return the path
         */
        public String CONFIGID()
        {
            return buildPath(Fields.CONFIGID);
        }
        /**
         * the BUSINESSID path.
         *
         * @return the path
         */
        public String BUSINESSID()
        {
            return buildPath(Fields.BUSINESSID);
        }
        /**
         * the TITLE path.
         *
         * @return the path
         */
        public String TITLE()
        {
            return buildPath(Fields.TITLE);
        }
        /**
         * the DESCRIPTION path.
         *
         * @return the path
         */
        public String DESCRIPTION()
        {
            return buildPath(Fields.DESCRIPTION);
        }
        /**
         * the TYPE path.
         *
         * @return the path
         */
        public String TYPE()
        {
            return buildPath(Fields.TYPE);
        }
        /**
         * the TEMPLATEPATH path.
         *
         * @return the path
         */
        public String TEMPLATEPATH()
        {
            return buildPath(Fields.TEMPLATEPATH);
        }
        /**
         * the ISENABLED path.
         *
         * @return the path
         */
        public String ISENABLED()
        {
            return buildPath(Fields.ISENABLED);
        }
        /**
         * the LOGEXECUTION path.
         *
         * @return the path
         */
        public String LOGEXECUTION()
        {
            return buildPath(Fields.LOGEXECUTION);
        }
        /**
         * the LOGFILERESULT path.
         *
         * @return the path
         */
        public String LOGFILERESULT()
        {
            return buildPath(Fields.LOGFILERESULT);
        }
    }

    /** The dummy obj. */
    private static JasperReportTemplate dummyObj=new JasperReportTemplate();

    /**
     * Get JasperReportTemplate Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public IDataSet<JasperReportTemplate> getDataSet()
    {
        return new HibernateDataSet<JasperReportTemplate>(JasperReportTemplate.class, HibernateUtil.getSessionFactory("DIFRepository"),
            JasperReportTemplate.getPKFieldListAsString(), JasperReportTemplate.FieldAttributes);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public static IDataSet<JasperReportTemplate> getDataSetInstance()
    {
        return new JasperReportTemplate().getDataSet();
    }

    /**
    * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
    */
    @Override protected Object getAttributeNoGraphNavigation(String attributeName)
    {
        if("id".equalsIgnoreCase(attributeName))
            return id;
        if("jasperReportTemplateFile".equalsIgnoreCase(attributeName))
            return jasperReportTemplateFile;
        if("configId".equalsIgnoreCase(attributeName))
            return configId;
        if("businessId".equalsIgnoreCase(attributeName))
            return businessId;
        if("title".equalsIgnoreCase(attributeName))
            return title;
        if("description".equalsIgnoreCase(attributeName))
            return description;
        if("type".equalsIgnoreCase(attributeName))
            return type;
        if("templatePath".equalsIgnoreCase(attributeName))
            return templatePath;
        if("isEnabled".equalsIgnoreCase(attributeName))
            return isEnabled;
        if("logExecution".equalsIgnoreCase(attributeName))
            return logExecution;
        if("logFileResult".equalsIgnoreCase(attributeName))
            return logFileResult;
        if("jasperReportTemplateFiles".equalsIgnoreCase(attributeName))
            return jasperReportTemplateFiles;
        if("jasperReportLogs".equalsIgnoreCase(attributeName))
            return jasperReportLogs;
        if("jasperReportTemplateParams".equalsIgnoreCase(attributeName))
            return jasperReportTemplateParams;
        if("jasperReportConfigs".equalsIgnoreCase(attributeName))
            return jasperReportConfigs;

        return null;
    }

    /**
    * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
    */
    public void setAttribute(String attributeName,Object attributeValue)
    {
        if("id".equalsIgnoreCase(attributeName))
            id =(Long)attributeValue;
        if("jasperReportTemplateFile".equalsIgnoreCase(attributeName))
            jasperReportTemplateFile =(JasperReportTemplateFile)attributeValue;
        if("configId".equalsIgnoreCase(attributeName))
            configId =(String)attributeValue;
        if("businessId".equalsIgnoreCase(attributeName))
            businessId =(String)attributeValue;
        if("title".equalsIgnoreCase(attributeName))
            title =(String)attributeValue;
        if("description".equalsIgnoreCase(attributeName))
            description =(String)attributeValue;
        if("type".equalsIgnoreCase(attributeName))
            type =(Long)attributeValue;
        if("templatePath".equalsIgnoreCase(attributeName))
            templatePath =(String)attributeValue;
        if("isEnabled".equalsIgnoreCase(attributeName))
            isEnabled =(Boolean)attributeValue;
        if("logExecution".equalsIgnoreCase(attributeName))
            logExecution =(Boolean)attributeValue;
        if("logFileResult".equalsIgnoreCase(attributeName))
            logFileResult =(Boolean)attributeValue;
        if("jasperReportTemplateFiles".equalsIgnoreCase(attributeName))
            jasperReportTemplateFiles =(Set<JasperReportTemplateFile>)attributeValue;
        if("jasperReportLogs".equalsIgnoreCase(attributeName))
            jasperReportLogs =(Set<JasperReportLog>)attributeValue;
        if("jasperReportTemplateParams".equalsIgnoreCase(attributeName))
            jasperReportTemplateParams =(Set<JasperReportTemplateParam>)attributeValue;
        if("jasperReportConfigs".equalsIgnoreCase(attributeName))
            jasperReportConfigs =(Set<JasperReportConfig>)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** jasperReportTemplateFile private attribute */
    private JasperReportTemplateFile jasperReportTemplateFile;

    /** configId private attribute */
    private String configId;

    /** businessId private attribute */
    private String businessId;

    /** title private attribute */
    private String title;

    /** description private attribute */
    private String description;

    /** type private attribute */
    private Long type;

    /** templatePath private attribute */
    private String templatePath;

    /** isEnabled private attribute */
    private boolean isEnabled;

    /** logExecution private attribute */
    private boolean logExecution;

    /** logFileResult private attribute */
    private boolean logFileResult;

    /** jasperReportTemplateFiles private attribute */
    private Set<JasperReportTemplateFile> jasperReportTemplateFiles = new HashSet<JasperReportTemplateFile>(0);

    /** jasperReportLogs private attribute */
    private Set<JasperReportLog> jasperReportLogs = new HashSet<JasperReportLog>(0);

    /** jasperReportTemplateParams private attribute */
    private Set<JasperReportTemplateParam> jasperReportTemplateParams = new HashSet<JasperReportTemplateParam>(0);

    /** jasperReportConfigs private attribute */
    private Set<JasperReportConfig> jasperReportConfigs = new HashSet<JasperReportConfig>(0);

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {

        Object value = getAttribute(attributeName);

        if (value == null)
            return "";
        else {
            return value.toString().trim();
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public JasperReportTemplate() {
    }

	/** 
	 * minimal constructor
	 *
     * @param configId the configId
     * @param title the title
     * @param type the type
     * @param isEnabled the isEnabled
     * @param logExecution the logExecution
     * @param logFileResult the logFileResult
    }
	 */
    public JasperReportTemplate(String configId, String title, Long type, boolean isEnabled, boolean logExecution, boolean logFileResult) {
        this.configId = configId;
        this.title = title;
        this.type = type;
        this.isEnabled = isEnabled;
        this.logExecution = logExecution;
        this.logFileResult = logFileResult;
    }

    /**
     * full constructor
	 *
     * @param jasperReportTemplateFile the jasperReportTemplateFile
     * @param configId the configId
     * @param businessId the businessId
     * @param title the title
     * @param description the description
     * @param type the type
     * @param templatePath the templatePath
     * @param isEnabled the isEnabled
     * @param logExecution the logExecution
     * @param logFileResult the logFileResult
     * @param jasperReportTemplateFiles the jasperReportTemplateFiles
     * @param jasperReportLogs the jasperReportLogs
     * @param jasperReportTemplateParams the jasperReportTemplateParams
     * @param jasperReportConfigs the jasperReportConfigs
     */
    public JasperReportTemplate(JasperReportTemplateFile jasperReportTemplateFile, String configId, String businessId, String title, String description, Long type, String templatePath, boolean isEnabled, boolean logExecution, boolean logFileResult, Set<JasperReportTemplateFile> jasperReportTemplateFiles, Set<JasperReportLog> jasperReportLogs, Set<JasperReportTemplateParam> jasperReportTemplateParams, Set<JasperReportConfig> jasperReportConfigs) {
        this.jasperReportTemplateFile = jasperReportTemplateFile;
        this.configId = configId;
        this.businessId = businessId;
        this.title = title;
        this.description = description;
        this.type = type;
        this.templatePath = templatePath;
        this.isEnabled = isEnabled;
        this.logExecution = logExecution;
        this.logFileResult = logFileResult;
        this.jasperReportTemplateFiles = jasperReportTemplateFiles;
        this.jasperReportLogs = jasperReportLogs;
        this.jasperReportTemplateParams = jasperReportTemplateParams;
        this.jasperReportConfigs = jasperReportConfigs;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id the id
     *
     * @return JasperReportTemplate modified instance
     */
    public JasperReportTemplate setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * jasperReportTemplateFile getter method
     *
     * @return jasperReportTemplateFile method
     */
    public JasperReportTemplateFile getJasperReportTemplateFile() {
        return this.jasperReportTemplateFile;
    }
    
    /**       
     * jasperReportTemplateFile setter method
     *
     * @param jasperReportTemplateFile the jasperReportTemplateFile
     *
     * @return JasperReportTemplate modified instance
     */
    public JasperReportTemplate setJasperReportTemplateFile(JasperReportTemplateFile jasperReportTemplateFile) {
        this.jasperReportTemplateFile = jasperReportTemplateFile;
        
        return this;
    }
    /**       
     * configId getter method
     *
     * @return configId method
     */
    public String getConfigId() {
        return this.configId;
    }
    
    /**       
     * configId setter method
     *
     * @param configId the configId
     *
     * @return JasperReportTemplate modified instance
     */
    public JasperReportTemplate setConfigId(String configId) {
        this.configId = configId;
        
        return this;
    }
    /**       
     * businessId getter method
     *
     * @return businessId method
     */
    public String getBusinessId() {
        return this.businessId;
    }
    
    /**       
     * businessId setter method
     *
     * @param businessId the businessId
     *
     * @return JasperReportTemplate modified instance
     */
    public JasperReportTemplate setBusinessId(String businessId) {
        this.businessId = businessId;
        
        return this;
    }
    /**       
     * title getter method
     *
     * @return title method
     */
    public String getTitle() {
        return this.title;
    }
    
    /**       
     * title setter method
     *
     * @param title the title
     *
     * @return JasperReportTemplate modified instance
     */
    public JasperReportTemplate setTitle(String title) {
        this.title = title;
        
        return this;
    }
    /**       
     * description getter method
     *
     * @return description method
     */
    public String getDescription() {
        return this.description;
    }
    
    /**       
     * description setter method
     *
     * @param description the description
     *
     * @return JasperReportTemplate modified instance
     */
    public JasperReportTemplate setDescription(String description) {
        this.description = description;
        
        return this;
    }
    /**       
     * type getter method
     *
     * @return type method
     */
    public Long getType() {
        return this.type;
    }
    
    /**       
     * type setter method
     *
     * @param type the type
     *
     * @return JasperReportTemplate modified instance
     */
    public JasperReportTemplate setType(Long type) {
        this.type = type;
        
        return this;
    }
    /**       
     * templatePath getter method
     *
     * @return templatePath method
     */
    public String getTemplatePath() {
        return this.templatePath;
    }
    
    /**       
     * templatePath setter method
     *
     * @param templatePath the templatePath
     *
     * @return JasperReportTemplate modified instance
     */
    public JasperReportTemplate setTemplatePath(String templatePath) {
        this.templatePath = templatePath;
        
        return this;
    }
    /**       
     * isEnabled getter method
     *
     * @return isEnabled method
     */
    public boolean isIsEnabled() {
        return this.isEnabled;
    }
    
    /**       
     * isEnabled setter method
     *
     * @param isEnabled the isEnabled
     *
     * @return JasperReportTemplate modified instance
     */
    public JasperReportTemplate setIsEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
        
        return this;
    }
    /**       
     * logExecution getter method
     *
     * @return logExecution method
     */
    public boolean isLogExecution() {
        return this.logExecution;
    }
    
    /**       
     * logExecution setter method
     *
     * @param logExecution the logExecution
     *
     * @return JasperReportTemplate modified instance
     */
    public JasperReportTemplate setLogExecution(boolean logExecution) {
        this.logExecution = logExecution;
        
        return this;
    }
    /**       
     * logFileResult getter method
     *
     * @return logFileResult method
     */
    public boolean isLogFileResult() {
        return this.logFileResult;
    }
    
    /**       
     * logFileResult setter method
     *
     * @param logFileResult the logFileResult
     *
     * @return JasperReportTemplate modified instance
     */
    public JasperReportTemplate setLogFileResult(boolean logFileResult) {
        this.logFileResult = logFileResult;
        
        return this;
    }
    /**       
     * jasperReportTemplateFiles getter method
     *
     * @return jasperReportTemplateFiles method
     */
    public Set<JasperReportTemplateFile> getJasperReportTemplateFiles() {
        return this.jasperReportTemplateFiles;
    }
    
    /**       
     * jasperReportTemplateFiles setter method
     *
     * @param jasperReportTemplateFiles the jasperReportTemplateFiles
     *
     * @return JasperReportTemplate modified instance
     */
    public JasperReportTemplate setJasperReportTemplateFiles(Set<JasperReportTemplateFile> jasperReportTemplateFiles) {
        this.jasperReportTemplateFiles = jasperReportTemplateFiles;
        
        return this;
    }
    /**       
     * jasperReportLogs getter method
     *
     * @return jasperReportLogs method
     */
    public Set<JasperReportLog> getJasperReportLogs() {
        return this.jasperReportLogs;
    }
    
    /**       
     * jasperReportLogs setter method
     *
     * @param jasperReportLogs the jasperReportLogs
     *
     * @return JasperReportTemplate modified instance
     */
    public JasperReportTemplate setJasperReportLogs(Set<JasperReportLog> jasperReportLogs) {
        this.jasperReportLogs = jasperReportLogs;
        
        return this;
    }
    /**       
     * jasperReportTemplateParams getter method
     *
     * @return jasperReportTemplateParams method
     */
    public Set<JasperReportTemplateParam> getJasperReportTemplateParams() {
        return this.jasperReportTemplateParams;
    }
    
    /**       
     * jasperReportTemplateParams setter method
     *
     * @param jasperReportTemplateParams the jasperReportTemplateParams
     *
     * @return JasperReportTemplate modified instance
     */
    public JasperReportTemplate setJasperReportTemplateParams(Set<JasperReportTemplateParam> jasperReportTemplateParams) {
        this.jasperReportTemplateParams = jasperReportTemplateParams;
        
        return this;
    }
    /**       
     * jasperReportConfigs getter method
     *
     * @return jasperReportConfigs method
     */
    public Set<JasperReportConfig> getJasperReportConfigs() {
        return this.jasperReportConfigs;
    }
    
    /**       
     * jasperReportConfigs setter method
     *
     * @param jasperReportConfigs the jasperReportConfigs
     *
     * @return JasperReportTemplate modified instance
     */
    public JasperReportTemplate setJasperReportConfigs(Set<JasperReportConfig> jasperReportConfigs) {
        this.jasperReportConfigs = jasperReportConfigs;
        
        return this;
    }

    /**
     * Creates a String representation of the JasperReportTemplate object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("configId").append("='").append(getConfigId()).append("' ");			
        buffer.append("businessId").append("='").append(getBusinessId()).append("' ");			
        buffer.append("title").append("='").append(getTitle()).append("' ");			
        buffer.append("description").append("='").append(getDescription()).append("' ");			
        buffer.append("type").append("='").append(getType()).append("' ");			
        buffer.append("templatePath").append("='").append(getTemplatePath()).append("' ");			
        buffer.append("isEnabled").append("='").append(isIsEnabled()).append("' ");			
        buffer.append("logExecution").append("='").append(isLogExecution()).append("' ");			
        buffer.append("logFileResult").append("='").append(isLogFileResult()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the JasperReportTemplate object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(JasperReportTemplate other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("configId".equalsIgnoreCase(attributeName))
        	this.configId = attributeValue;

        if ("businessId".equalsIgnoreCase(attributeName))
        	this.businessId = attributeValue;

        if ("title".equalsIgnoreCase(attributeName))
        	this.title = attributeValue;

        if ("description".equalsIgnoreCase(attributeName))
        	this.description = attributeValue;

        if ("type".equalsIgnoreCase(attributeName))
            this.type = Long.valueOf(attributeValue);

        if ("templatePath".equalsIgnoreCase(attributeName))
        	this.templatePath = attributeValue;

        if ("isEnabled".equalsIgnoreCase(attributeName))
            this.isEnabled = Boolean.valueOf(attributeValue);

        if ("logExecution".equalsIgnoreCase(attributeName))
            this.logExecution = Boolean.valueOf(attributeValue);

        if ("logFileResult".equalsIgnoreCase(attributeName))
            this.logFileResult = Boolean.valueOf(attributeValue);

    }


    /**
     * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
     *
     * @param session the session
     * @param id      the id
     *
     * @return the proxy
     */
    public static JasperReportTemplate getProxy(Session session, Long id)
    {
        return(JasperReportTemplate)session.load(JasperReportTemplate.class,id);
    }

    /**
    * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
    *
    * @param id      the id
    *
    * @return the proxy
    */
    public static JasperReportTemplate getProxy(Long id)
    {
        Session session = HibernateUtil.getSessionFactory("DIFRepository").getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        JasperReportTemplate result = (JasperReportTemplate)session.load(JasperReportTemplate.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }


    /**
     * Instanciates an Hibernate data object
     *
     * @param session the session
     * @param id      the id
     *
     * @return the instance
     */
    public static JasperReportTemplate getInstance(Session session, Long id)
    {
        return(JasperReportTemplate)session.get(JasperReportTemplate.class,id);
    }

    /**
    * Instanciates an Hibernate data object
    *
    * @param id      the id
    *
    * @return the instance
    */
    public static JasperReportTemplate getInstance(Long id)
    {
        Session session = HibernateUtil.getSessionFactory("DIFRepository").getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        JasperReportTemplate result = (JasperReportTemplate)session.get(JasperReportTemplate.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }

}
