package pt.digitalis.dif.dem.managers.impl.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link JasperReportTemplateFile}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class JasperReportTemplateFileFieldAttributes extends AbstractBeanAttributesDefinition{

    /** documentId (Database column: DOCUMENT_ID - The document in the documento repository ID) */
    static public AttributeDefinition documentId =
        new AttributeDefinition("documentId")
                .setDescription("The document in the documento repository ID")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("JASPER_REPORT_TEMPLATE_FILE")
                .setDatabaseId("DOCUMENT_ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(Long.class);

    /** fileName (Database column: FILE_NAME - The file name) */
    static public AttributeDefinition fileName =
        new AttributeDefinition("fileName")
                .setDescription("The file name")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("JASPER_REPORT_TEMPLATE_FILE")
                .setDatabaseId("FILE_NAME")
                .setMandatory(true)
                .setMaxSize(1500)
                .setType(String.class);

    /** fileSize (Database column: FILE_SIZE - The file size) */
    static public AttributeDefinition fileSize =
        new AttributeDefinition("fileSize")
                .setDescription("The file size")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("JASPER_REPORT_TEMPLATE_FILE")
                .setDatabaseId("FILE_SIZE")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(Long.class);

    /** fileType (Database column: FILE_TYPE - The file type (mime type)) */
    static public AttributeDefinition fileType =
        new AttributeDefinition("fileType")
                .setDescription("The file type (mime type)")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("JASPER_REPORT_TEMPLATE_FILE")
                .setDatabaseId("FILE_TYPE")
                .setMandatory(true)
                .setMaxSize(50)
                .setType(String.class);

    /** id (Database column: ID - ID) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDescription("ID")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("JASPER_REPORT_TEMPLATE_FILE")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(Long.class);

    /** jasperReportTemplate (Database column: TEMPLATE_ID - The template the file belongs to) */
    static public AttributeDefinition jasperReportTemplate =
        new AttributeDefinition("jasperReportTemplate")
                .setDescription("The template the file belongs to")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("JASPER_REPORT_TEMPLATE_FILE")
                .setDatabaseId("TEMPLATE_ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setLovDataClass(pt.digitalis.dif.dem.managers.impl.model.data.JasperReportTemplate.class)
                .setLovDataClassKey("id")
                .setLovDataClassDescription("description")
                .setType(pt.digitalis.dif.dem.managers.impl.model.data.JasperReportTemplate.class);

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(documentId.getName(),documentId);
        map.put(fileName.getName(),fileName);
        map.put(fileSize.getName(),fileSize);
        map.put(fileType.getName(),fileType);
        map.put(id.getName(),id);
        map.put(jasperReportTemplate.getName(),jasperReportTemplate);

        return map;
    }
}