package pt.digitalis.dif.dem.managers.impl.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link PersistentForm}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class PersistentFormFieldAttributes extends AbstractBeanAttributesDefinition{

    /** disabledFields (Database column: DISABLED_FIELDS - List of form fields disabled (comma separated)) */
    static public AttributeDefinition disabledFields =
        new AttributeDefinition("disabledFields")
                .setDescription("List of form fields disabled (comma separated)")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("PERSISTENT_FORM")
                .setDatabaseId("DISABLED_FIELDS")
                .setMandatory(true)
                .setMaxSize(4000)
                .setType(String.class);

    /** fieldDefs (Database column: FIELD_DEFS - List of form fields with their custom definitions ({fieldID1:{mandatory:ON/OFF,messages{language:en{label:A,hint:B,help:C}}})) */
    static public AttributeDefinition fieldDefs =
        new AttributeDefinition("fieldDefs")
                .setDescription("List of form fields with their custom definitions ({fieldID1:{mandatory:ON/OFF,messages{language:en{label:A,hint:B,help:C}}})")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("PERSISTENT_FORM")
                .setDatabaseId("FIELD_DEFS")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(String.class);

    /** formId (Database column: FORM_ID - Form unique identifier (stageID:formName[:businessID])) */
    static public AttributeDefinition formId =
        new AttributeDefinition("formId")
                .setDescription("Form unique identifier (stageID:formName[:businessID])")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("PERSISTENT_FORM")
                .setDatabaseId("FORM_ID")
                .setMandatory(true)
                .setMaxSize(500)
                .setType(String.class);

    /** id (Database column: ID - Unique identifier for PK) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDescription("Unique identifier for PK")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("PERSISTENT_FORM")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(Long.class);

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(disabledFields.getName(),disabledFields);
        map.put(fieldDefs.getName(),fieldDefs);
        map.put(formId.getName(),formId);
        map.put(id.getName(),id);

        return map;
    }
}