package pt.digitalis.dif.dem.managers.impl.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link ReportInstanceAreaTrans}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class ReportInstanceAreaTransFieldAttributes extends AbstractBeanAttributesDefinition{

    /** content (Database column: CONTENT - the content) */
    static public AttributeDefinition content =
        new AttributeDefinition("content")
                .setDescription("the content")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("REPORT_INSTANCE_AREA_TRANS")
                .setDatabaseId("CONTENT")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(String.class);

    /** id (Database column: ID - ID column) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDescription("ID column")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("REPORT_INSTANCE_AREA_TRANS")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(Long.class);

    /** language (Database column: LANGUAGE - the language) */
    static public AttributeDefinition language =
        new AttributeDefinition("language")
                .setDescription("the language")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("REPORT_INSTANCE_AREA_TRANS")
                .setDatabaseId("LANGUAGE")
                .setMandatory(true)
                .setMaxSize(2)
                .setType(String.class);

    /** reportInstanceArea (Database column: REPORT_INSTANCE_AREA_ID - The parent area ID) */
    static public AttributeDefinition reportInstanceArea =
        new AttributeDefinition("reportInstanceArea")
                .setDescription("The parent area ID")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("REPORT_INSTANCE_AREA_TRANS")
                .setDatabaseId("REPORT_INSTANCE_AREA_ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setLovDataClass(pt.digitalis.dif.dem.managers.impl.model.data.ReportInstanceArea.class)
                .setLovDataClassKey("id")
                .setType(pt.digitalis.dif.dem.managers.impl.model.data.ReportInstanceArea.class);

    /** title (Database column: TITLE - Area Title) */
    static public AttributeDefinition title =
        new AttributeDefinition("title")
                .setDescription("Area Title")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("REPORT_INSTANCE_AREA_TRANS")
                .setDatabaseId("TITLE")
                .setMandatory(true)
                .setMaxSize(200)
                .setType(String.class);

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(content.getName(),content);
        map.put(id.getName(),id);
        map.put(language.getName(),language);
        map.put(reportInstanceArea.getName(),reportInstanceArea);
        map.put(title.getName(),title);

        return map;
    }
}