package pt.digitalis.dif.dem.managers.impl.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link ReportInstanceDocument}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class ReportInstanceDocumentFieldAttributes extends AbstractBeanAttributesDefinition{

    /** description (Database column: DESCRIPTION - Document description) */
    static public AttributeDefinition description =
        new AttributeDefinition("description")
                .setDescription("Document description")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("REPORT_INSTANCE_DOCUMENT")
                .setDatabaseId("DESCRIPTION")
                .setMandatory(true)
                .setMaxSize(500)
                .setType(String.class);

    /** documentRepositoryId (Database column: DOCUMENT_REPOSITORY_ID - Identifier in the Document repository table) */
    static public AttributeDefinition documentRepositoryId =
        new AttributeDefinition("documentRepositoryId")
                .setDescription("Identifier in the Document repository table")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("REPORT_INSTANCE_DOCUMENT")
                .setDatabaseId("DOCUMENT_REPOSITORY_ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(Long.class);

    /** id (Database column: ID - ID column) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDescription("ID column")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("REPORT_INSTANCE_DOCUMENT")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(Long.class);

    /** publicVisibility (Database column: PUBLIC_VISIBILITY - Defines visibility for the document) */
    static public AttributeDefinition publicVisibility =
        new AttributeDefinition("publicVisibility")
                .setDescription("Defines visibility for the document")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("REPORT_INSTANCE_DOCUMENT")
                .setDatabaseId("PUBLIC_VISIBILITY")
                .setMandatory(true)
                .setMaxSize(1)
                .setType(String.class);

    /** reportInstance (Database column: REPORT_INSTANCE_ID - The parent report ID) */
    static public AttributeDefinition reportInstance =
        new AttributeDefinition("reportInstance")
                .setDescription("The parent report ID")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("REPORT_INSTANCE_DOCUMENT")
                .setDatabaseId("REPORT_INSTANCE_ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setLovDataClass(pt.digitalis.dif.dem.managers.impl.model.data.ReportInstance.class)
                .setLovDataClassKey("id")
                .setType(pt.digitalis.dif.dem.managers.impl.model.data.ReportInstance.class);

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(description.getName(),description);
        map.put(documentRepositoryId.getName(),documentRepositoryId);
        map.put(id.getName(),id);
        map.put(publicVisibility.getName(),publicVisibility);
        map.put(reportInstance.getName(),reportInstance);

        return map;
    }
}