package pt.digitalis.dif.dem.managers.impl.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link ReportInstance}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class ReportInstanceFieldAttributes extends AbstractBeanAttributesDefinition{

    /** businessKey (Database column: BUSINESS_KEY - the business key this instance is associated to) */
    static public AttributeDefinition businessKey =
        new AttributeDefinition("businessKey")
                .setDescription("the business key this instance is associated to")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("REPORT_INSTANCE")
                .setDatabaseId("BUSINESS_KEY")
                .setMandatory(true)
                .setMaxSize(500)
                .setType(String.class);

    /** documentId (Database column: DOCUMENT_ID - the generated report file (document repository ID)) */
    static public AttributeDefinition documentId =
        new AttributeDefinition("documentId")
                .setDescription("the generated report file (document repository ID)")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("REPORT_INSTANCE")
                .setDatabaseId("DOCUMENT_ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(Long.class);

    /** id (Database column: ID - ID column) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDescription("ID column")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("REPORT_INSTANCE")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(Long.class);

    /** readonly (Database column: READONLY - if true this instance if readonly and cannot be changed) */
    static public AttributeDefinition readonly =
        new AttributeDefinition("readonly")
                .setDescription("if true this instance if readonly and cannot be changed")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("REPORT_INSTANCE")
                .setDatabaseId("READONLY")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(boolean.class);

    /** reportTemplate (Database column: REPORT_TEMPLATE_ID - The parent template ID) */
    static public AttributeDefinition reportTemplate =
        new AttributeDefinition("reportTemplate")
                .setDescription("The parent template ID")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("REPORT_INSTANCE")
                .setDatabaseId("REPORT_TEMPLATE_ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setLovDataClass(pt.digitalis.dif.dem.managers.impl.model.data.ReportTemplate.class)
                .setLovDataClassKey("id")
                .setLovDataClassDescription("name")
                .setType(pt.digitalis.dif.dem.managers.impl.model.data.ReportTemplate.class);

    /** title (Database column: TITLE - The instance business title) */
    static public AttributeDefinition title =
        new AttributeDefinition("title")
                .setDescription("The instance business title")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("REPORT_INSTANCE")
                .setDatabaseId("TITLE")
                .setMandatory(true)
                .setMaxSize(200)
                .setType(String.class);

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(businessKey.getName(),businessKey);
        map.put(documentId.getName(),documentId);
        map.put(id.getName(),id);
        map.put(readonly.getName(),readonly);
        map.put(reportTemplate.getName(),reportTemplate);
        map.put(title.getName(),title);

        return map;
    }
}