package pt.digitalis.dif.dem.managers.impl.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link ReportTemplateArea}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class ReportTemplateAreaFieldAttributes extends AbstractBeanAttributesDefinition{

    /** content (Database column: CONTENT - the content) */
    static public AttributeDefinition content =
        new AttributeDefinition("content")
                .setDescription("the content")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("REPORT_TEMPLATE_AREA")
                .setDatabaseId("CONTENT")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(String.class);

    /** customizable (Database column: CUSTOMIZABLE - if the area is customizable in the report instance) */
    static public AttributeDefinition customizable =
        new AttributeDefinition("customizable")
                .setDescription("if the area is customizable in the report instance")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("REPORT_TEMPLATE_AREA")
                .setDatabaseId("CUSTOMIZABLE")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(boolean.class);

    /** customizableProfiles (Database column: CUSTOMIZABLE_PROFILES - the profiles that can customize the report instance area) */
    static public AttributeDefinition customizableProfiles =
        new AttributeDefinition("customizableProfiles")
                .setDescription("the profiles that can customize the report instance area")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("REPORT_TEMPLATE_AREA")
                .setDatabaseId("CUSTOMIZABLE_PROFILES")
                .setMandatory(true)
                .setMaxSize(4000)
                .setType(String.class);

    /** id (Database column: ID - ID column) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDescription("ID column")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("REPORT_TEMPLATE_AREA")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(Long.class);

    /** indicator (Database column: INDICATOR_ID - the indicator id for Chart typed areas) */
    static public AttributeDefinition indicator =
        new AttributeDefinition("indicator")
                .setDescription("the indicator id for Chart typed areas")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("REPORT_TEMPLATE_AREA")
                .setDatabaseId("INDICATOR_ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setLovDataClass(pt.digitalis.dif.dem.managers.impl.model.data.Indicator.class)
                .setLovDataClassKey("id")
                .setLovDataClassDescription("description")
                .setType(pt.digitalis.dif.dem.managers.impl.model.data.Indicator.class);

    /** language (Database column: LANGUAGE - the area content language for jasper areas to take into account when calculating the area context objects that the jasper template uses) */
    static public AttributeDefinition language =
        new AttributeDefinition("language")
                .setDescription("the area content language for jasper areas to take into account when calculating the area context objects that the jasper template uses")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("REPORT_TEMPLATE_AREA")
                .setDatabaseId("LANGUAGE")
                .setMandatory(true)
                .setMaxSize(2)
                .setType(String.class);

    /** mandatory (Database column: MANDATORY - if the area is mandatory in the report instance) */
    static public AttributeDefinition mandatory =
        new AttributeDefinition("mandatory")
                .setDescription("if the area is mandatory in the report instance")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("REPORT_TEMPLATE_AREA")
                .setDatabaseId("MANDATORY")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(boolean.class);

    /** maxSize (Database column: MAX_SIZE - the content max size for html typed areas) */
    static public AttributeDefinition maxSize =
        new AttributeDefinition("maxSize")
                .setDescription("the content max size for html typed areas")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("REPORT_TEMPLATE_AREA")
                .setDatabaseId("MAX_SIZE")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(Long.class);

    /** position (Database column: POSITION - the position of this area in the template) */
    static public AttributeDefinition position =
        new AttributeDefinition("position")
                .setDescription("the position of this area in the template")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("REPORT_TEMPLATE_AREA")
                .setDatabaseId("POSITION")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(Long.class);

    /** private_ (Database column: PRIVATE - is the area is private) */
    static public AttributeDefinition private_ =
        new AttributeDefinition("private_")
                .setDescription("is the area is private")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("REPORT_TEMPLATE_AREA")
                .setDatabaseId("PRIVATE")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(boolean.class);

    /** reportTemplate (Database column: REPORT_TEMPLATE_ID - The parent template ID) */
    static public AttributeDefinition reportTemplate =
        new AttributeDefinition("reportTemplate")
                .setDescription("The parent template ID")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("REPORT_TEMPLATE_AREA")
                .setDatabaseId("REPORT_TEMPLATE_ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setLovDataClass(pt.digitalis.dif.dem.managers.impl.model.data.ReportTemplate.class)
                .setLovDataClassKey("id")
                .setLovDataClassDescription("name")
                .setType(pt.digitalis.dif.dem.managers.impl.model.data.ReportTemplate.class);

    /** showTitle (Database column: SHOW_TITLE - if true show the area title) */
    static public AttributeDefinition showTitle =
        new AttributeDefinition("showTitle")
                .setDescription("if true show the area title")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("REPORT_TEMPLATE_AREA")
                .setDatabaseId("SHOW_TITLE")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(boolean.class);

    /** title (Database column: TITLE - The area title) */
    static public AttributeDefinition title =
        new AttributeDefinition("title")
                .setDescription("The area title")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("REPORT_TEMPLATE_AREA")
                .setDatabaseId("TITLE")
                .setMandatory(true)
                .setMaxSize(200)
                .setType(String.class);

    /** type (Database column: TYPE - the area type) */
    static public AttributeDefinition type =
        new AttributeDefinition("type")
                .setDescription("the area type")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("REPORT_TEMPLATE_AREA")
                .setDatabaseId("TYPE")
                .setMandatory(true)
                .setMaxSize(10)
                .setType(String.class);

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(content.getName(),content);
        map.put(customizable.getName(),customizable);
        map.put(customizableProfiles.getName(),customizableProfiles);
        map.put(id.getName(),id);
        map.put(indicator.getName(),indicator);
        map.put(language.getName(),language);
        map.put(mandatory.getName(),mandatory);
        map.put(maxSize.getName(),maxSize);
        map.put(position.getName(),position);
        map.put(private_.getName(),private_);
        map.put(reportTemplate.getName(),reportTemplate);
        map.put(showTitle.getName(),showTitle);
        map.put(title.getName(),title);
        map.put(type.getName(),type);

        return map;
    }
}