package pt.digitalis.dif.dem.managers.impl.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link Serie}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class SerieFieldAttributes extends AbstractBeanAttributesDefinition{

    /** description (Database column: DESCRIPTION - The serie description) */
    static public AttributeDefinition description =
        new AttributeDefinition("description")
                .setDescription("The serie description")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("SERIE")
                .setDatabaseId("DESCRIPTION")
                .setMandatory(true)
                .setMaxSize(4000)
                .setType(String.class);

    /** id (Database column: ID - ID column) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDescription("ID column")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("SERIE")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(Long.class);

    /** indicator (Database column: INDICATOR_ID - The parent indicator ID) */
    static public AttributeDefinition indicator =
        new AttributeDefinition("indicator")
                .setDescription("The parent indicator ID")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("SERIE")
                .setDatabaseId("INDICATOR_ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setLovDataClass(pt.digitalis.dif.dem.managers.impl.model.data.Indicator.class)
                .setLovDataClassKey("id")
                .setLovDataClassDescription("description")
                .setType(pt.digitalis.dif.dem.managers.impl.model.data.Indicator.class);

    /** type (Database column: TYPE - The serie type) */
    static public AttributeDefinition type =
        new AttributeDefinition("type")
                .setDescription("The serie type")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("SERIE")
                .setDatabaseId("TYPE")
                .setMandatory(true)
                .setMaxSize(1)
                .setDefaultValue("C")
                .setType(Character.class);

    /** unitName (Database column: UNIT_NAME - The serie data unit name) */
    static public AttributeDefinition unitName =
        new AttributeDefinition("unitName")
                .setDescription("The serie data unit name")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("SERIE")
                .setDatabaseId("UNIT_NAME")
                .setMandatory(true)
                .setMaxSize(500)
                .setType(String.class);

    /** valueField (Database column: VALUE_FIELD - The field that has the value for this sirie) */
    static public AttributeDefinition valueField =
        new AttributeDefinition("valueField")
                .setDescription("The field that has the value for this sirie")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("SERIE")
                .setDatabaseId("VALUE_FIELD")
                .setMandatory(true)
                .setMaxSize(200)
                .setType(String.class);

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(description.getName(),description);
        map.put(id.getName(),id);
        map.put(indicator.getName(),indicator);
        map.put(type.getName(),type);
        map.put(unitName.getName(),unitName);
        map.put(valueField.getName(),valueField);

        return map;
    }
}