package pt.digitalis.dif.dem.managers.impl.model.data;


import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.Session;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.model.utils.IBeanAttributesDataSet;

/**
 * Server
* Generated on ORM Generator
* DIF build process for the Model layer
*
*/
@SuppressWarnings("serial")
public class Server extends AbstractBeanRelationsAttributes implements java.io.Serializable, IBeanAttributesDataSet<Server> {

    /** Server attributes enumeration */
    public static class Fields
    {
        /** id column */
        public static final String ID ="id";
        /** name column */
        public static final String NAME ="name";
        /** machineServerUid column */
        public static final String MACHINESERVERUID ="machineServerUid";
        /** ipAddress column */
        public static final String IPADDRESS ="ipAddress";
        /** contextRoot column */
        public static final String CONTEXTROOT ="contextRoot";
        /** port column */
        public static final String PORT ="port";
        /** endpointBaseUrl column */
        public static final String ENDPOINTBASEURL ="endpointBaseUrl";
        /** bootTime column */
        public static final String BOOTTIME ="bootTime";
        /** lastSync column */
        public static final String LASTSYNC ="lastSync";
        /** active column */
        public static final String ACTIVE ="active";
        /** missing column */
        public static final String MISSING ="missing";

        /**
         * List of existing fields
         *
         * @return list of field names
         */
        public static List<String> values()
        {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("name");
            list.add("machineServerUid");
            list.add("ipAddress");
            list.add("contextRoot");
            list.add("port");
            list.add("endpointBaseUrl");
            list.add("bootTime");
            list.add("lastSync");
            list.add("active");
            list.add("missing");

            return list;
        }
    }

    /** Field attributes */
    public static ServerFieldAttributes FieldAttributes=new ServerFieldAttributes();

    /**
    * @return the field attributes definitions
    */
    @Override public ServerFieldAttributes getDefinitions()
    {
        return FieldAttributes;
    }

    /**
     * The Class Relations.
     */
    public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations
    {

        /**
        * Instantiates a new relations.
        *
        * @param currentPath the current path
        */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * serverMessagesForServerReceiverId relation.
         *
         * @return the serverMessagesForServerReceiverId bean relations attributes.
         */
        public ServerMessage.Relations serverMessagesForServerReceiverId()
        {
            ServerMessage c = new ServerMessage();
            return c.new Relations(this.buildPath("serverMessagesForServerReceiverId"));
        }

        /**
         * serverActivityLogs relation.
         *
         * @return the serverActivityLogs bean relations attributes.
         */
        public ServerActivityLog.Relations serverActivityLogs()
        {
            ServerActivityLog c = new ServerActivityLog();
            return c.new Relations(this.buildPath("serverActivityLogs"));
        }

        /**
         * serverMessagesForServerSenderId relation.
         *
         * @return the serverMessagesForServerSenderId bean relations attributes.
         */
        public ServerMessage.Relations serverMessagesForServerSenderId()
        {
            ServerMessage c = new ServerMessage();
            return c.new Relations(this.buildPath("serverMessagesForServerSenderId"));
        }

        /**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
        /**
         * the NAME path.
         *
         * @return the path
         */
        public String NAME()
        {
            return buildPath(Fields.NAME);
        }
        /**
         * the MACHINESERVERUID path.
         *
         * @return the path
         */
        public String MACHINESERVERUID()
        {
            return buildPath(Fields.MACHINESERVERUID);
        }
        /**
         * the IPADDRESS path.
         *
         * @return the path
         */
        public String IPADDRESS()
        {
            return buildPath(Fields.IPADDRESS);
        }
        /**
         * the CONTEXTROOT path.
         *
         * @return the path
         */
        public String CONTEXTROOT()
        {
            return buildPath(Fields.CONTEXTROOT);
        }
        /**
         * the PORT path.
         *
         * @return the path
         */
        public String PORT()
        {
            return buildPath(Fields.PORT);
        }
        /**
         * the ENDPOINTBASEURL path.
         *
         * @return the path
         */
        public String ENDPOINTBASEURL()
        {
            return buildPath(Fields.ENDPOINTBASEURL);
        }
        /**
         * the BOOTTIME path.
         *
         * @return the path
         */
        public String BOOTTIME()
        {
            return buildPath(Fields.BOOTTIME);
        }
        /**
         * the LASTSYNC path.
         *
         * @return the path
         */
        public String LASTSYNC()
        {
            return buildPath(Fields.LASTSYNC);
        }
        /**
         * the ACTIVE path.
         *
         * @return the path
         */
        public String ACTIVE()
        {
            return buildPath(Fields.ACTIVE);
        }
        /**
         * the MISSING path.
         *
         * @return the path
         */
        public String MISSING()
        {
            return buildPath(Fields.MISSING);
        }
    }

    /** The dummy obj. */
    private static Server dummyObj=new Server();

    /**
     * Get Server Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public IDataSet<Server> getDataSet()
    {
        return new HibernateDataSet<Server>(Server.class, HibernateUtil.getSessionFactory("DIFRepository"),
            Server.getPKFieldListAsString(), Server.FieldAttributes);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public static IDataSet<Server> getDataSetInstance()
    {
        return new Server().getDataSet();
    }

    /**
    * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
    */
    @Override protected Object getAttributeNoGraphNavigation(String attributeName)
    {
        if("id".equalsIgnoreCase(attributeName))
            return id;
        if("name".equalsIgnoreCase(attributeName))
            return name;
        if("machineServerUid".equalsIgnoreCase(attributeName))
            return machineServerUid;
        if("ipAddress".equalsIgnoreCase(attributeName))
            return ipAddress;
        if("contextRoot".equalsIgnoreCase(attributeName))
            return contextRoot;
        if("port".equalsIgnoreCase(attributeName))
            return port;
        if("endpointBaseUrl".equalsIgnoreCase(attributeName))
            return endpointBaseUrl;
        if("bootTime".equalsIgnoreCase(attributeName))
            return bootTime;
        if("lastSync".equalsIgnoreCase(attributeName))
            return lastSync;
        if("active".equalsIgnoreCase(attributeName))
            return active;
        if("missing".equalsIgnoreCase(attributeName))
            return missing;
        if("serverMessagesForServerReceiverId".equalsIgnoreCase(attributeName))
            return serverMessagesForServerReceiverId;
        if("serverActivityLogs".equalsIgnoreCase(attributeName))
            return serverActivityLogs;
        if("serverMessagesForServerSenderId".equalsIgnoreCase(attributeName))
            return serverMessagesForServerSenderId;

        return null;
    }

    /**
    * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
    */
    public void setAttribute(String attributeName,Object attributeValue)
    {
        if("id".equalsIgnoreCase(attributeName))
            id =(Long)attributeValue;
        if("name".equalsIgnoreCase(attributeName))
            name =(String)attributeValue;
        if("machineServerUid".equalsIgnoreCase(attributeName))
            machineServerUid =(String)attributeValue;
        if("ipAddress".equalsIgnoreCase(attributeName))
            ipAddress =(String)attributeValue;
        if("contextRoot".equalsIgnoreCase(attributeName))
            contextRoot =(String)attributeValue;
        if("port".equalsIgnoreCase(attributeName))
            port =(String)attributeValue;
        if("endpointBaseUrl".equalsIgnoreCase(attributeName))
            endpointBaseUrl =(String)attributeValue;
        if("bootTime".equalsIgnoreCase(attributeName))
            bootTime =(Timestamp)attributeValue;
        if("lastSync".equalsIgnoreCase(attributeName))
            lastSync =(Timestamp)attributeValue;
        if("active".equalsIgnoreCase(attributeName))
            active =(Boolean)attributeValue;
        if("missing".equalsIgnoreCase(attributeName))
            missing =(Boolean)attributeValue;
        if("serverMessagesForServerReceiverId".equalsIgnoreCase(attributeName))
            serverMessagesForServerReceiverId =(Set<ServerMessage>)attributeValue;
        if("serverActivityLogs".equalsIgnoreCase(attributeName))
            serverActivityLogs =(Set<ServerActivityLog>)attributeValue;
        if("serverMessagesForServerSenderId".equalsIgnoreCase(attributeName))
            serverMessagesForServerSenderId =(Set<ServerMessage>)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** name private attribute */
    private String name;

    /** machineServerUid private attribute */
    private String machineServerUid;

    /** ipAddress private attribute */
    private String ipAddress;

    /** contextRoot private attribute */
    private String contextRoot;

    /** port private attribute */
    private String port;

    /** endpointBaseUrl private attribute */
    private String endpointBaseUrl;

    /** bootTime private attribute */
    private Timestamp bootTime;

    /** lastSync private attribute */
    private Timestamp lastSync;

    /** active private attribute */
    private boolean active;

    /** missing private attribute */
    private boolean missing;

    /** serverMessagesForServerReceiverId private attribute */
    private Set<ServerMessage> serverMessagesForServerReceiverId = new HashSet<ServerMessage>(0);

    /** serverActivityLogs private attribute */
    private Set<ServerActivityLog> serverActivityLogs = new HashSet<ServerActivityLog>(0);

    /** serverMessagesForServerSenderId private attribute */
    private Set<ServerMessage> serverMessagesForServerSenderId = new HashSet<ServerMessage>(0);

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {

        Object value = getAttribute(attributeName);

        if (value == null)
            return "";
        else {
            return value.toString().trim();
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public Server() {
    }

	/** 
	 * minimal constructor
	 *
     * @param name the name
     * @param machineServerUid the machineServerUid
     * @param ipAddress the ipAddress
     * @param contextRoot the contextRoot
     * @param port the port
     * @param endpointBaseUrl the endpointBaseUrl
     * @param bootTime the bootTime
     * @param lastSync the lastSync
    }
	 */
    public Server(String name, String machineServerUid, String ipAddress, String contextRoot, String port, String endpointBaseUrl, Timestamp bootTime, Timestamp lastSync) {
        this.name = name;
        this.machineServerUid = machineServerUid;
        this.ipAddress = ipAddress;
        this.contextRoot = contextRoot;
        this.port = port;
        this.endpointBaseUrl = endpointBaseUrl;
        this.bootTime = bootTime;
        this.lastSync = lastSync;
    }

    /**
     * full constructor
	 *
     * @param name the name
     * @param machineServerUid the machineServerUid
     * @param ipAddress the ipAddress
     * @param contextRoot the contextRoot
     * @param port the port
     * @param endpointBaseUrl the endpointBaseUrl
     * @param bootTime the bootTime
     * @param lastSync the lastSync
     * @param active the active
     * @param missing the missing
     * @param serverMessagesForServerReceiverId the serverMessagesForServerReceiverId
     * @param serverActivityLogs the serverActivityLogs
     * @param serverMessagesForServerSenderId the serverMessagesForServerSenderId
     */
    public Server(String name, String machineServerUid, String ipAddress, String contextRoot, String port, String endpointBaseUrl, Timestamp bootTime, Timestamp lastSync, boolean active, boolean missing, Set<ServerMessage> serverMessagesForServerReceiverId, Set<ServerActivityLog> serverActivityLogs, Set<ServerMessage> serverMessagesForServerSenderId) {
        this.name = name;
        this.machineServerUid = machineServerUid;
        this.ipAddress = ipAddress;
        this.contextRoot = contextRoot;
        this.port = port;
        this.endpointBaseUrl = endpointBaseUrl;
        this.bootTime = bootTime;
        this.lastSync = lastSync;
        this.active = active;
        this.missing = missing;
        this.serverMessagesForServerReceiverId = serverMessagesForServerReceiverId;
        this.serverActivityLogs = serverActivityLogs;
        this.serverMessagesForServerSenderId = serverMessagesForServerSenderId;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id the id
     *
     * @return Server modified instance
     */
    public Server setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * name getter method
     *
     * @return name method
     */
    public String getName() {
        return this.name;
    }
    
    /**       
     * name setter method
     *
     * @param name the name
     *
     * @return Server modified instance
     */
    public Server setName(String name) {
        this.name = name;
        
        return this;
    }
    /**       
     * machineServerUid getter method
     *
     * @return machineServerUid method
     */
    public String getMachineServerUid() {
        return this.machineServerUid;
    }
    
    /**       
     * machineServerUid setter method
     *
     * @param machineServerUid the machineServerUid
     *
     * @return Server modified instance
     */
    public Server setMachineServerUid(String machineServerUid) {
        this.machineServerUid = machineServerUid;
        
        return this;
    }
    /**       
     * ipAddress getter method
     *
     * @return ipAddress method
     */
    public String getIpAddress() {
        return this.ipAddress;
    }
    
    /**       
     * ipAddress setter method
     *
     * @param ipAddress the ipAddress
     *
     * @return Server modified instance
     */
    public Server setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        
        return this;
    }
    /**       
     * contextRoot getter method
     *
     * @return contextRoot method
     */
    public String getContextRoot() {
        return this.contextRoot;
    }
    
    /**       
     * contextRoot setter method
     *
     * @param contextRoot the contextRoot
     *
     * @return Server modified instance
     */
    public Server setContextRoot(String contextRoot) {
        this.contextRoot = contextRoot;
        
        return this;
    }
    /**       
     * port getter method
     *
     * @return port method
     */
    public String getPort() {
        return this.port;
    }
    
    /**       
     * port setter method
     *
     * @param port the port
     *
     * @return Server modified instance
     */
    public Server setPort(String port) {
        this.port = port;
        
        return this;
    }
    /**       
     * endpointBaseUrl getter method
     *
     * @return endpointBaseUrl method
     */
    public String getEndpointBaseUrl() {
        return this.endpointBaseUrl;
    }
    
    /**       
     * endpointBaseUrl setter method
     *
     * @param endpointBaseUrl the endpointBaseUrl
     *
     * @return Server modified instance
     */
    public Server setEndpointBaseUrl(String endpointBaseUrl) {
        this.endpointBaseUrl = endpointBaseUrl;
        
        return this;
    }
    /**       
     * bootTime getter method
     *
     * @return bootTime method
     */
    public Timestamp getBootTime() {
        return this.bootTime;
    }
    
    /**       
     * bootTime setter method
     *
     * @param bootTime the bootTime
     *
     * @return Server modified instance
     */
    public Server setBootTime(Timestamp bootTime) {
        this.bootTime = bootTime;
        
        return this;
    }
    /**       
     * lastSync getter method
     *
     * @return lastSync method
     */
    public Timestamp getLastSync() {
        return this.lastSync;
    }
    
    /**       
     * lastSync setter method
     *
     * @param lastSync the lastSync
     *
     * @return Server modified instance
     */
    public Server setLastSync(Timestamp lastSync) {
        this.lastSync = lastSync;
        
        return this;
    }
    /**       
     * active getter method
     *
     * @return active method
     */
    public boolean isActive() {
        return this.active;
    }
    
    /**       
     * active setter method
     *
     * @param active the active
     *
     * @return Server modified instance
     */
    public Server setActive(boolean active) {
        this.active = active;
        
        return this;
    }
    /**       
     * missing getter method
     *
     * @return missing method
     */
    public boolean isMissing() {
        return this.missing;
    }
    
    /**       
     * missing setter method
     *
     * @param missing the missing
     *
     * @return Server modified instance
     */
    public Server setMissing(boolean missing) {
        this.missing = missing;
        
        return this;
    }
    /**       
     * serverMessagesForServerReceiverId getter method
     *
     * @return serverMessagesForServerReceiverId method
     */
    public Set<ServerMessage> getServerMessagesForServerReceiverId() {
        return this.serverMessagesForServerReceiverId;
    }
    
    /**       
     * serverMessagesForServerReceiverId setter method
     *
     * @param serverMessagesForServerReceiverId the serverMessagesForServerReceiverId
     *
     * @return Server modified instance
     */
    public Server setServerMessagesForServerReceiverId(Set<ServerMessage> serverMessagesForServerReceiverId) {
        this.serverMessagesForServerReceiverId = serverMessagesForServerReceiverId;
        
        return this;
    }
    /**       
     * serverActivityLogs getter method
     *
     * @return serverActivityLogs method
     */
    public Set<ServerActivityLog> getServerActivityLogs() {
        return this.serverActivityLogs;
    }
    
    /**       
     * serverActivityLogs setter method
     *
     * @param serverActivityLogs the serverActivityLogs
     *
     * @return Server modified instance
     */
    public Server setServerActivityLogs(Set<ServerActivityLog> serverActivityLogs) {
        this.serverActivityLogs = serverActivityLogs;
        
        return this;
    }
    /**       
     * serverMessagesForServerSenderId getter method
     *
     * @return serverMessagesForServerSenderId method
     */
    public Set<ServerMessage> getServerMessagesForServerSenderId() {
        return this.serverMessagesForServerSenderId;
    }
    
    /**       
     * serverMessagesForServerSenderId setter method
     *
     * @param serverMessagesForServerSenderId the serverMessagesForServerSenderId
     *
     * @return Server modified instance
     */
    public Server setServerMessagesForServerSenderId(Set<ServerMessage> serverMessagesForServerSenderId) {
        this.serverMessagesForServerSenderId = serverMessagesForServerSenderId;
        
        return this;
    }

    /**
     * Creates a String representation of the Server object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("name").append("='").append(getName()).append("' ");			
        buffer.append("machineServerUid").append("='").append(getMachineServerUid()).append("' ");			
        buffer.append("ipAddress").append("='").append(getIpAddress()).append("' ");			
        buffer.append("contextRoot").append("='").append(getContextRoot()).append("' ");			
        buffer.append("port").append("='").append(getPort()).append("' ");			
        buffer.append("endpointBaseUrl").append("='").append(getEndpointBaseUrl()).append("' ");			
        buffer.append("bootTime").append("='").append(getBootTime()).append("' ");			
        buffer.append("lastSync").append("='").append(getLastSync()).append("' ");			
        buffer.append("active").append("='").append(isActive()).append("' ");			
        buffer.append("missing").append("='").append(isMissing()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the Server object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(Server other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("name".equalsIgnoreCase(attributeName))
        	this.name = attributeValue;

        if ("machineServerUid".equalsIgnoreCase(attributeName))
        	this.machineServerUid = attributeValue;

        if ("ipAddress".equalsIgnoreCase(attributeName))
        	this.ipAddress = attributeValue;

        if ("contextRoot".equalsIgnoreCase(attributeName))
        	this.contextRoot = attributeValue;

        if ("port".equalsIgnoreCase(attributeName))
        	this.port = attributeValue;

        if ("endpointBaseUrl".equalsIgnoreCase(attributeName))
        	this.endpointBaseUrl = attributeValue;

        if ("bootTime".equalsIgnoreCase(attributeName))
            this.bootTime = Timestamp.valueOf(attributeValue);

        if ("lastSync".equalsIgnoreCase(attributeName))
            this.lastSync = Timestamp.valueOf(attributeValue);

        if ("active".equalsIgnoreCase(attributeName))
            this.active = Boolean.valueOf(attributeValue);

        if ("missing".equalsIgnoreCase(attributeName))
            this.missing = Boolean.valueOf(attributeValue);

    }


    /**
     * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
     *
     * @param session the session
     * @param id      the id
     *
     * @return the proxy
     */
    public static Server getProxy(Session session, Long id)
    {
        return(Server)session.load(Server.class,id);
    }

    /**
    * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
    *
    * @param id      the id
    *
    * @return the proxy
    */
    public static Server getProxy(Long id)
    {
        Session session = HibernateUtil.getSessionFactory("DIFRepository").getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        Server result = (Server)session.load(Server.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }


    /**
     * Instanciates an Hibernate data object
     *
     * @param session the session
     * @param id      the id
     *
     * @return the instance
     */
    public static Server getInstance(Session session, Long id)
    {
        return(Server)session.get(Server.class,id);
    }

    /**
    * Instanciates an Hibernate data object
    *
    * @param id      the id
    *
    * @return the instance
    */
    public static Server getInstance(Long id)
    {
        Session session = HibernateUtil.getSessionFactory("DIFRepository").getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        Server result = (Server)session.get(Server.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }

}
