package pt.digitalis.dif.dem.managers.impl.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link Server}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class ServerFieldAttributes extends AbstractBeanAttributesDefinition{

    /** active (Database column: ACTIVE - If the server is active) */
    static public AttributeDefinition active =
        new AttributeDefinition("active")
                .setDescription("If the server is active")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("SERVER")
                .setDatabaseId("ACTIVE")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(boolean.class);

    /** bootTime (Database column: BOOT_TIME - Server startup time stamp) */
    static public AttributeDefinition bootTime =
        new AttributeDefinition("bootTime")
                .setDescription("Server startup time stamp")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("SERVER")
                .setDatabaseId("BOOT_TIME")
                .setMandatory(true)
                .setMaxSize(7)
                .setType(Timestamp.class);

    /** contextRoot (Database column: CONTEXT_ROOT - The app context root) */
    static public AttributeDefinition contextRoot =
        new AttributeDefinition("contextRoot")
                .setDescription("The app context root")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("SERVER")
                .setDatabaseId("CONTEXT_ROOT")
                .setMandatory(true)
                .setMaxSize(100)
                .setType(String.class);

    /** endpointBaseUrl (Database column: ENDPOINT_BASE_URL - The server HTTP base URL) */
    static public AttributeDefinition endpointBaseUrl =
        new AttributeDefinition("endpointBaseUrl")
                .setDescription("The server HTTP base URL")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("SERVER")
                .setDatabaseId("ENDPOINT_BASE_URL")
                .setMandatory(true)
                .setMaxSize(500)
                .setType(String.class);

    /** id (Database column: ID - ID) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDescription("ID")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("SERVER")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(Long.class);

    /** ipAddress (Database column: IP_ADDRESS - The IP address) */
    static public AttributeDefinition ipAddress =
        new AttributeDefinition("ipAddress")
                .setDescription("The IP address")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("SERVER")
                .setDatabaseId("IP_ADDRESS")
                .setMandatory(true)
                .setMaxSize(100)
                .setType(String.class);

    /** lastSync (Database column: LAST_SYNC - Last sync done by the server) */
    static public AttributeDefinition lastSync =
        new AttributeDefinition("lastSync")
                .setDescription("Last sync done by the server")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("SERVER")
                .setDatabaseId("LAST_SYNC")
                .setMandatory(true)
                .setMaxSize(7)
                .setType(Timestamp.class);

    /** machineServerUid (Database column: MACHINE_SERVER_UID - The machine server UID) */
    static public AttributeDefinition machineServerUid =
        new AttributeDefinition("machineServerUid")
                .setDescription("The machine server UID")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("SERVER")
                .setDatabaseId("MACHINE_SERVER_UID")
                .setMandatory(true)
                .setMaxSize(200)
                .setType(String.class);

    /** missing (Database column: MISSING - If the server is missing (too long since keep alive sync)) */
    static public AttributeDefinition missing =
        new AttributeDefinition("missing")
                .setDescription("If the server is missing (too long since keep alive sync)")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("SERVER")
                .setDatabaseId("MISSING")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(boolean.class);

    /** name (Database column: NAME - The server name) */
    static public AttributeDefinition name =
        new AttributeDefinition("name")
                .setDescription("The server name")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("SERVER")
                .setDatabaseId("NAME")
                .setMandatory(true)
                .setMaxSize(500)
                .setType(String.class);

    /** port (Database column: PORT - The server HTTP port) */
    static public AttributeDefinition port =
        new AttributeDefinition("port")
                .setDescription("The server HTTP port")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("SERVER")
                .setDatabaseId("PORT")
                .setMandatory(true)
                .setMaxSize(10)
                .setType(String.class);

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(active.getName(),active);
        map.put(bootTime.getName(),bootTime);
        map.put(contextRoot.getName(),contextRoot);
        map.put(endpointBaseUrl.getName(),endpointBaseUrl);
        map.put(id.getName(),id);
        map.put(ipAddress.getName(),ipAddress);
        map.put(lastSync.getName(),lastSync);
        map.put(machineServerUid.getName(),machineServerUid);
        map.put(missing.getName(),missing);
        map.put(name.getName(),name);
        map.put(port.getName(),port);

        return map;
    }
}