package pt.digitalis.dif.dem.managers.impl.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link SqlDataSource}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class SqlDataSourceFieldAttributes extends AbstractBeanAttributesDefinition{

    /** dialect (Database column: DIALECT - the database dialect) */
    static public AttributeDefinition dialect =
        new AttributeDefinition("dialect")
                .setDescription("the database dialect")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("SQL_DATA_SOURCE")
                .setDatabaseId("DIALECT")
                .setMandatory(true)
                .setMaxSize(100)
                .setType(String.class);

    /** id (Database column: ID - ID column) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDescription("ID column")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("SQL_DATA_SOURCE")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(Long.class);

    /** name (Database column: NAME - Name of the data source) */
    static public AttributeDefinition name =
        new AttributeDefinition("name")
                .setDescription("Name of the data source")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("SQL_DATA_SOURCE")
                .setDatabaseId("NAME")
                .setMandatory(true)
                .setMaxSize(100)
                .setType(String.class);

    /** password (Database column: PASSWORD - Password to connect) */
    static public AttributeDefinition password =
        new AttributeDefinition("password")
                .setDescription("Password to connect")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("SQL_DATA_SOURCE")
                .setDatabaseId("PASSWORD")
                .setMandatory(true)
                .setMaxSize(100)
                .setType(String.class);

    /** url (Database column: URL - URL to connect) */
    static public AttributeDefinition url =
        new AttributeDefinition("url")
                .setDescription("URL to connect")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("SQL_DATA_SOURCE")
                .setDatabaseId("URL")
                .setMandatory(true)
                .setMaxSize(500)
                .setType(String.class);

    /** userName (Database column: USER_NAME - User name to connect) */
    static public AttributeDefinition userName =
        new AttributeDefinition("userName")
                .setDescription("User name to connect")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("SQL_DATA_SOURCE")
                .setDatabaseId("USER_NAME")
                .setMandatory(true)
                .setMaxSize(100)
                .setType(String.class);

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(dialect.getName(),dialect);
        map.put(id.getName(),id);
        map.put(name.getName(),name);
        map.put(password.getName(),password);
        map.put(url.getName(),url);
        map.put(userName.getName(),userName);

        return map;
    }
}