package pt.digitalis.dif.dem.managers.impl.model.data;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.model.utils.IBeanAttributesDataSet;

/**
 * UserAttributes
* Generated on ORM Generator
* DIF build process for the Model layer
*
*/
@SuppressWarnings("serial")
public class UserAttributes extends AbstractBeanRelationsAttributes implements java.io.Serializable, IBeanAttributesDataSet<UserAttributes> {

    /** UserAttributes attributes enumeration */
    public static class Fields
    {
        /** id column */
        public static final String ID ="id";
        /** attributeKey column */
        public static final String ATTRIBUTEKEY ="attributeKey";
        /** attributeValue column */
        public static final String ATTRIBUTEVALUE ="attributeValue";

        /**
         * List of existing fields
         *
         * @return list of field names
         */
        public static List<String> values()
        {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("attributeKey");
            list.add("attributeValue");

            return list;
        }
    }

    /** Field attributes */
    public static UserAttributesFieldAttributes FieldAttributes=new UserAttributesFieldAttributes();

    /**
    * @return the field attributes definitions
    */
    @Override public UserAttributesFieldAttributes getDefinitions()
    {
        return FieldAttributes;
    }

    /**
     * The Class Relations.
     */
    public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations
    {

        /**
        * Instantiates a new relations.
        *
        * @param currentPath the current path
        */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * users relation.
         *
         * @return the users bean relations attributes.
         */
        public Users.Relations users()
        {
            Users c = new Users();
            return c.new Relations(this.buildPath("users"));
        }

        /**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
        /**
         * the ATTRIBUTEKEY path.
         *
         * @return the path
         */
        public String ATTRIBUTEKEY()
        {
            return buildPath(Fields.ATTRIBUTEKEY);
        }
        /**
         * the ATTRIBUTEVALUE path.
         *
         * @return the path
         */
        public String ATTRIBUTEVALUE()
        {
            return buildPath(Fields.ATTRIBUTEVALUE);
        }
    }

    /** The dummy obj. */
    private static UserAttributes dummyObj=new UserAttributes();

    /**
     * Get UserAttributes Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public IDataSet<UserAttributes> getDataSet()
    {
        return new HibernateDataSet<UserAttributes>(UserAttributes.class, HibernateUtil.getSessionFactory("DIFRepository"),
            UserAttributes.getPKFieldListAsString(), UserAttributes.FieldAttributes);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public static IDataSet<UserAttributes> getDataSetInstance()
    {
        return new UserAttributes().getDataSet();
    }

    /**
    * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
    */
    @Override protected Object getAttributeNoGraphNavigation(String attributeName)
    {
        if("id".equalsIgnoreCase(attributeName))
            return id;
        if("users".equalsIgnoreCase(attributeName))
            return users;
        if("attributeKey".equalsIgnoreCase(attributeName))
            return attributeKey;
        if("attributeValue".equalsIgnoreCase(attributeName))
            return attributeValue;

        return null;
    }

    /**
    * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
    */
    public void setAttribute(String attributeName,Object attributeValue)
    {
        if("id".equalsIgnoreCase(attributeName))
            id =(Long)attributeValue;
        if("users".equalsIgnoreCase(attributeName))
            users =(Users)attributeValue;
        if("attributeKey".equalsIgnoreCase(attributeName))
            attributeKey =(String)attributeValue;
        if("attributeValue".equalsIgnoreCase(attributeName))
            attributeValue =(String)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** users private attribute */
    private Users users;

    /** attributeKey private attribute */
    private String attributeKey;

    /** attributeValue private attribute */
    private String attributeValue;

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {

        Object value = getAttribute(attributeName);

        if (value == null)
            return "";
        else {
            return value.toString().trim();
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public UserAttributes() {
    }

	/** 
	 * minimal constructor
	 *
     * @param users the users
     * @param attributeKey the attributeKey
    }
	 */
    public UserAttributes(Users users, String attributeKey) {
        this.users = users;
        this.attributeKey = attributeKey;
    }

    /**
     * full constructor
	 *
     * @param users the users
     * @param attributeKey the attributeKey
     * @param attributeValue the attributeValue
     */
    public UserAttributes(Users users, String attributeKey, String attributeValue) {
        this.users = users;
        this.attributeKey = attributeKey;
        this.attributeValue = attributeValue;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id the id
     *
     * @return UserAttributes modified instance
     */
    public UserAttributes setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * users getter method
     *
     * @return users method
     */
    public Users getUsers() {
        return this.users;
    }
    
    /**       
     * users setter method
     *
     * @param users the users
     *
     * @return UserAttributes modified instance
     */
    public UserAttributes setUsers(Users users) {
        this.users = users;
        
        return this;
    }
    /**       
     * attributeKey getter method
     *
     * @return attributeKey method
     */
    public String getAttributeKey() {
        return this.attributeKey;
    }
    
    /**       
     * attributeKey setter method
     *
     * @param attributeKey the attributeKey
     *
     * @return UserAttributes modified instance
     */
    public UserAttributes setAttributeKey(String attributeKey) {
        this.attributeKey = attributeKey;
        
        return this;
    }
    /**       
     * attributeValue getter method
     *
     * @return attributeValue method
     */
    public String getAttributeValue() {
        return this.attributeValue;
    }
    
    /**       
     * attributeValue setter method
     *
     * @param attributeValue the attributeValue
     *
     * @return UserAttributes modified instance
     */
    public UserAttributes setAttributeValue(String attributeValue) {
        this.attributeValue = attributeValue;
        
        return this;
    }

    /**
     * Creates a String representation of the UserAttributes object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("attributeKey").append("='").append(getAttributeKey()).append("' ");			
        buffer.append("attributeValue").append("='").append(getAttributeValue()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the UserAttributes object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(UserAttributes other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("attributeKey".equalsIgnoreCase(attributeName))
        	this.attributeKey = attributeValue;

        if ("attributeValue".equalsIgnoreCase(attributeName))
        	this.attributeValue = attributeValue;

    }


    /**
     * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
     *
     * @param session the session
     * @param id      the id
     *
     * @return the proxy
     */
    public static UserAttributes getProxy(Session session, Long id)
    {
        return(UserAttributes)session.load(UserAttributes.class,id);
    }

    /**
    * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
    *
    * @param id      the id
    *
    * @return the proxy
    */
    public static UserAttributes getProxy(Long id)
    {
        Session session = HibernateUtil.getSessionFactory("DIFRepository").getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        UserAttributes result = (UserAttributes)session.load(UserAttributes.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }


    /**
     * Instanciates an Hibernate data object
     *
     * @param session the session
     * @param id      the id
     *
     * @return the instance
     */
    public static UserAttributes getInstance(Session session, Long id)
    {
        return(UserAttributes)session.get(UserAttributes.class,id);
    }

    /**
    * Instanciates an Hibernate data object
    *
    * @param id      the id
    *
    * @return the instance
    */
    public static UserAttributes getInstance(Long id)
    {
        Session session = HibernateUtil.getSessionFactory("DIFRepository").getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        UserAttributes result = (UserAttributes)session.get(UserAttributes.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }

}
