package pt.digitalis.dif.dem.managers.impl.model.data;


import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.model.utils.IBeanAttributesDataSet;

/**
 * UserDataConsent
* Generated on ORM Generator
* DIF build process for the Model layer
*
*/
@SuppressWarnings("serial")
public class UserDataConsent extends AbstractBeanRelationsAttributes implements java.io.Serializable, IBeanAttributesDataSet<UserDataConsent> {

    /** UserDataConsent attributes enumeration */
    public static class Fields
    {
        /** id column */
        public static final String ID ="id";
        /** dateGiven column */
        public static final String DATEGIVEN ="dateGiven";
        /** dateConfirmed column */
        public static final String DATECONFIRMED ="dateConfirmed";
        /** dateRevoked column */
        public static final String DATEREVOKED ="dateRevoked";
        /** proofDocumentId column */
        public static final String PROOFDOCUMENTID ="proofDocumentId";
        /** state column */
        public static final String STATE ="state";
        /** details column */
        public static final String DETAILS ="details";

        /**
         * List of existing fields
         *
         * @return list of field names
         */
        public static List<String> values()
        {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("dateGiven");
            list.add("dateConfirmed");
            list.add("dateRevoked");
            list.add("proofDocumentId");
            list.add("state");
            list.add("details");

            return list;
        }
    }

    /** Field attributes */
    public static UserDataConsentFieldAttributes FieldAttributes=new UserDataConsentFieldAttributes();

    /**
    * @return the field attributes definitions
    */
    @Override public UserDataConsentFieldAttributes getDefinitions()
    {
        return FieldAttributes;
    }

    /**
     * The Class Relations.
     */
    public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations
    {

        /**
        * Instantiates a new relations.
        *
        * @param currentPath the current path
        */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * dataConsent relation.
         *
         * @return the dataConsent bean relations attributes.
         */
        public DataConsent.Relations dataConsent()
        {
            DataConsent c = new DataConsent();
            return c.new Relations(this.buildPath("dataConsent"));
        }

        /**
         * dataConsentUser relation.
         *
         * @return the dataConsentUser bean relations attributes.
         */
        public DataConsentUser.Relations dataConsentUser()
        {
            DataConsentUser c = new DataConsentUser();
            return c.new Relations(this.buildPath("dataConsentUser"));
        }

        /**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
        /**
         * the DATEGIVEN path.
         *
         * @return the path
         */
        public String DATEGIVEN()
        {
            return buildPath(Fields.DATEGIVEN);
        }
        /**
         * the DATECONFIRMED path.
         *
         * @return the path
         */
        public String DATECONFIRMED()
        {
            return buildPath(Fields.DATECONFIRMED);
        }
        /**
         * the DATEREVOKED path.
         *
         * @return the path
         */
        public String DATEREVOKED()
        {
            return buildPath(Fields.DATEREVOKED);
        }
        /**
         * the PROOFDOCUMENTID path.
         *
         * @return the path
         */
        public String PROOFDOCUMENTID()
        {
            return buildPath(Fields.PROOFDOCUMENTID);
        }
        /**
         * the STATE path.
         *
         * @return the path
         */
        public String STATE()
        {
            return buildPath(Fields.STATE);
        }
        /**
         * the DETAILS path.
         *
         * @return the path
         */
        public String DETAILS()
        {
            return buildPath(Fields.DETAILS);
        }
    }

    /** The dummy obj. */
    private static UserDataConsent dummyObj=new UserDataConsent();

    /**
     * Get UserDataConsent Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public IDataSet<UserDataConsent> getDataSet()
    {
        return new HibernateDataSet<UserDataConsent>(UserDataConsent.class, HibernateUtil.getSessionFactory("DIFRepository"),
            UserDataConsent.getPKFieldListAsString(), UserDataConsent.FieldAttributes);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public static IDataSet<UserDataConsent> getDataSetInstance()
    {
        return new UserDataConsent().getDataSet();
    }

    /**
    * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
    */
    @Override protected Object getAttributeNoGraphNavigation(String attributeName)
    {
        if("id".equalsIgnoreCase(attributeName))
            return id;
        if("dataConsent".equalsIgnoreCase(attributeName))
            return dataConsent;
        if("dataConsentUser".equalsIgnoreCase(attributeName))
            return dataConsentUser;
        if("dateGiven".equalsIgnoreCase(attributeName))
            return dateGiven;
        if("dateConfirmed".equalsIgnoreCase(attributeName))
            return dateConfirmed;
        if("dateRevoked".equalsIgnoreCase(attributeName))
            return dateRevoked;
        if("proofDocumentId".equalsIgnoreCase(attributeName))
            return proofDocumentId;
        if("state".equalsIgnoreCase(attributeName))
            return state;
        if("details".equalsIgnoreCase(attributeName))
            return details;

        return null;
    }

    /**
    * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
    */
    public void setAttribute(String attributeName,Object attributeValue)
    {
        if("id".equalsIgnoreCase(attributeName))
            id =(Long)attributeValue;
        if("dataConsent".equalsIgnoreCase(attributeName))
            dataConsent =(DataConsent)attributeValue;
        if("dataConsentUser".equalsIgnoreCase(attributeName))
            dataConsentUser =(DataConsentUser)attributeValue;
        if("dateGiven".equalsIgnoreCase(attributeName))
            dateGiven =(Timestamp)attributeValue;
        if("dateConfirmed".equalsIgnoreCase(attributeName))
            dateConfirmed =(Timestamp)attributeValue;
        if("dateRevoked".equalsIgnoreCase(attributeName))
            dateRevoked =(Timestamp)attributeValue;
        if("proofDocumentId".equalsIgnoreCase(attributeName))
            proofDocumentId =(Long)attributeValue;
        if("state".equalsIgnoreCase(attributeName))
            state =(String)attributeValue;
        if("details".equalsIgnoreCase(attributeName))
            details =(String)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** dataConsent private attribute */
    private DataConsent dataConsent;

    /** dataConsentUser private attribute */
    private DataConsentUser dataConsentUser;

    /** dateGiven private attribute */
    private Timestamp dateGiven;

    /** dateConfirmed private attribute */
    private Timestamp dateConfirmed;

    /** dateRevoked private attribute */
    private Timestamp dateRevoked;

    /** proofDocumentId private attribute */
    private Long proofDocumentId;

    /** state private attribute */
    private String state;

    /** details private attribute */
    private String details;

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {

        Object value = getAttribute(attributeName);

        if (value == null)
            return "";
        else {
            return value.toString().trim();
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public UserDataConsent() {
    }

	/** 
	 * minimal constructor
	 *
     * @param dataConsent the dataConsent
     * @param dateGiven the dateGiven
     * @param state the state
    }
	 */
    public UserDataConsent(DataConsent dataConsent, Timestamp dateGiven, String state) {
        this.dataConsent = dataConsent;
        this.dateGiven = dateGiven;
        this.state = state;
    }

    /**
     * full constructor
	 *
     * @param dataConsent the dataConsent
     * @param dataConsentUser the dataConsentUser
     * @param dateGiven the dateGiven
     * @param dateConfirmed the dateConfirmed
     * @param dateRevoked the dateRevoked
     * @param proofDocumentId the proofDocumentId
     * @param state the state
     * @param details the details
     */
    public UserDataConsent(DataConsent dataConsent, DataConsentUser dataConsentUser, Timestamp dateGiven, Timestamp dateConfirmed, Timestamp dateRevoked, Long proofDocumentId, String state, String details) {
        this.dataConsent = dataConsent;
        this.dataConsentUser = dataConsentUser;
        this.dateGiven = dateGiven;
        this.dateConfirmed = dateConfirmed;
        this.dateRevoked = dateRevoked;
        this.proofDocumentId = proofDocumentId;
        this.state = state;
        this.details = details;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id the id
     *
     * @return UserDataConsent modified instance
     */
    public UserDataConsent setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * dataConsent getter method
     *
     * @return dataConsent method
     */
    public DataConsent getDataConsent() {
        return this.dataConsent;
    }
    
    /**       
     * dataConsent setter method
     *
     * @param dataConsent the dataConsent
     *
     * @return UserDataConsent modified instance
     */
    public UserDataConsent setDataConsent(DataConsent dataConsent) {
        this.dataConsent = dataConsent;
        
        return this;
    }
    /**       
     * dataConsentUser getter method
     *
     * @return dataConsentUser method
     */
    public DataConsentUser getDataConsentUser() {
        return this.dataConsentUser;
    }
    
    /**       
     * dataConsentUser setter method
     *
     * @param dataConsentUser the dataConsentUser
     *
     * @return UserDataConsent modified instance
     */
    public UserDataConsent setDataConsentUser(DataConsentUser dataConsentUser) {
        this.dataConsentUser = dataConsentUser;
        
        return this;
    }
    /**       
     * dateGiven getter method
     *
     * @return dateGiven method
     */
    public Timestamp getDateGiven() {
        return this.dateGiven;
    }
    
    /**       
     * dateGiven setter method
     *
     * @param dateGiven the dateGiven
     *
     * @return UserDataConsent modified instance
     */
    public UserDataConsent setDateGiven(Timestamp dateGiven) {
        this.dateGiven = dateGiven;
        
        return this;
    }
    /**       
     * dateConfirmed getter method
     *
     * @return dateConfirmed method
     */
    public Timestamp getDateConfirmed() {
        return this.dateConfirmed;
    }
    
    /**       
     * dateConfirmed setter method
     *
     * @param dateConfirmed the dateConfirmed
     *
     * @return UserDataConsent modified instance
     */
    public UserDataConsent setDateConfirmed(Timestamp dateConfirmed) {
        this.dateConfirmed = dateConfirmed;
        
        return this;
    }
    /**       
     * dateRevoked getter method
     *
     * @return dateRevoked method
     */
    public Timestamp getDateRevoked() {
        return this.dateRevoked;
    }
    
    /**       
     * dateRevoked setter method
     *
     * @param dateRevoked the dateRevoked
     *
     * @return UserDataConsent modified instance
     */
    public UserDataConsent setDateRevoked(Timestamp dateRevoked) {
        this.dateRevoked = dateRevoked;
        
        return this;
    }
    /**       
     * proofDocumentId getter method
     *
     * @return proofDocumentId method
     */
    public Long getProofDocumentId() {
        return this.proofDocumentId;
    }
    
    /**       
     * proofDocumentId setter method
     *
     * @param proofDocumentId the proofDocumentId
     *
     * @return UserDataConsent modified instance
     */
    public UserDataConsent setProofDocumentId(Long proofDocumentId) {
        this.proofDocumentId = proofDocumentId;
        
        return this;
    }
    /**       
     * state getter method
     *
     * @return state method
     */
    public String getState() {
        return this.state;
    }
    
    /**       
     * state setter method
     *
     * @param state the state
     *
     * @return UserDataConsent modified instance
     */
    public UserDataConsent setState(String state) {
        this.state = state;
        
        return this;
    }
    /**       
     * details getter method
     *
     * @return details method
     */
    public String getDetails() {
        return this.details;
    }
    
    /**       
     * details setter method
     *
     * @param details the details
     *
     * @return UserDataConsent modified instance
     */
    public UserDataConsent setDetails(String details) {
        this.details = details;
        
        return this;
    }

    /**
     * Creates a String representation of the UserDataConsent object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("dateGiven").append("='").append(getDateGiven()).append("' ");			
        buffer.append("dateConfirmed").append("='").append(getDateConfirmed()).append("' ");			
        buffer.append("dateRevoked").append("='").append(getDateRevoked()).append("' ");			
        buffer.append("proofDocumentId").append("='").append(getProofDocumentId()).append("' ");			
        buffer.append("state").append("='").append(getState()).append("' ");			
        buffer.append("details").append("='").append(getDetails()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the UserDataConsent object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(UserDataConsent other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("dateGiven".equalsIgnoreCase(attributeName))
            this.dateGiven = Timestamp.valueOf(attributeValue);

        if ("dateConfirmed".equalsIgnoreCase(attributeName))
            this.dateConfirmed = Timestamp.valueOf(attributeValue);

        if ("dateRevoked".equalsIgnoreCase(attributeName))
            this.dateRevoked = Timestamp.valueOf(attributeValue);

        if ("proofDocumentId".equalsIgnoreCase(attributeName))
            this.proofDocumentId = Long.valueOf(attributeValue);

        if ("state".equalsIgnoreCase(attributeName))
        	this.state = attributeValue;

        if ("details".equalsIgnoreCase(attributeName))
        	this.details = attributeValue;

    }


    /**
     * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
     *
     * @param session the session
     * @param id      the id
     *
     * @return the proxy
     */
    public static UserDataConsent getProxy(Session session, Long id)
    {
        return(UserDataConsent)session.load(UserDataConsent.class,id);
    }

    /**
    * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
    *
    * @param id      the id
    *
    * @return the proxy
    */
    public static UserDataConsent getProxy(Long id)
    {
        Session session = HibernateUtil.getSessionFactory("DIFRepository").getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        UserDataConsent result = (UserDataConsent)session.load(UserDataConsent.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }


    /**
     * Instanciates an Hibernate data object
     *
     * @param session the session
     * @param id      the id
     *
     * @return the instance
     */
    public static UserDataConsent getInstance(Session session, Long id)
    {
        return(UserDataConsent)session.get(UserDataConsent.class,id);
    }

    /**
    * Instanciates an Hibernate data object
    *
    * @param id      the id
    *
    * @return the instance
    */
    public static UserDataConsent getInstance(Long id)
    {
        Session session = HibernateUtil.getSessionFactory("DIFRepository").getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        UserDataConsent result = (UserDataConsent)session.get(UserDataConsent.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }

}
