package pt.digitalis.dif.dem.managers.impl.model.data;

import pt.digitalis.utils.common.AttributeDefinition;
import pt.digitalis.dif.model.utils.AbstractBeanAttributesDefinition;

import java.sql.Timestamp;
import java.sql.Blob;
import java.util.Date;
import java.math.BigDecimal;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

import org.hibernate.Session;


/**
 *  Field definitions for data object {@link UserDataConsent}
 *
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class UserDataConsentFieldAttributes extends AbstractBeanAttributesDefinition{

    /** dataConsent (Database column: CONSENT_ID - The consent the user accepted) */
    static public AttributeDefinition dataConsent =
        new AttributeDefinition("dataConsent")
                .setDescription("The consent the user accepted")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("USER_DATA_CONSENT")
                .setDatabaseId("CONSENT_ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setLovDataClass(pt.digitalis.dif.dem.managers.impl.model.data.DataConsent.class)
                .setLovDataClassKey("id")
                .setLovDataClassDescription("description")
                .setType(pt.digitalis.dif.dem.managers.impl.model.data.DataConsent.class);

    /** dataConsentUser (Database column: DATA_CONSENT_USER_ID - The consent user record ID) */
    static public AttributeDefinition dataConsentUser =
        new AttributeDefinition("dataConsentUser")
                .setDescription("The consent user record ID")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("USER_DATA_CONSENT")
                .setDatabaseId("DATA_CONSENT_USER_ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(pt.digitalis.dif.dem.managers.impl.model.data.DataConsentUser.class);

    /** dateConfirmed (Database column: DATE_CONFIRMED - The date the user confirmed his consent) */
    static public AttributeDefinition dateConfirmed =
        new AttributeDefinition("dateConfirmed")
                .setDescription("The date the user confirmed his consent")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("USER_DATA_CONSENT")
                .setDatabaseId("DATE_CONFIRMED")
                .setMandatory(true)
                .setMaxSize(7)
                .setType(Timestamp.class);

    /** dateGiven (Database column: DATE_GIVEN - The date the user gave consent) */
    static public AttributeDefinition dateGiven =
        new AttributeDefinition("dateGiven")
                .setDescription("The date the user gave consent")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("USER_DATA_CONSENT")
                .setDatabaseId("DATE_GIVEN")
                .setMandatory(true)
                .setMaxSize(7)
                .setType(Timestamp.class);

    /** dateRevoked (Database column: DATE_REVOKED - The date the user revoked the given consent) */
    static public AttributeDefinition dateRevoked =
        new AttributeDefinition("dateRevoked")
                .setDescription("The date the user revoked the given consent")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("USER_DATA_CONSENT")
                .setDatabaseId("DATE_REVOKED")
                .setMandatory(true)
                .setMaxSize(7)
                .setType(Timestamp.class);

    /** details (Database column: DETAILS - Details in JSON format of the consent given (when there is more than a simples yes or no)) */
    static public AttributeDefinition details =
        new AttributeDefinition("details")
                .setDescription("Details in JSON format of the consent given (when there is more than a simples yes or no)")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("USER_DATA_CONSENT")
                .setDatabaseId("DETAILS")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(String.class);

    /** id (Database column: ID - ID) */
    static public AttributeDefinition id =
        new AttributeDefinition("id")
                .setDescription("ID")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("USER_DATA_CONSENT")
                .setDatabaseId("ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(Long.class);

    /** proofDocumentId (Database column: PROOF_DOCUMENT_ID - The document the user upload as proof of his consent) */
    static public AttributeDefinition proofDocumentId =
        new AttributeDefinition("proofDocumentId")
                .setDescription("The document the user upload as proof of his consent")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("USER_DATA_CONSENT")
                .setDatabaseId("PROOF_DOCUMENT_ID")
                .setMandatory(true)
                .setMaxSize(255)
                .setType(Long.class);

    /** state (Database column: STATE - The consent state) */
    static public AttributeDefinition state =
        new AttributeDefinition("state")
                .setDescription("The consent state")
                .setDatabaseSchema("DIF")
                .setDatabaseTable("USER_DATA_CONSENT")
                .setDatabaseId("STATE")
                .setMandatory(true)
                .setMaxSize(1)
                .setType(String.class);

    /**
    * Create definitions map map.
    *
    * @return the map
    */
    @Override protected CaseInsensitiveHashMap<AttributeDefinition> createDefinitionsMap(){
        CaseInsensitiveHashMap<AttributeDefinition> map = new CaseInsensitiveHashMap<AttributeDefinition>();
        map.put(dataConsent.getName(),dataConsent);
        map.put(dataConsentUser.getName(),dataConsentUser);
        map.put(dateConfirmed.getName(),dateConfirmed);
        map.put(dateGiven.getName(),dateGiven);
        map.put(dateRevoked.getName(),dateRevoked);
        map.put(details.getName(),details);
        map.put(id.getName(),id);
        map.put(proofDocumentId.getName(),proofDocumentId);
        map.put(state.getName(),state);

        return map;
    }
}