package pt.digitalis.dif.dem.managers.impl.model.data;


import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.model.utils.IBeanAttributesDataSet;

/**
 * UserDataRequestComment
* Generated on ORM Generator
* DIF build process for the Model layer
*
*/
@SuppressWarnings("serial")
public class UserDataRequestComment extends AbstractBeanRelationsAttributes implements java.io.Serializable, IBeanAttributesDataSet<UserDataRequestComment> {

    /** UserDataRequestComment attributes enumeration */
    public static class Fields
    {
        /** id column */
        public static final String ID ="id";
        /** userId column */
        public static final String USERID ="userId";
        /** commentBody column */
        public static final String COMMENTBODY ="commentBody";
        /** commentDate column */
        public static final String COMMENTDATE ="commentDate";

        /**
         * List of existing fields
         *
         * @return list of field names
         */
        public static List<String> values()
        {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("userId");
            list.add("commentBody");
            list.add("commentDate");

            return list;
        }
    }

    /** Field attributes */
    public static UserDataRequestCommentFieldAttributes FieldAttributes=new UserDataRequestCommentFieldAttributes();

    /**
    * @return the field attributes definitions
    */
    @Override public UserDataRequestCommentFieldAttributes getDefinitions()
    {
        return FieldAttributes;
    }

    /**
     * The Class Relations.
     */
    public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations
    {

        /**
        * Instantiates a new relations.
        *
        * @param currentPath the current path
        */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * userDataRequest relation.
         *
         * @return the userDataRequest bean relations attributes.
         */
        public UserDataRequest.Relations userDataRequest()
        {
            UserDataRequest c = new UserDataRequest();
            return c.new Relations(this.buildPath("userDataRequest"));
        }

        /**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
        /**
         * the USERID path.
         *
         * @return the path
         */
        public String USERID()
        {
            return buildPath(Fields.USERID);
        }
        /**
         * the COMMENTBODY path.
         *
         * @return the path
         */
        public String COMMENTBODY()
        {
            return buildPath(Fields.COMMENTBODY);
        }
        /**
         * the COMMENTDATE path.
         *
         * @return the path
         */
        public String COMMENTDATE()
        {
            return buildPath(Fields.COMMENTDATE);
        }
    }

    /** The dummy obj. */
    private static UserDataRequestComment dummyObj=new UserDataRequestComment();

    /**
     * Get UserDataRequestComment Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public IDataSet<UserDataRequestComment> getDataSet()
    {
        return new HibernateDataSet<UserDataRequestComment>(UserDataRequestComment.class, HibernateUtil.getSessionFactory("DIFRepository"),
            UserDataRequestComment.getPKFieldListAsString(), UserDataRequestComment.FieldAttributes);
    }

    /**
    * Gets a new dataSet object for this bean
    *
    * @return the dataSet
    */
    public static IDataSet<UserDataRequestComment> getDataSetInstance()
    {
        return new UserDataRequestComment().getDataSet();
    }

    /**
    * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
    */
    @Override protected Object getAttributeNoGraphNavigation(String attributeName)
    {
        if("id".equalsIgnoreCase(attributeName))
            return id;
        if("userDataRequest".equalsIgnoreCase(attributeName))
            return userDataRequest;
        if("userId".equalsIgnoreCase(attributeName))
            return userId;
        if("commentBody".equalsIgnoreCase(attributeName))
            return commentBody;
        if("commentDate".equalsIgnoreCase(attributeName))
            return commentDate;

        return null;
    }

    /**
    * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
    */
    public void setAttribute(String attributeName,Object attributeValue)
    {
        if("id".equalsIgnoreCase(attributeName))
            id =(Long)attributeValue;
        if("userDataRequest".equalsIgnoreCase(attributeName))
            userDataRequest =(UserDataRequest)attributeValue;
        if("userId".equalsIgnoreCase(attributeName))
            userId =(String)attributeValue;
        if("commentBody".equalsIgnoreCase(attributeName))
            commentBody =(String)attributeValue;
        if("commentDate".equalsIgnoreCase(attributeName))
            commentDate =(Timestamp)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** userDataRequest private attribute */
    private UserDataRequest userDataRequest;

    /** userId private attribute */
    private String userId;

    /** commentBody private attribute */
    private String commentBody;

    /** commentDate private attribute */
    private Timestamp commentDate;

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {

        Object value = getAttribute(attributeName);

        if (value == null)
            return "";
        else {
            return value.toString().trim();
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public UserDataRequestComment() {
    }


    /**
     * full constructor
	 *
     * @param userDataRequest the userDataRequest
     * @param userId the userId
     * @param commentBody the commentBody
     * @param commentDate the commentDate
     */
    public UserDataRequestComment(UserDataRequest userDataRequest, String userId, String commentBody, Timestamp commentDate) {
        this.userDataRequest = userDataRequest;
        this.userId = userId;
        this.commentBody = commentBody;
        this.commentDate = commentDate;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id the id
     *
     * @return UserDataRequestComment modified instance
     */
    public UserDataRequestComment setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * userDataRequest getter method
     *
     * @return userDataRequest method
     */
    public UserDataRequest getUserDataRequest() {
        return this.userDataRequest;
    }
    
    /**       
     * userDataRequest setter method
     *
     * @param userDataRequest the userDataRequest
     *
     * @return UserDataRequestComment modified instance
     */
    public UserDataRequestComment setUserDataRequest(UserDataRequest userDataRequest) {
        this.userDataRequest = userDataRequest;
        
        return this;
    }
    /**       
     * userId getter method
     *
     * @return userId method
     */
    public String getUserId() {
        return this.userId;
    }
    
    /**       
     * userId setter method
     *
     * @param userId the userId
     *
     * @return UserDataRequestComment modified instance
     */
    public UserDataRequestComment setUserId(String userId) {
        this.userId = userId;
        
        return this;
    }
    /**       
     * commentBody getter method
     *
     * @return commentBody method
     */
    public String getCommentBody() {
        return this.commentBody;
    }
    
    /**       
     * commentBody setter method
     *
     * @param commentBody the commentBody
     *
     * @return UserDataRequestComment modified instance
     */
    public UserDataRequestComment setCommentBody(String commentBody) {
        this.commentBody = commentBody;
        
        return this;
    }
    /**       
     * commentDate getter method
     *
     * @return commentDate method
     */
    public Timestamp getCommentDate() {
        return this.commentDate;
    }
    
    /**       
     * commentDate setter method
     *
     * @param commentDate the commentDate
     *
     * @return UserDataRequestComment modified instance
     */
    public UserDataRequestComment setCommentDate(Timestamp commentDate) {
        this.commentDate = commentDate;
        
        return this;
    }

    /**
     * Creates a String representation of the UserDataRequestComment object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("userId").append("='").append(getUserId()).append("' ");			
        buffer.append("commentBody").append("='").append(getCommentBody()).append("' ");			
        buffer.append("commentDate").append("='").append(getCommentDate()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the UserDataRequestComment object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(UserDataRequestComment other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("userId".equalsIgnoreCase(attributeName))
        	this.userId = attributeValue;

        if ("commentBody".equalsIgnoreCase(attributeName))
        	this.commentBody = attributeValue;

        if ("commentDate".equalsIgnoreCase(attributeName))
            this.commentDate = Timestamp.valueOf(attributeValue);

    }


    /**
     * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
     *
     * @param session the session
     * @param id      the id
     *
     * @return the proxy
     */
    public static UserDataRequestComment getProxy(Session session, Long id)
    {
        return(UserDataRequestComment)session.load(UserDataRequestComment.class,id);
    }

    /**
    * Instanciates an Hibernate proxy data object (does not load it from the database, provides lazy load for that)
    *
    * @param id      the id
    *
    * @return the proxy
    */
    public static UserDataRequestComment getProxy(Long id)
    {
        Session session = HibernateUtil.getSessionFactory("DIFRepository").getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        UserDataRequestComment result = (UserDataRequestComment)session.load(UserDataRequestComment.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }


    /**
     * Instanciates an Hibernate data object
     *
     * @param session the session
     * @param id      the id
     *
     * @return the instance
     */
    public static UserDataRequestComment getInstance(Session session, Long id)
    {
        return(UserDataRequestComment)session.get(UserDataRequestComment.class,id);
    }

    /**
    * Instanciates an Hibernate data object
    *
    * @param id      the id
    *
    * @return the instance
    */
    public static UserDataRequestComment getInstance(Long id)
    {
        Session session = HibernateUtil.getSessionFactory("DIFRepository").getCurrentSession();
        boolean wasActive = session.getTransaction().isActive();

        if (!wasActive)
            session.beginTransaction();

        UserDataRequestComment result = (UserDataRequestComment)session.get(UserDataRequestComment.class,id);

        if (!wasActive)
            session.getTransaction().commit();

        return result;
    }

}
